/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.tck;

import io.micronaut.core.annotation.Nullable;
import java.util.Arrays;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;

public final class BodyAssertion<T, E> {
    public static final BodyAssertion<?, ?> IS_MISSING = new BodyAssertion<Object, Object>(Object.class, Object.class, null, new BodyEvaluator<Object>(){

        @Override
        public EvaluatorType type() {
            return EvaluatorType.EQUAL;
        }

        @Override
        public boolean test(Object o, Object o2) {
            return o == null && o2 == null;
        }

        @Override
        public String message(Object expected, Object actual) {
            return "Body not expected. Got: " + actual;
        }
    });
    private final Class<T> bodyType;
    private final Class<E> errorType;
    private final T expected;
    private final BodyEvaluator<T> evaluator;

    private BodyAssertion(Class<T> bodyType, Class<E> errorType, T expected, BodyEvaluator<T> evaluator) {
        this.bodyType = bodyType;
        this.errorType = errorType;
        this.expected = expected;
        this.evaluator = evaluator;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void evaluate(Object body) {
        Assertions.assertTrue((boolean)this.evaluator.test(this.expected, body), () -> this.evaluator.message(this.expected, body));
    }

    public Class<T> getBodyType() {
        return this.bodyType;
    }

    @Nullable
    public Class<E> getErrorType() {
        return this.errorType;
    }

    private static interface BodyEvaluator<T>
    extends BiPredicate<T, T> {
        public EvaluatorType type();

        default public String render(T value) {
            return String.valueOf(value);
        }

        default public String message(T expected, T actual) {
            return "Expected received body of '" + this.render(actual) + "' to " + this.type().name().toLowerCase() + " '" + this.render(expected) + "'";
        }
    }

    public static class Builder {
        public AssertionBuilder<String, String> body(String expected) {
            return new StringBodyAssertionBuilder(expected);
        }

        public AssertionBuilder<byte[], byte[]> body(byte[] expected) {
            return new ByteArrayBodyAssertionBuilder(expected);
        }
    }

    private record ByteArrayEvaluator(EvaluatorType type) implements BodyEvaluator<byte[]>
    {
        @Override
        public String render(byte[] value) {
            if (value == null) {
                return "null";
            }
            String firstTen = IntStream.range(0, value.length).map(i -> value[i] & 0xFF).mapToObj(arg_0 -> ByteArrayEvaluator.lambda$render$1("%02x", arg_0)).limit(10L).collect(Collectors.joining(", ", "", "..."));
            return "ByteArray(length=" + value.length + ", [" + firstTen + "])";
        }

        @Override
        public boolean test(byte[] expected, byte[] received) {
            switch (this.type) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case EQUAL: {
                    break;
                }
                case CONTAIN: 
                case DOESNT_CONTAIN: {
                    throw new AssertionError((Object)"Not implemented yet!");
                }
            }
            return Arrays.equals(received, expected);
        }

        private static /* synthetic */ String lambda$render$1(String rec$, Object xva$0) {
            return "%02x".formatted(xva$0);
        }
    }

    private record StringEvaluator(EvaluatorType type) implements BodyEvaluator<String>
    {
        @Override
        public boolean test(String expected, String received) {
            return switch (this.type) {
                default -> throw new IncompatibleClassChangeError();
                case EvaluatorType.EQUAL -> received.equals(expected);
                case EvaluatorType.CONTAIN -> received.contains(expected);
                case EvaluatorType.DOESNT_CONTAIN -> !received.contains(expected);
            };
        }
    }

    public static class ByteArrayBodyAssertionBuilder
    extends Builder
    implements AssertionBuilder<byte[], byte[]> {
        private final byte[] body;

        public ByteArrayBodyAssertionBuilder(byte[] expected) {
            this.body = expected;
        }

        @Override
        public BodyAssertion<byte[], byte[]> doesntContain() {
            return new BodyAssertion<byte[], byte[]>(byte[].class, byte[].class, this.body, new ByteArrayEvaluator(EvaluatorType.DOESNT_CONTAIN));
        }

        @Override
        public BodyAssertion<byte[], byte[]> contains() {
            return new BodyAssertion<byte[], byte[]>(byte[].class, byte[].class, this.body, new ByteArrayEvaluator(EvaluatorType.CONTAIN));
        }

        @Override
        public BodyAssertion<byte[], byte[]> equals() {
            return new BodyAssertion<byte[], byte[]>(byte[].class, byte[].class, this.body, new ByteArrayEvaluator(EvaluatorType.EQUAL));
        }
    }

    public static class StringBodyAssertionBuilder
    extends Builder
    implements AssertionBuilder<String, String> {
        private final String body;

        public StringBodyAssertionBuilder(String expected) {
            this.body = expected;
        }

        @Override
        public BodyAssertion<String, String> doesntContain() {
            return new BodyAssertion<String, String>(String.class, String.class, this.body, new StringEvaluator(EvaluatorType.DOESNT_CONTAIN));
        }

        @Override
        public BodyAssertion<String, String> contains() {
            return new BodyAssertion<String, String>(String.class, String.class, this.body, new StringEvaluator(EvaluatorType.CONTAIN));
        }

        @Override
        public BodyAssertion<String, String> equals() {
            return new BodyAssertion<String, String>(String.class, String.class, this.body, new StringEvaluator(EvaluatorType.EQUAL));
        }
    }

    public static interface AssertionBuilder<T, E> {
        public BodyAssertion<T, E> doesntContain();

        public BodyAssertion<T, E> contains();

        public BodyAssertion<T, E> equals();
    }

    private static enum EvaluatorType {
        EQUAL,
        CONTAIN,
        DOESNT_CONTAIN;

    }
}

