/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.tck.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestLeakDetector {
    private static final Logger LOG = LoggerFactory.getLogger(TestLeakDetector.class);
    private static final String BASE_CANARY_STRING = "canary-" + String.valueOf(UUID.randomUUID()) + "-";
    private static final List<ResourceLeakDetector<?>> ALL_DETECTORS = new CopyOnWriteArrayList();
    private static volatile boolean leakDetected;
    private static volatile boolean canaryDetected;
    private static volatile String canaryString;
    private static volatile long sink;

    private TestLeakDetector() {
    }

    public static void init() {
    }

    public static void startTracking(String testName) {
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.PARANOID);
        TestLeakDetector.triggerGc();
        leakDetected = false;
        LOG.debug("Starting resource leak tracking");
    }

    public static void stopTrackingAndReportLeaks() {
        TestLeakDetector.triggerGc();
        if (leakDetected) {
            throw new RuntimeException("Detected a resource leak. Please check logs");
        }
        LOG.debug("No resource leak detected");
    }

    private static void leakCanary() {
        ByteBuf resource = ByteBufAllocator.DEFAULT.directBuffer();
        resource.touch((Object)canaryString);
    }

    private static void triggerGc() {
        long startTime = System.nanoTime();
        canaryString = BASE_CANARY_STRING + String.valueOf(UUID.randomUUID());
        canaryDetected = false;
        TestLeakDetector.leakCanary();
        do {
            if (System.nanoTime() - startTime > 30000000000L) {
                LOG.warn("Canary leak detection failed.");
                break;
            }
            System.gc();
            for (ResourceLeakDetector<?> detector : ALL_DETECTORS) {
                Object obj;
                ResourceLeakTracker track = detector.track(obj = new Object());
                if (track == null) {
                    throw new RuntimeException("getLevel: " + String.valueOf(ResourceLeakDetector.getLevel()) + " detector: " + String.valueOf(detector));
                }
                track.close(obj);
            }
            for (int i = 0; i < 1000; ++i) {
                sink = System.identityHashCode(new byte[10000]);
            }
        } while (!canaryDetected && !Thread.interrupted());
    }

    static {
        System.setProperty("io.netty.leakDetection.level", "paranoid");
        ResourceLeakDetectorFactory.setResourceLeakDetectorFactory((ResourceLeakDetectorFactory)new ResourceLeakDetectorFactory(){

            public <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> resource, int samplingInterval, long maxActive) {
                return new TestResourceLeakDetector(resource, samplingInterval);
            }

            public <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> resource, int samplingInterval) {
                return new TestResourceLeakDetector(resource, samplingInterval);
            }
        });
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.PARANOID);
    }

    private static final class TestResourceLeakDetector<T>
    extends ResourceLeakDetector<T> {
        public TestResourceLeakDetector(Class<?> resourceType, int samplingInterval) {
            super(resourceType, samplingInterval);
            ALL_DETECTORS.add(this);
        }

        protected boolean needReport() {
            return true;
        }

        protected void reportTracedLeak(String resourceType, String records) {
            String canary = canaryString;
            if (canary != null && records.contains(canary)) {
                canaryDetected = true;
                return;
            }
            if (records.contains(BASE_CANARY_STRING)) {
                return;
            }
            leakDetected = true;
            super.reportTracedLeak(resourceType, records);
        }

        protected void reportUntracedLeak(String resourceType) {
            leakDetected = true;
            super.reportUntracedLeak(resourceType);
        }
    }
}

