/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.routes;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.ClientFilter;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.annotation.ResponseFilter;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.http.filter.FilterContinuation;
import io.micronaut.http.filter.FilterRunner;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class FilterVisitor
implements TypeElementVisitor<Object, Object> {
    private static final Set<Class<?>> PERMITTED_CLASSES = Set.of(Void.TYPE, HttpRequest.class, MutableHttpRequest.class, HttpResponse.class, MutableHttpResponse.class, FilterContinuation.class, Optional.class);

    public Set<String> getSupportedAnnotationNames() {
        return Set.of(RequestFilter.class.getName(), ResponseFilter.class.getName());
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        AnnotationValue requestFilterAnnotation = element.getAnnotation(RequestFilter.class);
        AnnotationValue responseFilterAnnotation = element.getAnnotation(ResponseFilter.class);
        if (requestFilterAnnotation == null && responseFilterAnnotation == null) {
            return;
        }
        if (!element.getDeclaringType().isAnnotationPresent(ServerFilter.class) && !element.getDeclaringType().isAnnotationPresent(ClientFilter.class)) {
            context.fail("Filter method must be declared on a @ServerFilter or @ClientFilter bean", (Element)element);
            return;
        }
        try {
            Argument<?>[] args = this.toArguments(Arrays.stream(element.getParameters()).map(ParameterElement::getType).toList(), context);
            Argument<?> ret = this.toArgument(element.getReturnType(), context);
            if (requestFilterAnnotation != null) {
                FilterRunner.validateFilterMethod(args, ret, (boolean)false);
            }
            if (responseFilterAnnotation != null) {
                FilterRunner.validateFilterMethod(args, ret, (boolean)true);
            }
        }
        catch (IllegalArgumentException e) {
            context.fail(e.getMessage(), (Element)element);
        }
    }

    private Argument<?>[] toArguments(Collection<ClassElement> classElements, VisitorContext context) {
        return (Argument[])classElements.stream().map(arg -> this.toArgument((ClassElement)arg, context)).toArray(Argument[]::new);
    }

    private Argument<?> toArgument(ClassElement classElement, VisitorContext context) {
        Argument<?>[] parameters;
        Class<?> cl = this.toClass(classElement, context);
        try {
            parameters = this.toArguments(classElement.getTypeArguments().values(), context);
        }
        catch (IllegalArgumentException e) {
            return Argument.of(cl);
        }
        return Argument.of(cl, parameters);
    }

    private Class<?> toClass(ClassElement classElement, VisitorContext context) {
        for (Class<?> permittedClass : PERMITTED_CLASSES) {
            if (!classElement.getName().equals(permittedClass.getName())) continue;
            return permittedClass;
        }
        if (classElement.isAssignable(CompletionStage.class)) {
            return CompletionStage.class;
        }
        if (classElement.isAssignable(Throwable.class)) {
            return Throwable.class;
        }
        for (String reactiveTypeName : Publishers.getReactiveTypeNames()) {
            if (!classElement.isAssignable(reactiveTypeName)) continue;
            return Publisher.class;
        }
        throw new IllegalArgumentException("Unsupported type for filter method: " + classElement.getName());
    }
}

