/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.routes.rules;

import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.validation.routes.RouteValidationResult;
import io.micronaut.validation.routes.rules.RouteValidationRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class MissingParameterRule
implements RouteValidationRule {
    @Override
    public RouteValidationResult validate(List<UriMatchTemplate> templates, ParameterElement[] parameters, MethodElement method) {
        Set variables = templates.stream().flatMap(t -> t.getVariableNames().stream()).collect(Collectors.toSet());
        Set routeVariables = Arrays.stream(parameters).map(Element::getName).collect(Collectors.toCollection(LinkedHashSet::new));
        for (ParameterElement parameter : parameters) {
            if (parameter.hasAnnotation("io.micronaut.http.annotation.Body")) {
                for (AnnotatedElement annotatedElement : MissingParameterRule.findProperties(parameter.getType())) {
                    routeVariables.add(annotatedElement.getName());
                }
            }
            if (!parameter.hasAnnotation("io.micronaut.http.annotation.RequestBean")) continue;
            for (AnnotatedElement annotatedElement : MissingParameterRule.findProperties(parameter.getType())) {
                if (!annotatedElement.getAnnotationMetadata().hasStereotype(Bindable.class)) continue;
                routeVariables.add(annotatedElement.getAnnotationMetadata().stringValue(Bindable.class).orElse(annotatedElement.getName()));
            }
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (String v : variables) {
            if (routeVariables.contains(v)) continue;
            errorMessages.add("The route declares a uri variable named [%s], but no corresponding method argument is present".formatted(v));
        }
        return new RouteValidationResult(errorMessages.toArray(new String[0]));
    }

    private static Collection<? extends AnnotatedElement> findProperties(ClassElement t) {
        Optional primaryConstructor;
        if (t.isRecord() && (primaryConstructor = t.getPrimaryConstructor()).isPresent()) {
            return Arrays.asList(((MethodElement)primaryConstructor.get()).getParameters());
        }
        return t.getBeanProperties();
    }
}

