/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.routes.rules;

import io.micronaut.http.client.annotation.Client;
import io.micronaut.http.server.multipart.MultipartBody;
import io.micronaut.http.server.types.files.StreamedFile;
import io.micronaut.http.server.types.files.SystemFile;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.validation.routes.RouteValidationResult;
import io.micronaut.validation.routes.rules.RouteValidationRule;
import java.util.List;
import java.util.stream.Stream;

public class ClientTypesRule
implements RouteValidationRule {
    private static final Class<?>[] SERVER_TYPES = new Class[]{StreamedFile.class, SystemFile.class, MultipartBody.class};

    @Override
    public RouteValidationResult validate(List<UriMatchTemplate> templates, ParameterElement[] parameters, MethodElement method) {
        String[] errors = new String[]{};
        if (method.hasAnnotation(Client.class)) {
            Stream.Builder<ClassElement> builder = Stream.builder().add(method.getReturnType());
            for (ParameterElement param : method.getParameters()) {
                builder.add(param.getType());
            }
            errors = (String[])builder.build().filter(type -> {
                for (Class<?> clazz : SERVER_TYPES) {
                    if (!type.isAssignable(clazz)) continue;
                    return true;
                }
                return false;
            }).map(type -> "The type [" + String.valueOf(type) + "] must not be used in declarative client methods. The type is specific to server based usages.").toArray(String[]::new);
        }
        return new RouteValidationResult(errors);
    }
}

