/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.ssl;

import io.micronaut.core.io.ResourceResolver;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.http.ssl.SslConfigurationException;
import java.net.URL;
import java.security.KeyStore;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public abstract class SslBuilder<T> {
    protected final SslConfiguration ssl;
    private final ResourceResolver resourceResolver;
    private KeyStore keyStoreCache = null;
    private KeyStore trustStoreCache = null;

    public SslBuilder(SslConfiguration ssl, ResourceResolver resourceResolver) {
        this.ssl = ssl;
        this.resourceResolver = resourceResolver;
    }

    public abstract Optional<T> build();

    protected TrustManagerFactory getTrustManagerFactory() {
        try {
            Optional<KeyStore> store = this.getTrustStore();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)store.orElse(null));
            return trustManagerFactory;
        }
        catch (Exception ex) {
            throw new SslConfigurationException(ex);
        }
    }

    protected Optional<KeyStore> getTrustStore() throws Exception {
        if (this.trustStoreCache == null) {
            SslConfiguration.TrustStoreConfiguration trustStore = this.ssl.getTrustStore();
            if (!trustStore.getPath().isPresent()) {
                return Optional.empty();
            }
            this.trustStoreCache = this.load(trustStore.getType(), trustStore.getPath().get(), trustStore.getPassword());
        }
        return Optional.of(this.trustStoreCache);
    }

    protected KeyManagerFactory getKeyManagerFactory() {
        try {
            Optional<KeyStore> keyStore = this.getKeyStore();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            Optional<String> password = this.ssl.getKey().getPassword();
            char[] keyPassword = password.map(String::toCharArray).orElse(null);
            if (keyPassword == null && this.ssl.getKeyStore().getPassword().isPresent()) {
                keyPassword = this.ssl.getKeyStore().getPassword().get().toCharArray();
            }
            keyManagerFactory.init(keyStore.orElse(null), keyPassword);
            return keyManagerFactory;
        }
        catch (Exception ex) {
            throw new SslConfigurationException(ex);
        }
    }

    protected Optional<KeyStore> getKeyStore() throws Exception {
        if (this.keyStoreCache == null) {
            SslConfiguration.KeyStoreConfiguration keyStore = this.ssl.getKeyStore();
            if (!keyStore.getPath().isPresent()) {
                return Optional.empty();
            }
            this.keyStoreCache = this.load(keyStore.getType(), keyStore.getPath().get(), keyStore.getPassword());
        }
        return Optional.of(this.keyStoreCache);
    }

    protected KeyStore load(Optional<String> optionalType, String resource, Optional<String> optionalPassword) throws Exception {
        String type = optionalType.orElse("JKS");
        String password = optionalPassword.orElse(null);
        KeyStore store = KeyStore.getInstance(type);
        Optional url = this.resourceResolver.getResource(resource);
        if (url.isPresent()) {
            store.load(((URL)url.get()).openStream(), password == null ? null : password.toCharArray());
            return store;
        }
        throw new SslConfigurationException("The resource " + resource + " could not be found");
    }
}

