/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.uri;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class UriMatchVariable {
    private static final List<Character> OPTIONAL_OPERATORS = Arrays.asList(Character.valueOf('/'), Character.valueOf('#'), Character.valueOf('?'), Character.valueOf('&'));
    private final String name;
    private final char modifier;
    private final char operator;

    UriMatchVariable(String name, char modifier, char operator) {
        this.name = name;
        this.modifier = modifier;
        this.operator = operator;
    }

    public String getName() {
        return this.name;
    }

    public boolean isExploded() {
        return this.modifier == '*';
    }

    public boolean isOptional() {
        return OPTIONAL_OPERATORS.contains(Character.valueOf(this.operator));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UriMatchVariable)) {
            return false;
        }
        UriMatchVariable that = (UriMatchVariable)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

