/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.http.HttpMessage;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.HttpRequestFactory;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.cookie.Cookies;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public interface HttpRequest<B>
extends HttpMessage<B> {
    public Cookies getCookies();

    public HttpParameters getParameters();

    public HttpMethod getMethod();

    public URI getUri();

    default public String getPath() {
        return this.getUri().getPath();
    }

    default public InetSocketAddress getRemoteAddress() {
        return this.getServerAddress();
    }

    default public InetSocketAddress getServerAddress() {
        String host = this.getUri().getHost();
        int port = this.getUri().getPort();
        return new InetSocketAddress(host != null ? host : "localhost", port > -1 ? port : 80);
    }

    default public String getServerName() {
        return this.getUri().getHost();
    }

    default public boolean isSecure() {
        String scheme = this.getUri().getScheme();
        return scheme != null && scheme.equals("https");
    }

    @Override
    default public HttpRequest<B> setAttribute(CharSequence name, Object value) {
        return (HttpRequest)HttpMessage.super.setAttribute(name, value);
    }

    @Override
    default public Optional<Locale> getLocale() {
        return this.getHeaders().findFirst("Accept-Language").map(text -> {
            int len = text.length();
            if (len == 0 || len == 1 && text.charAt(0) == '*') {
                return Locale.getDefault().toLanguageTag();
            }
            if (text.indexOf(59) > -1) {
                text = text.split(";")[0];
            }
            if (text.indexOf(44) > -1) {
                text = text.split(",")[0];
            }
            return text;
        }).map(Locale::forLanguageTag);
    }

    public static <T> MutableHttpRequest<T> GET(URI uri) {
        return HttpRequest.GET(uri.toString());
    }

    public static <T> MutableHttpRequest<T> GET(String uri) {
        return HttpRequestFactory.INSTANCE.get(uri);
    }

    public static <T> MutableHttpRequest<T> OPTIONS(URI uri) {
        return HttpRequest.OPTIONS(uri.toString());
    }

    public static <T> MutableHttpRequest<T> OPTIONS(String uri) {
        return HttpRequestFactory.INSTANCE.options(uri);
    }

    public static MutableHttpRequest<?> HEAD(URI uri) {
        return HttpRequest.HEAD(uri.toString());
    }

    public static MutableHttpRequest<?> HEAD(String uri) {
        return HttpRequestFactory.INSTANCE.head(uri);
    }

    public static <T> MutableHttpRequest<T> POST(URI uri, T body) {
        return HttpRequest.POST(uri.toString(), body);
    }

    public static <T> MutableHttpRequest<T> POST(String uri, T body) {
        Objects.requireNonNull(uri, "Argument [uri] is required");
        Objects.requireNonNull(body, "Argument [body] cannot be null");
        return HttpRequestFactory.INSTANCE.post(uri, body);
    }

    public static <T> MutableHttpRequest<T> PUT(URI uri, T body) {
        return HttpRequest.PUT(uri.toString(), body);
    }

    public static <T> MutableHttpRequest<T> PUT(String uri, T body) {
        Objects.requireNonNull(uri, "Argument [uri] is required");
        Objects.requireNonNull(body, "Argument [body] cannot be null");
        return HttpRequestFactory.INSTANCE.put(uri, body);
    }

    public static <T> MutableHttpRequest<T> PATCH(URI uri, T body) {
        return HttpRequest.PATCH(uri.toString(), body);
    }

    public static <T> MutableHttpRequest<T> PATCH(String uri, T body) {
        Objects.requireNonNull(uri, "Argument [uri] is required");
        Objects.requireNonNull(body, "Argument [body] cannot be null");
        return HttpRequestFactory.INSTANCE.patch(uri, body);
    }

    public static <T> MutableHttpRequest<T> DELETE(URI uri, T body) {
        return HttpRequest.DELETE(uri.toString(), body);
    }

    public static <T> MutableHttpRequest<T> DELETE(String uri, T body) {
        Objects.requireNonNull(uri, "Argument [uri] is required");
        return HttpRequestFactory.INSTANCE.delete(uri, body);
    }

    public static <T> MutableHttpRequest<T> DELETE(String uri) {
        return HttpRequest.DELETE(uri, null);
    }

    public static <T> MutableHttpRequest<T> create(HttpMethod httpMethod, String uri) {
        Objects.requireNonNull(httpMethod, "Argument [httpMethod] is required");
        Objects.requireNonNull(uri, "Argument [uri] is required");
        return HttpRequestFactory.INSTANCE.create(httpMethod, uri);
    }
}

