/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.core.attr.MutableAttributeHolder;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.util.HttpUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Optional;

public interface HttpMessage<B>
extends MutableAttributeHolder {
    public HttpHeaders getHeaders();

    public MutableConvertibleValues<Object> getAttributes();

    public Optional<B> getBody();

    default public Charset getCharacterEncoding() {
        return HttpUtil.resolveCharset(this).orElse(StandardCharsets.UTF_8);
    }

    default public HttpMessage<B> setAttribute(CharSequence name, Object value) {
        return (HttpMessage)super.setAttribute(name, value);
    }

    default public <T> Optional<T> getBody(Argument<T> type) {
        return this.getBody().flatMap(b -> ConversionService.SHARED.convert(b, ConversionContext.of((Argument)type)));
    }

    default public <T> Optional<T> getBody(Class<T> type) {
        return this.getBody(Argument.of(type));
    }

    default public Optional<Locale> getLocale() {
        return this.getHeaders().findFirst("Content-Language").map(Locale::new);
    }

    default public long getContentLength() {
        return this.getHeaders().contentLength().orElse(-1L);
    }

    default public Optional<MediaType> getContentType() {
        return this.getHeaders().contentType();
    }
}

