/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.bind;

import io.micronaut.caffeine.cache.Cache;
import io.micronaut.caffeine.cache.Caffeine;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import io.micronaut.http.bind.binders.CookieAnnotationBinder;
import io.micronaut.http.bind.binders.DefaultBodyAnnotationBinder;
import io.micronaut.http.bind.binders.HeaderAnnotationBinder;
import io.micronaut.http.bind.binders.ParameterAnnotationBinder;
import io.micronaut.http.bind.binders.PathVariableAnnotationBinder;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultRequestBinderRegistry
implements RequestBinderRegistry {
    private static final long CACHE_MAX_SIZE = 30L;
    private final Map<Class<? extends Annotation>, RequestArgumentBinder> byAnnotation = new LinkedHashMap<Class<? extends Annotation>, RequestArgumentBinder>();
    private final Map<TypeAndAnnotation, RequestArgumentBinder> byTypeAndAnnotation = new LinkedHashMap<TypeAndAnnotation, RequestArgumentBinder>();
    private final Map<Integer, RequestArgumentBinder> byType = new LinkedHashMap<Integer, RequestArgumentBinder>();
    private final ConversionService<?> conversionService;
    private final Cache<TypeAndAnnotation, Optional<RequestArgumentBinder>> argumentBinderCache = Caffeine.newBuilder().maximumSize(30L).build();

    public DefaultRequestBinderRegistry(ConversionService conversionService, RequestArgumentBinder ... binders) {
        this(conversionService, Arrays.asList(binders));
    }

    @Inject
    public DefaultRequestBinderRegistry(ConversionService conversionService, List<RequestArgumentBinder> binders) {
        this.conversionService = conversionService;
        if (CollectionUtils.isNotEmpty(binders)) {
            for (RequestArgumentBinder binder : binders) {
                if (binder instanceof AnnotatedRequestArgumentBinder) {
                    AnnotatedRequestArgumentBinder annotatedRequestArgumentBinder = (AnnotatedRequestArgumentBinder)binder;
                    Class annotationType = annotatedRequestArgumentBinder.getAnnotationType();
                    if (binder instanceof TypedRequestArgumentBinder) {
                        TypedRequestArgumentBinder typedRequestArgumentBinder = (TypedRequestArgumentBinder)binder;
                        Argument argumentType = typedRequestArgumentBinder.argumentType();
                        this.byTypeAndAnnotation.put(new TypeAndAnnotation(argumentType, annotationType), binder);
                        Set allInterfaces = ReflectionUtils.getAllInterfaces((Class)argumentType.getType());
                        for (Class itfce : allInterfaces) {
                            this.byTypeAndAnnotation.put(new TypeAndAnnotation(Argument.of((Class)itfce), annotationType), binder);
                        }
                        continue;
                    }
                    this.byAnnotation.put(annotationType, annotatedRequestArgumentBinder);
                    continue;
                }
                if (!(binder instanceof TypedRequestArgumentBinder)) continue;
                TypedRequestArgumentBinder typedRequestArgumentBinder = (TypedRequestArgumentBinder)binder;
                this.byType.put(typedRequestArgumentBinder.argumentType().typeHashCode(), typedRequestArgumentBinder);
            }
        }
        this.registerDefaultConverters(conversionService);
        this.registerDefaultAnnotationBinders(this.byAnnotation);
        this.byType.put(Argument.of(HttpHeaders.class).typeHashCode(), (argument, source) -> () -> Optional.of(source.getHeaders()));
        this.byType.put(Argument.of(HttpRequest.class).typeHashCode(), (argument, source) -> () -> Optional.of(source));
        this.byType.put(Argument.of(HttpParameters.class).typeHashCode(), (argument, source) -> () -> Optional.of(source.getParameters()));
        this.byType.put(Argument.of(Cookies.class).typeHashCode(), (argument, source) -> () -> Optional.of(source.getCookies()));
        this.byType.put(Argument.of(Cookie.class).typeHashCode(), (context, source) -> {
            String name;
            Cookies cookies = source.getCookies();
            Cookie cookie = cookies.get(name = context.getArgument().getName());
            if (cookie == null) {
                cookie = cookies.get(NameUtils.hyphenate((String)name));
            }
            Cookie finalCookie = cookie;
            return () -> finalCookie != null ? Optional.of(finalCookie) : Optional.empty();
        });
    }

    public <T> Optional<ArgumentBinder<T, HttpRequest<?>>> findArgumentBinder(Argument<T> argument, HttpRequest<?> source) {
        Optional opt = argument.getAnnotationMetadata().getAnnotationTypeByStereotype(Bindable.class);
        if (opt.isPresent()) {
            Class annotationType = (Class)opt.get();
            RequestArgumentBinder binder = this.findBinder(argument, annotationType);
            if (binder == null) {
                binder = this.byAnnotation.get(annotationType);
            }
            if (binder != null) {
                return Optional.of(binder);
            }
        } else {
            RequestArgumentBinder binder = this.byType.get(argument.typeHashCode());
            if (binder != null) {
                return Optional.of(binder);
            }
            binder = this.byType.get(Argument.of((Class)argument.getType()).typeHashCode());
            if (binder != null) {
                return Optional.of(binder);
            }
        }
        return Optional.of(new ParameterAnnotationBinder(this.conversionService));
    }

    protected <T> RequestArgumentBinder findBinder(Argument<T> argument, Class<? extends Annotation> annotationType) {
        TypeAndAnnotation key = new TypeAndAnnotation(argument, annotationType);
        return ((Optional)this.argumentBinderCache.get((Object)key, key1 -> {
            RequestArgumentBinder requestArgumentBinder = this.byTypeAndAnnotation.get(key1);
            if (requestArgumentBinder == null) {
                Class itfce;
                Class javaType = ((TypeAndAnnotation)key1).type.getType();
                Set allInterfaces = ReflectionUtils.getAllInterfaces((Class)javaType);
                Iterator iterator = allInterfaces.iterator();
                while (iterator.hasNext() && (requestArgumentBinder = this.byTypeAndAnnotation.get(new TypeAndAnnotation(Argument.of((Class)(itfce = (Class)iterator.next())), annotationType))) == null) {
                }
                if (requestArgumentBinder == null) {
                    requestArgumentBinder = this.byTypeAndAnnotation.get(new TypeAndAnnotation(Argument.of((Class)argument.getType()), annotationType));
                }
            }
            return Optional.ofNullable(requestArgumentBinder);
        })).orElse(null);
    }

    protected void registerDefaultConverters(ConversionService<?> conversionService) {
        conversionService.addConverter(CharSequence.class, MediaType.class, (object, targetType, context) -> Optional.of(new MediaType(object.toString())));
    }

    protected void registerDefaultAnnotationBinders(Map<Class<? extends Annotation>, RequestArgumentBinder> byAnnotation) {
        DefaultBodyAnnotationBinder bodyBinder = new DefaultBodyAnnotationBinder(this.conversionService);
        byAnnotation.put(Body.class, bodyBinder);
        CookieAnnotationBinder cookieAnnotationBinder = new CookieAnnotationBinder(this.conversionService);
        byAnnotation.put(cookieAnnotationBinder.getAnnotationType(), cookieAnnotationBinder);
        HeaderAnnotationBinder headerAnnotationBinder = new HeaderAnnotationBinder(this.conversionService);
        byAnnotation.put(headerAnnotationBinder.getAnnotationType(), headerAnnotationBinder);
        ParameterAnnotationBinder parameterAnnotationBinder = new ParameterAnnotationBinder(this.conversionService);
        byAnnotation.put(parameterAnnotationBinder.getAnnotationType(), parameterAnnotationBinder);
        PathVariableAnnotationBinder pathVariableAnnotationBinder = new PathVariableAnnotationBinder(this.conversionService);
        byAnnotation.put(pathVariableAnnotationBinder.getAnnotationType(), pathVariableAnnotationBinder);
    }

    private static final class TypeAndAnnotation {
        private final Argument<?> type;
        private final Class<? extends Annotation> annotation;

        public TypeAndAnnotation(Argument<?> type, Class<? extends Annotation> annotation) {
            this.type = type;
            this.annotation = annotation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeAndAnnotation that = (TypeAndAnnotation)o;
            if (!this.type.equalsType(that.type)) {
                return false;
            }
            return this.annotation.equals(that.annotation);
        }

        public int hashCode() {
            int result = this.type.typeHashCode();
            result = 31 * result + this.annotation.hashCode();
            return result;
        }
    }
}

