/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.util;

import io.micronaut.http.HttpMessage;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Optional;

public class HttpUtil {
    public static boolean isFormData(HttpRequest<?> request) {
        Optional<MediaType> opt = request.getContentType();
        if (opt.isPresent()) {
            MediaType contentType = opt.get();
            return contentType.equals(MediaType.APPLICATION_FORM_URLENCODED_TYPE) || contentType.equals(MediaType.MULTIPART_FORM_DATA_TYPE);
        }
        return false;
    }

    public static Optional<Charset> resolveCharset(HttpMessage<?> request) {
        try {
            Optional<Charset> contentTypeCharset = request.getContentType().flatMap(contentType -> contentType.getParameters().get((CharSequence)"charset").map(Charset::forName));
            if (contentTypeCharset.isPresent()) {
                return contentTypeCharset;
            }
            return request.getHeaders().findFirst("Accept-Charset").map(Charset::forName);
        }
        catch (UnsupportedCharsetException e) {
            return Optional.empty();
        }
    }
}

