/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.cookie;

import io.micronaut.http.cookie.CookieFactory;
import java.io.Serializable;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;

public interface Cookie
extends Comparable<Cookie>,
Serializable {
    public String getName();

    public String getValue();

    public String getDomain();

    public String getPath();

    public boolean isHttpOnly();

    public boolean isSecure();

    public long getMaxAge();

    public Cookie maxAge(long var1);

    public Cookie value(String var1);

    public Cookie domain(String var1);

    public Cookie path(String var1);

    public Cookie secure(boolean var1);

    public Cookie httpOnly(boolean var1);

    default public Cookie maxAge(TemporalAmount maxAge) {
        return this.maxAge(maxAge.get(ChronoUnit.SECONDS));
    }

    public static Cookie of(String name, String value) {
        CookieFactory instance = CookieFactory.INSTANCE;
        if (instance != null) {
            return instance.create(name, value);
        }
        throw new UnsupportedOperationException("No CookeFactory implementation found. Server implementation does not support cookies.");
    }
}

