/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.bind.binders;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.bind.binders.BodyArgumentBinder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DefaultBodyAnnotationBinder<T>
implements BodyArgumentBinder<T> {
    protected final ConversionService<?> conversionService;

    public DefaultBodyAnnotationBinder(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Class<Body> getAnnotationType() {
        return Body.class;
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> source) {
        Optional body = source.getBody();
        if (!body.isPresent()) {
            return ArgumentBinder.BindingResult.EMPTY;
        }
        Object o = body.get();
        Optional converted = this.conversionService.convert(o, context);
        final Optional lastError = context.getLastError();
        if (lastError.isPresent()) {
            return new ArgumentBinder.BindingResult<T>(){

                public Optional<T> getValue() {
                    return Optional.empty();
                }

                public List<ConversionError> getConversionErrors() {
                    return Collections.singletonList(lastError.get());
                }
            };
        }
        return () -> converted;
    }
}

