/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.cookie;

import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.cookie.CookieConfiguration;
import io.micronaut.http.cookie.CookieFactory;
import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Cookie
extends Comparable<Cookie>,
Serializable {
    @Nonnull
    public String getName();

    @Nonnull
    public String getValue();

    @Nullable
    public String getDomain();

    @Nullable
    public String getPath();

    public boolean isHttpOnly();

    public boolean isSecure();

    public long getMaxAge();

    @Nonnull
    public Cookie maxAge(long var1);

    @Nonnull
    public Cookie value(@Nonnull String var1);

    @Nonnull
    public Cookie domain(@Nullable String var1);

    @Nonnull
    public Cookie path(@Nullable String var1);

    @Nonnull
    public Cookie secure(boolean var1);

    @Nonnull
    public Cookie httpOnly(boolean var1);

    @Nonnull
    default public Cookie configure(@Nonnull CookieConfiguration configuration) {
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        return this.configure(configuration, true);
    }

    @Nonnull
    default public Cookie configure(@Nonnull CookieConfiguration configuration, boolean isSecure) {
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        configuration.getCookiePath().ifPresent(this::path);
        configuration.getCookieDomain().ifPresent(this::domain);
        configuration.getCookieMaxAge().ifPresent(this::maxAge);
        configuration.isCookieHttpOnly().ifPresent(this::httpOnly);
        if (isSecure) {
            configuration.isCookieSecure().ifPresent(this::secure);
        }
        return this;
    }

    @Nonnull
    default public Cookie maxAge(@Nonnull Duration maxAge) {
        ArgumentUtils.requireNonNull((String)"maxAge", (Object)maxAge);
        return this.maxAge(maxAge.get(ChronoUnit.SECONDS));
    }

    @Nonnull
    public static Cookie of(@Nonnull String name, @Nonnull String value) {
        CookieFactory instance = CookieFactory.INSTANCE;
        if (instance != null) {
            return instance.create(name, value);
        }
        throw new UnsupportedOperationException("No CookeFactory implementation found. Server implementation does not support cookies.");
    }
}

