/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.type.Headers;
import io.micronaut.http.MediaType;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;

public interface HttpHeaders
extends Headers {
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_CHARSET = "Accept-Charset";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String ACCEPT_RANGES = "Accept-Ranges";
    public static final String ACCEPT_PATCH = "Accept-Patch";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final String AGE = "Age";
    public static final String ALLOW = "Allow";
    public static final String AUTHORIZATION = "Authorization";
    public static final String AUTHORIZATION_INFO = "Authorization-Info";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String CONNECTION = "Connection";
    public static final String CONTENT_BASE = "Content-Base";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LANGUAGE = "Content-Language";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_LOCATION = "Content-Location";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String CONTENT_MD5 = "Content-MD5";
    public static final String CONTENT_RANGE = "Content-Range";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String COOKIE = "Cookie";
    public static final String DATE = "Date";
    public static final String ETAG = "ETag";
    public static final String EXPECT = "Expect";
    public static final String EXPIRES = "Expires";
    public static final String FORWARDED = "Forwarded";
    public static final String FROM = "From";
    public static final String HOST = "Host";
    public static final String IF_MATCH = "If-Match";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String IF_RANGE = "If-Range";
    public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String LOCATION = "Location";
    public static final String MAX_FORWARDS = "Max-Forwards";
    public static final String ORIGIN = "Origin";
    public static final String PRAGMA = "Pragma";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String RANGE = "Range";
    public static final String REFERER = "Referer";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String SEC_WEBSOCKET_KEY1 = "Sec-WebSocket-Key1";
    public static final String SEC_WEBSOCKET_KEY2 = "Sec-WebSocket-Key2";
    public static final String SEC_WEBSOCKET_LOCATION = "Sec-WebSocket-Location";
    public static final String SEC_WEBSOCKET_ORIGIN = "Sec-WebSocket-Origin";
    public static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    public static final String SEC_WEBSOCKET_VERSION = "Sec-WebSocket-Version";
    public static final String SEC_WEBSOCKET_KEY = "Sec-WebSocket-Key";
    public static final String SEC_WEBSOCKET_ACCEPT = "Sec-WebSocket-Accept";
    public static final String SERVER = "Server";
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String SET_COOKIE2 = "Set-Cookie2";
    public static final String TE = "TE";
    public static final String TRAILER = "Trailer";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String UPGRADE = "Upgrade";
    public static final String USER_AGENT = "User-Agent";
    public static final String VARY = "Vary";
    public static final String VIA = "Via";
    public static final String WARNING = "Warning";
    public static final String WEBSOCKET_LOCATION = "WebSocket-Location";
    public static final String WEBSOCKET_ORIGIN = "WebSocket-Origin";
    public static final String WEBSOCKET_PROTOCOL = "WebSocket-Protocol";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String X_AUTH_TOKEN = "X-Auth-Token";

    default public Optional<ZonedDateTime> findDate(CharSequence name) {
        try {
            return this.findFirst(name).map(str -> {
                LocalDateTime localDateTime = LocalDateTime.parse(str, DateTimeFormatter.RFC_1123_DATE_TIME);
                return ZonedDateTime.of(localDateTime, ZoneId.of("GMT"));
            });
        }
        catch (DateTimeParseException e) {
            return Optional.empty();
        }
    }

    default public ZonedDateTime getDate(CharSequence name) {
        return this.findDate(name).orElse(null);
    }

    default public Integer getInt(CharSequence name) {
        return this.findInt(name).orElse(null);
    }

    default public Optional<Integer> findInt(CharSequence name) {
        return this.get(name, ConversionContext.INT);
    }

    default public Optional<String> findFirst(CharSequence name) {
        return this.getFirst(name, ConversionContext.STRING);
    }

    default public Optional<MediaType> contentType() {
        return this.getFirst(CONTENT_TYPE, MediaType.CONVERSION_CONTEXT);
    }

    default public OptionalLong contentLength() {
        Long aLong = this.getFirst(CONTENT_LENGTH, ConversionContext.LONG).orElse(null);
        if (aLong != null) {
            return OptionalLong.of(aLong);
        }
        return OptionalLong.empty();
    }

    default public List<MediaType> accept() {
        List values = this.getAll(ACCEPT);
        if (!values.isEmpty()) {
            ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>(10);
            for (String value : values) {
                String[] tokens;
                for (String token : tokens = value.split(",")) {
                    try {
                        mediaTypes.add(new MediaType(token));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            return mediaTypes;
        }
        return Collections.emptyList();
    }

    default public boolean isKeepAlive() {
        return this.getFirst(CONNECTION, ConversionContext.STRING).map(val -> val.equalsIgnoreCase("keep-alive")).orElse(false);
    }

    default public Optional<String> getOrigin() {
        return this.findFirst(ORIGIN);
    }

    default public Optional<String> getAuthorization() {
        return this.findFirst(AUTHORIZATION);
    }

    default public Optional<String> getContentType() {
        return this.findFirst(CONTENT_TYPE);
    }
}

