/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.context;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.http.HttpRequest;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public final class ServerRequestContext {
    private static final ThreadLocal<HttpRequest> REQUEST = new ThreadLocal();

    private ServerRequestContext() {
    }

    public static void set(@Nullable HttpRequest request) {
        if (request == null) {
            REQUEST.remove();
        } else {
            REQUEST.set(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void with(@Nullable HttpRequest request, @NonNull Runnable runnable) {
        HttpRequest existing = REQUEST.get();
        boolean isSet = false;
        try {
            if (request != existing) {
                isSet = true;
                ServerRequestContext.set(request);
            }
            runnable.run();
        }
        finally {
            if (isSet) {
                ServerRequestContext.set(existing);
            }
        }
    }

    public static Runnable instrument(@Nullable HttpRequest request, @NonNull Runnable runnable) {
        return () -> ServerRequestContext.with(request, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T with(@Nullable HttpRequest request, @NonNull Supplier<T> callable) {
        HttpRequest existing = REQUEST.get();
        boolean isSet = false;
        try {
            if (request != existing) {
                isSet = true;
                ServerRequestContext.set(request);
            }
            T t = callable.get();
            return t;
        }
        finally {
            if (isSet) {
                ServerRequestContext.set(existing);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T with(@Nullable HttpRequest request, @NonNull Callable<T> callable) throws Exception {
        HttpRequest existing = REQUEST.get();
        boolean isSet = false;
        try {
            if (request != existing) {
                isSet = true;
                ServerRequestContext.set(request);
            }
            T t = callable.call();
            return t;
        }
        finally {
            if (isSet) {
                ServerRequestContext.set(existing);
            }
        }
    }

    public static <T> Optional<HttpRequest<T>> currentRequest() {
        return Optional.ofNullable(REQUEST.get());
    }
}

