/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.http.annotation.Produces;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeHint(value={MediaType[].class})
public class MediaType
implements CharSequence {
    public static final String EXTENSION_JSON = "json";
    public static final String EXTENSION_XML = "xml";
    public static final MediaType[] EMPTY_ARRAY = new MediaType[0];
    public static final String ALL = "*/*";
    public static final MediaType ALL_TYPE = new MediaType("*/*", "all");
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final MediaType APPLICATION_FORM_URLENCODED_TYPE;
    public static final MediaType FORM;
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final MediaType MULTIPART_FORM_DATA_TYPE;
    public static final String TEXT_HTML = "text/html";
    public static final MediaType TEXT_HTML_TYPE;
    public static final String APPLICATION_XHTML = "application/xhtml+xml";
    public static final MediaType APPLICATION_XHTML_TYPE;
    public static final String APPLICATION_XML = "application/xml";
    public static final MediaType APPLICATION_XML_TYPE;
    public static final String APPLICATION_JSON = "application/json";
    public static final MediaType APPLICATION_JSON_TYPE;
    public static final String APPLICATION_YAML = "application/x-yaml";
    public static final MediaType APPLICATION_YAML_TYPE;
    public static final String TEXT_XML = "text/xml";
    public static final MediaType TEXT_XML_TYPE;
    public static final String TEXT_JSON = "text/json";
    public static final MediaType TEXT_JSON_TYPE;
    public static final String TEXT_PLAIN = "text/plain";
    public static final MediaType TEXT_PLAIN_TYPE;
    public static final String APPLICATION_HAL_JSON = "application/hal+json";
    public static final MediaType APPLICATION_HAL_JSON_TYPE;
    public static final String APPLICATION_HAL_XML = "application/hal+xml";
    public static final MediaType APPLICATION_HAL_XML_TYPE;
    public static final String APPLICATION_ATOM_XML = "application/atom+xml";
    public static final MediaType APPLICATION_ATOM_XML_TYPE;
    public static final String APPLICATION_VND_ERROR = "application/vnd.error+json";
    public static final MediaType APPLICATION_VND_ERROR_TYPE;
    public static final String TEXT_EVENT_STREAM = "text/event-stream";
    public static final MediaType TEXT_EVENT_STREAM_TYPE;
    public static final String APPLICATION_JSON_STREAM = "application/x-json-stream";
    public static final MediaType APPLICATION_JSON_STREAM_TYPE;
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final MediaType APPLICATION_OCTET_STREAM_TYPE;
    public static final String APPLICATION_GRAPHQL = "application/graphql";
    public static final MediaType APPLICATION_GRAPHQL_TYPE;
    public static final String IMAGE_PNG = "image/png";
    public static final MediaType IMAGE_PNG_TYPE;
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final MediaType IMAGE_JPEG_TYPE;
    public static final String IMAGE_GIF = "image/gif";
    public static final MediaType IMAGE_GIF_TYPE;
    public static final String IMAGE_WEBP = "image/webp";
    public static final MediaType IMAGE_WEBP_TYPE;
    public static final String CHARSET_PARAMETER = "charset";
    public static final String Q_PARAMETER = "q";
    public static final String V_PARAMETER = "v";
    @Internal
    static final Argument<MediaType> ARGUMENT;
    @Internal
    static final ArgumentConversionContext<MediaType> CONVERSION_CONTEXT;
    private static final BigDecimal QUALITY_RATING_NUMBER;
    private static final String QUALITY_RATING = "1.0";
    private static final String SEMICOLON = ";";
    private static final String MIME_TYPES_FILE_NAME = "META-INF/http/mime.types";
    private static Map<String, String> mediaTypeFileExtensions;
    private static final List<Pattern> textTypePatterns;
    protected final String name;
    protected final String subtype;
    protected final String type;
    protected final String extension;
    protected final Map<CharSequence, String> parameters;
    private final String strRepr;
    private BigDecimal qualityNumberField;

    public MediaType(String name) {
        this(name, null, Collections.emptyMap());
    }

    public MediaType(String name, Map<String, String> params) {
        this(name, null, params);
    }

    public MediaType(String name, String extension) {
        this(name, extension, Collections.emptyMap());
    }

    public MediaType(String name, String extension, Map<String, String> params) {
        int j;
        String withoutArgs;
        if (name == null) {
            throw new IllegalArgumentException("Argument [name] cannot be null");
        }
        name = name.trim();
        this.parameters = new LinkedHashMap<CharSequence, String>();
        if (name.contains(SEMICOLON)) {
            String[] paramsList;
            String[] tokenWithArgs = name.split(SEMICOLON);
            withoutArgs = tokenWithArgs[0];
            for (String param : paramsList = Arrays.copyOfRange(tokenWithArgs, 1, tokenWithArgs.length)) {
                int i = param.indexOf(61);
                if (i <= -1) continue;
                this.parameters.put(param.substring(0, i).trim(), param.substring(i + 1).trim());
            }
        } else {
            withoutArgs = name;
        }
        this.name = withoutArgs;
        int i = withoutArgs.indexOf(47);
        if (i <= -1) {
            throw new IllegalArgumentException("Invalid mime type: " + name);
        }
        this.type = withoutArgs.substring(0, i);
        this.subtype = withoutArgs.substring(i + 1);
        this.extension = extension != null ? extension : ((j = this.subtype.indexOf(43)) > -1 ? this.subtype.substring(j + 1) : this.subtype);
        if (params != null) {
            this.parameters.putAll(params);
        }
        this.strRepr = this.toString0();
    }

    public boolean matches(@Nonnull MediaType expectedContentType) {
        if (expectedContentType == null) {
            return false;
        }
        String expectedType = expectedContentType.getType();
        String expectedSubtype = expectedContentType.getSubtype();
        boolean typeMatch = this.type.equals("*") || this.type.equalsIgnoreCase(expectedType);
        boolean subtypeMatch = this.subtype.equals("*") || this.subtype.equalsIgnoreCase(expectedSubtype);
        return typeMatch && subtypeMatch;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getExtension() {
        return this.extension;
    }

    public OptionalValues<String> getParameters() {
        return OptionalValues.of(String.class, this.parameters);
    }

    public String getQuality() {
        return this.parameters.getOrDefault(Q_PARAMETER, QUALITY_RATING);
    }

    public BigDecimal getQualityAsNumber() {
        if (this.qualityNumberField == null) {
            this.qualityNumberField = this.getOrConvertQualityParameterToBigDecimal(this);
        }
        return this.qualityNumberField;
    }

    public String getVersion() {
        return this.parameters.getOrDefault(V_PARAMETER, null);
    }

    public Optional<Charset> getCharset() {
        return this.getParameters().get((CharSequence)CHARSET_PARAMETER).map(Charset::forName);
    }

    @Override
    public int length() {
        return this.strRepr.length();
    }

    @Override
    public char charAt(int index) {
        return this.strRepr.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.strRepr.subSequence(start, end);
    }

    public boolean isTextBased() {
        boolean matches = textTypePatterns.stream().anyMatch(p -> p.matcher(this.name).matches());
        if (!matches) {
            matches = this.subtype.equalsIgnoreCase(EXTENSION_JSON) || this.subtype.equalsIgnoreCase(EXTENSION_XML) || this.subtype.equalsIgnoreCase("x-yaml");
        }
        return matches;
    }

    public static boolean isTextBased(String contentType) {
        if (StringUtils.isEmpty((CharSequence)contentType)) {
            return false;
        }
        try {
            return new MediaType(contentType).isTextBased();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public String toString() {
        return this.strRepr;
    }

    private String toString0() {
        if (this.parameters.isEmpty()) {
            return this.name;
        }
        return this.name + SEMICOLON + this.parameters.entrySet().stream().map(Object::toString).collect(Collectors.joining(SEMICOLON));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaType mediaType = (MediaType)o;
        return this.name.equalsIgnoreCase(mediaType.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static List<MediaType> orderedOf(CharSequence ... values) {
        return MediaType.orderedOf(Arrays.asList(values));
    }

    public static List<MediaType> orderedOf(List<? extends CharSequence> values) {
        if (CollectionUtils.isNotEmpty(values)) {
            ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>(values.size());
            for (CharSequence charSequence : values) {
                String[] tokens;
                for (String token : tokens = charSequence.toString().split(",")) {
                    try {
                        mediaTypes.add(new MediaType(token));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            mediaTypes.sort((o1, o2) -> {
                if (o1.type.equals("*")) {
                    return 1;
                }
                if (o2.type.equals("*")) {
                    return -1;
                }
                if (o2.subtype.equals("*") && !o1.subtype.equals("*")) {
                    return -1;
                }
                if (o1.subtype.equals("*") && !o2.subtype.equals("*")) {
                    return 1;
                }
                return o2.getQualityAsNumber().compareTo(o1.getQualityAsNumber());
            });
            return Collections.unmodifiableList(mediaTypes);
        }
        return Collections.emptyList();
    }

    public static MediaType of(CharSequence mediaType) {
        return new MediaType(mediaType.toString());
    }

    public static MediaType[] of(CharSequence ... mediaType) {
        return (MediaType[])Arrays.stream(mediaType).map(txt -> new MediaType(txt.toString())).toArray(MediaType[]::new);
    }

    public static Optional<MediaType> fromType(Class<?> type) {
        Produces producesAnn = type.getAnnotation(Produces.class);
        if (producesAnn != null) {
            return Arrays.stream(producesAnn.value()).findFirst().map(MediaType::new);
        }
        return Optional.empty();
    }

    public static Optional<MediaType> forExtension(String extension) {
        String type;
        if (StringUtils.isNotEmpty((CharSequence)extension) && (type = MediaType.getMediaTypeFileExtensions().get(extension)) != null) {
            return Optional.of(new MediaType(type, extension));
        }
        return Optional.empty();
    }

    public static MediaType forFilename(String filename) {
        if (StringUtils.isNotEmpty((CharSequence)filename)) {
            return MediaType.forExtension(NameUtils.extension((String)filename)).orElse(TEXT_PLAIN_TYPE);
        }
        return TEXT_PLAIN_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> getMediaTypeFileExtensions() {
        Map<String, String> extensions = mediaTypeFileExtensions;
        if (extensions != null) return extensions;
        Class<MediaType> clazz = MediaType.class;
        synchronized (MediaType.class) {
            extensions = mediaTypeFileExtensions;
            if (extensions != null) return extensions;
            try {
                mediaTypeFileExtensions = extensions = MediaType.loadMimeTypes();
            }
            catch (Exception e) {
                mediaTypeFileExtensions = Collections.emptyMap();
            }
            return extensions;
        }
    }

    private BigDecimal getOrConvertQualityParameterToBigDecimal(MediaType mt) {
        try {
            String q = mt.parameters.getOrDefault(Q_PARAMETER, null);
            if (q == null) {
                return QUALITY_RATING_NUMBER;
            }
            BigDecimal bd = new BigDecimal(q);
            return bd;
        }
        catch (NumberFormatException e) {
            BigDecimal bd = QUALITY_RATING_NUMBER;
            return bd;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> loadMimeTypes() {
        try (InputStream is = MediaType.class.getClassLoader().getResourceAsStream(MIME_TYPES_FILE_NAME);){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.US_ASCII));
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(100);
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                String formattedLine = line.trim().replaceAll("\\s{2,}", " ").replaceAll("\\s", "|");
                String[] tokens = formattedLine.split("\\|");
                for (int i = 1; i < tokens.length; ++i) {
                    String fileExtension = tokens[i].toLowerCase(Locale.ENGLISH);
                    result.put(fileExtension, tokens[0]);
                }
            }
            LinkedHashMap<String, String> linkedHashMap = result;
            return linkedHashMap;
        }
        catch (IOException ex) {
            Logger logger = LoggerFactory.getLogger(MediaType.class);
            if (!logger.isWarnEnabled()) return Collections.emptyMap();
            logger.warn("Failed to load mime types for file extension detection!");
            return Collections.emptyMap();
        }
    }

    static {
        FORM = APPLICATION_FORM_URLENCODED_TYPE = new MediaType(APPLICATION_FORM_URLENCODED);
        MULTIPART_FORM_DATA_TYPE = new MediaType(MULTIPART_FORM_DATA);
        TEXT_HTML_TYPE = new MediaType(TEXT_HTML);
        APPLICATION_XHTML_TYPE = new MediaType(APPLICATION_XHTML, "html");
        APPLICATION_XML_TYPE = new MediaType(APPLICATION_XML);
        APPLICATION_JSON_TYPE = new MediaType(APPLICATION_JSON);
        APPLICATION_YAML_TYPE = new MediaType(APPLICATION_YAML);
        TEXT_XML_TYPE = new MediaType(TEXT_XML);
        TEXT_JSON_TYPE = new MediaType(TEXT_JSON);
        TEXT_PLAIN_TYPE = new MediaType(TEXT_PLAIN);
        APPLICATION_HAL_JSON_TYPE = new MediaType(APPLICATION_HAL_JSON);
        APPLICATION_HAL_XML_TYPE = new MediaType(APPLICATION_HAL_XML);
        APPLICATION_ATOM_XML_TYPE = new MediaType(APPLICATION_ATOM_XML);
        APPLICATION_VND_ERROR_TYPE = new MediaType(APPLICATION_VND_ERROR);
        TEXT_EVENT_STREAM_TYPE = new MediaType(TEXT_EVENT_STREAM);
        APPLICATION_JSON_STREAM_TYPE = new MediaType(APPLICATION_JSON_STREAM);
        APPLICATION_OCTET_STREAM_TYPE = new MediaType(APPLICATION_OCTET_STREAM);
        APPLICATION_GRAPHQL_TYPE = new MediaType(APPLICATION_GRAPHQL);
        IMAGE_PNG_TYPE = new MediaType(IMAGE_PNG);
        IMAGE_JPEG_TYPE = new MediaType(IMAGE_JPEG);
        IMAGE_GIF_TYPE = new MediaType(IMAGE_GIF);
        IMAGE_WEBP_TYPE = new MediaType(IMAGE_WEBP);
        ARGUMENT = Argument.of(MediaType.class);
        CONVERSION_CONTEXT = ConversionContext.of(ARGUMENT);
        QUALITY_RATING_NUMBER = new BigDecimal(QUALITY_RATING);
        textTypePatterns = new ArrayList<Pattern>(4);
        ConversionService.SHARED.addConverter(CharSequence.class, MediaType.class, charSequence -> {
            if (StringUtils.isNotEmpty((CharSequence)charSequence)) {
                return new MediaType(charSequence.toString());
            }
            return null;
        });
        textTypePatterns.add(Pattern.compile("^text/.*$"));
        textTypePatterns.add(Pattern.compile("^.*\\+json$"));
        textTypePatterns.add(Pattern.compile("^.*\\+text$"));
        textTypePatterns.add(Pattern.compile("^.*\\+xml$"));
        textTypePatterns.add(Pattern.compile("^application/javascript$"));
    }
}

