/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.cookie;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.cookie.CookieConfiguration;
import io.micronaut.http.cookie.CookieFactory;
import io.micronaut.http.cookie.SameSite;
import java.io.Serializable;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.Optional;

public interface Cookie
extends Comparable<Cookie>,
Serializable {
    @NonNull
    public String getName();

    @NonNull
    public String getValue();

    @Nullable
    public String getDomain();

    @Nullable
    public String getPath();

    public boolean isHttpOnly();

    public boolean isSecure();

    public long getMaxAge();

    default public Optional<SameSite> getSameSite() {
        return Optional.empty();
    }

    @NonNull
    default public Cookie sameSite(@Nullable SameSite sameSite) {
        return this;
    }

    @NonNull
    public Cookie maxAge(long var1);

    @NonNull
    public Cookie value(@NonNull String var1);

    @NonNull
    public Cookie domain(@Nullable String var1);

    @NonNull
    public Cookie path(@Nullable String var1);

    @NonNull
    public Cookie secure(boolean var1);

    @NonNull
    public Cookie httpOnly(boolean var1);

    @NonNull
    default public Cookie configure(@NonNull CookieConfiguration configuration) {
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        return this.configure(configuration, true);
    }

    @NonNull
    default public Cookie configure(@NonNull CookieConfiguration configuration, boolean isSecure) {
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        configuration.getCookiePath().ifPresent(this::path);
        configuration.getCookieDomain().ifPresent(this::domain);
        configuration.getCookieMaxAge().ifPresent(this::maxAge);
        configuration.isCookieHttpOnly().ifPresent(this::httpOnly);
        if (isSecure) {
            configuration.isCookieSecure().ifPresent(this::secure);
        }
        configuration.getCookieSameSite().ifPresent(this::sameSite);
        return this;
    }

    @NonNull
    default public Cookie maxAge(@NonNull TemporalAmount maxAge) {
        ArgumentUtils.requireNonNull((String)"maxAge", (Object)maxAge);
        return this.maxAge(maxAge.get(ChronoUnit.SECONDS));
    }

    @NonNull
    public static Cookie of(@NonNull String name, @NonNull String value) {
        CookieFactory instance = CookieFactory.INSTANCE;
        if (instance != null) {
            return instance.create(name, value);
        }
        throw new UnsupportedOperationException("No CookeFactory implementation found. Server implementation does not support cookies.");
    }
}

