/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.context.BeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.body.ChunkedMessageBodyReader;
import io.micronaut.http.body.MessageBodyHandler;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanType;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Singleton
public final class DefaultMessageBodyHandlerRegistry
implements MessageBodyHandlerRegistry {
    private static final MessageBodyReader<Object> NO_READER = new NoReader();
    private static final MessageBodyWriter<Object> NO_WRITER = new NoWriter();
    private final Map<HandlerKey<?>, MessageBodyReader<?>> readers = new ConcurrentHashMap(10);
    private final Map<HandlerKey<?>, MessageBodyWriter<?>> writers = new ConcurrentHashMap(10);
    private final BeanContext beanLocator;
    private final RawStringHandler rawStringHandler;
    private final RawByteArrayHandler rawByteArrayHandler;
    @Nullable
    private final RawByteBufferHandler rawByteBufferHandler;

    DefaultMessageBodyHandlerRegistry(BeanContext beanLocator, RawStringHandler rawStringHandler, RawByteArrayHandler rawByteArrayHandler, @Nullable RawByteBufferHandler rawByteBufferHandler) {
        this.beanLocator = beanLocator;
        this.rawStringHandler = rawStringHandler;
        this.rawByteArrayHandler = rawByteArrayHandler;
        this.rawByteBufferHandler = rawByteBufferHandler;
    }

    @Nullable
    private <T> MessageBodyHandler<T> rawHandler(Argument<T> type) {
        if (type.getType() == String.class) {
            return this.rawStringHandler;
        }
        if (type.getType() == byte[].class) {
            return this.rawByteArrayHandler;
        }
        if (type.getType() == ByteBuffer.class && this.rawByteBufferHandler != null) {
            return this.rawByteBufferHandler;
        }
        return null;
    }

    @Override
    public <T> Optional<MessageBodyReader<T>> findReader(Argument<T> type, List<MediaType> mediaTypes) {
        HandlerKey<T> key = new HandlerKey<T>(type, mediaTypes);
        MessageBodyReader<?> messageBodyReader = this.readers.get(key);
        if (messageBodyReader == null) {
            MessageBodyReader<T> reader = this.rawHandler(type);
            if (reader == null) {
                List<BeanDefinition> exactMatch;
                Collection beanDefinitions = this.beanLocator.getBeanDefinitions(Argument.of(MessageBodyReader.class, (Argument[])new Argument[]{type}), new MediaTypeQualifier(type, mediaTypes, Consumes.class));
                reader = beanDefinitions.size() == 1 ? (MessageBodyReader)this.beanLocator.getBean((BeanDefinition)beanDefinitions.iterator().next()) : ((exactMatch = beanDefinitions.stream().filter(d -> {
                    List typeArguments = d.getTypeArguments(MessageBodyReader.class);
                    if (typeArguments.isEmpty()) {
                        return false;
                    }
                    return type.equalsType((Argument)typeArguments.get(0));
                }).toList()).size() == 1 ? (MessageBodyReader)this.beanLocator.getBean(exactMatch.iterator().next()) : (MessageBodyReader)OrderUtil.sort(beanDefinitions.stream()).findFirst().map(arg_0 -> ((BeanContext)this.beanLocator).getBean(arg_0)).orElse(null));
            }
            if (reader != null) {
                this.readers.put(key, reader);
                return Optional.of(reader);
            }
            this.readers.put(key, NO_READER);
            return Optional.empty();
        }
        if (messageBodyReader instanceof NoReader) {
            return Optional.empty();
        }
        return Optional.of(messageBodyReader);
    }

    @Override
    public <T> Optional<MessageBodyWriter<T>> findWriter(Argument<T> type, List<MediaType> mediaType) {
        HandlerKey<T> key = new HandlerKey<T>(type, mediaType);
        MessageBodyWriter<?> messageBodyWriter = this.writers.get(key);
        if (messageBodyWriter == null) {
            MessageBodyWriter<T> writer = this.rawHandler(type);
            if (writer == null) {
                List<BeanDefinition> exactMatch;
                Collection beanDefinitions = this.beanLocator.getBeanDefinitions(Argument.of(MessageBodyWriter.class, (Argument[])new Argument[]{type}), new MediaTypeQualifier(type, mediaType, Produces.class));
                writer = beanDefinitions.size() == 1 ? (MessageBodyWriter)this.beanLocator.getBean((BeanDefinition)beanDefinitions.iterator().next()) : ((exactMatch = beanDefinitions.stream().filter(d -> {
                    List typeArguments = d.getTypeArguments(MessageBodyWriter.class);
                    if (typeArguments.isEmpty()) {
                        return false;
                    }
                    return type.equalsType((Argument)typeArguments.get(0));
                }).toList()).size() == 1 ? (MessageBodyWriter)this.beanLocator.getBean(exactMatch.iterator().next()) : (MessageBodyWriter)OrderUtil.sort(beanDefinitions.stream()).findFirst().map(arg_0 -> ((BeanContext)this.beanLocator).getBean(arg_0)).orElse(null));
            }
            if (writer != null) {
                this.writers.put(key, writer);
                return Optional.of(writer);
            }
            this.writers.put(key, NO_WRITER);
            return Optional.empty();
        }
        if (messageBodyWriter instanceof NoWriter) {
            return Optional.empty();
        }
        return Optional.of(messageBodyWriter);
    }

    private static void addContentType(MutableHeaders outgoingHeaders, @Nullable MediaType mediaType) {
        if (mediaType != null && !outgoingHeaders.contains("Content-Type")) {
            outgoingHeaders.set((CharSequence)"Content-Type", (CharSequence)mediaType);
        }
    }

    @Singleton
    static final class RawStringHandler
    implements MessageBodyHandler<String>,
    ChunkedMessageBodyReader<String> {
        private final ApplicationConfiguration applicationConfiguration;

        RawStringHandler(ApplicationConfiguration applicationConfiguration) {
            this.applicationConfiguration = applicationConfiguration;
        }

        @Override
        public String read(Argument<String> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
            return this.read0(byteBuffer);
        }

        private String read0(ByteBuffer<?> byteBuffer) {
            String s = byteBuffer.toString(this.applicationConfiguration.getDefaultCharset());
            if (byteBuffer instanceof ReferenceCounted) {
                ReferenceCounted rc = (ReferenceCounted)byteBuffer;
                rc.release();
            }
            return s;
        }

        @Override
        public String read(Argument<String> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
            try {
                return new String(inputStream.readAllBytes(), this.applicationConfiguration.getDefaultCharset());
            }
            catch (IOException e) {
                throw new CodecException("Failed to read InputStream", e);
            }
        }

        @Override
        public void writeTo(Argument<String> type, MediaType mediaType, String object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
            DefaultMessageBodyHandlerRegistry.addContentType(outgoingHeaders, mediaType);
            try {
                outputStream.write(object.getBytes(this.applicationConfiguration.getDefaultCharset()));
            }
            catch (IOException e) {
                throw new CodecException("Failed to write OutputStream", e);
            }
        }

        @Override
        public ByteBuffer<?> writeTo(Argument<String> type, MediaType mediaType, String object, MutableHeaders outgoingHeaders, ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
            DefaultMessageBodyHandlerRegistry.addContentType(outgoingHeaders, mediaType);
            return bufferFactory.wrap(object.getBytes(this.applicationConfiguration.getDefaultCharset()));
        }

        @Override
        public Publisher<String> readChunked(Argument<String> type, MediaType mediaType, Headers httpHeaders, Publisher<ByteBuffer<?>> input) {
            return Flux.from(input).map(this::read0);
        }
    }

    @Singleton
    static final class RawByteArrayHandler
    implements MessageBodyHandler<byte[]>,
    ChunkedMessageBodyReader<byte[]> {
        RawByteArrayHandler() {
        }

        @Override
        public byte[] read(Argument<byte[]> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
            return RawByteArrayHandler.read0(byteBuffer);
        }

        private static byte[] read0(ByteBuffer<?> byteBuffer) {
            byte[] arr = byteBuffer.toByteArray();
            if (byteBuffer instanceof ReferenceCounted) {
                ReferenceCounted rc = (ReferenceCounted)byteBuffer;
                rc.release();
            }
            return arr;
        }

        @Override
        public byte[] read(Argument<byte[]> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
            try {
                return inputStream.readAllBytes();
            }
            catch (IOException e) {
                throw new CodecException("Failed to read InputStream", e);
            }
        }

        @Override
        public void writeTo(Argument<byte[]> type, MediaType mediaType, byte[] object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
            DefaultMessageBodyHandlerRegistry.addContentType(outgoingHeaders, mediaType);
            try {
                outputStream.write(object);
            }
            catch (IOException e) {
                throw new CodecException("Failed to write OutputStream", e);
            }
        }

        @Override
        public ByteBuffer<?> writeTo(Argument<byte[]> type, MediaType mediaType, byte[] object, MutableHeaders outgoingHeaders, ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
            DefaultMessageBodyHandlerRegistry.addContentType(outgoingHeaders, mediaType);
            return bufferFactory.wrap(object);
        }

        @Override
        public Publisher<byte[]> readChunked(Argument<byte[]> type, MediaType mediaType, Headers httpHeaders, Publisher<ByteBuffer<?>> input) {
            return Flux.from(input).map(RawByteArrayHandler::read0);
        }
    }

    @Requires(bean=ByteBufferFactory.class)
    @Singleton
    static final class RawByteBufferHandler
    implements MessageBodyHandler<ByteBuffer<?>>,
    ChunkedMessageBodyReader<ByteBuffer<?>> {
        private final ByteBufferFactory<?, ?> byteBufferFactory;

        RawByteBufferHandler(ByteBufferFactory<?, ?> byteBufferFactory) {
            this.byteBufferFactory = byteBufferFactory;
        }

        @Override
        public ByteBuffer<?> read(Argument<ByteBuffer<?>> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
            return RawByteBufferHandler.read0(byteBuffer);
        }

        private static ByteBuffer<?> read0(ByteBuffer<?> byteBuffer) {
            return byteBuffer;
        }

        @Override
        public ByteBuffer<?> read(Argument<ByteBuffer<?>> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
            try {
                return this.byteBufferFactory.wrap(inputStream.readAllBytes());
            }
            catch (IOException e) {
                throw new CodecException("Failed to read InputStream", e);
            }
        }

        @Override
        public void writeTo(Argument<ByteBuffer<?>> type, MediaType mediaType, ByteBuffer<?> object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
            DefaultMessageBodyHandlerRegistry.addContentType(outgoingHeaders, mediaType);
            try {
                object.toInputStream().transferTo(outputStream);
                if (object instanceof ReferenceCounted) {
                    ReferenceCounted rc = (ReferenceCounted)object;
                    rc.release();
                }
            }
            catch (IOException e) {
                throw new CodecException("Failed to write OutputStream", e);
            }
        }

        @Override
        public ByteBuffer<?> writeTo(Argument<ByteBuffer<?>> type, MediaType mediaType, ByteBuffer<?> object, MutableHeaders outgoingHeaders, ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
            DefaultMessageBodyHandlerRegistry.addContentType(outgoingHeaders, mediaType);
            return object;
        }

        @Override
        public Publisher<ByteBuffer<?>> readChunked(Argument<ByteBuffer<?>> type, MediaType mediaType, Headers httpHeaders, Publisher<ByteBuffer<?>> input) {
            return input;
        }
    }

    record HandlerKey<T>(Argument<T> type, List<MediaType> mediaTypes) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HandlerKey that = (HandlerKey)o;
            return this.type.equalsType(that.type) && this.mediaTypes.equals(that.mediaTypes);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.type.typeHashCode(), this.mediaTypes);
        }
    }

    private record MediaTypeQualifier<T>(Argument<?> type, List<MediaType> mediaTypes, Class<? extends Annotation> annotationType) implements Qualifier<T>
    {
        public <B extends BeanType<T>> Stream<B> reduce(Class<T> beanType, Stream<B> candidates) {
            return candidates.filter(c -> {
                String[] applicableTypes = c.getAnnotationMetadata().stringValues(this.annotationType);
                if (this.type.getType() == Object.class) {
                    return false;
                }
                return applicableTypes.length == 0 || Arrays.stream(applicableTypes).anyMatch(mt -> this.mediaTypes.contains(new MediaType((String)mt)));
            });
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MediaTypeQualifier that = (MediaTypeQualifier)o;
            return this.type.equalsType(that.type) && this.mediaTypes.equals(that.mediaTypes);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.type.typeHashCode(), this.mediaTypes);
        }
    }

    private static final class NoReader
    implements MessageBodyReader<Object> {
        private NoReader() {
        }

        @Override
        public boolean isReadable(Argument<Object> type, MediaType mediaType) {
            return false;
        }

        @Override
        public Object read(Argument<Object> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
            return null;
        }

        @Override
        public Object read(Argument<Object> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
            return null;
        }
    }

    private static final class NoWriter
    implements MessageBodyWriter<Object> {
        private NoWriter() {
        }

        @Override
        public boolean isWriteable(Argument<Object> type, MediaType mediaType) {
            return false;
        }

        @Override
        public void writeTo(Argument<Object> type, MediaType mediaType, Object object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
            throw new UnsupportedOperationException();
        }
    }
}

