/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.io.Writable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;

@Singleton
public final class WritableBodyWriter
implements MessageBodyWriter<Writable> {
    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public void writeTo(Argument<Writable> type, MediaType mediaType, Writable object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        if (mediaType != null && !outgoingHeaders.contains("Content-Type")) {
            outgoingHeaders.set((CharSequence)"Content-Type", (CharSequence)mediaType);
        }
        try {
            object.writeTo(outputStream, MessageBodyWriter.getCharset((Headers)outgoingHeaders));
            outputStream.flush();
        }
        catch (IOException e) {
            throw new CodecException("Error writing body text: " + e.getMessage(), e);
        }
    }
}

