/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.filter;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.execution.CompletableFutureExecutionFlow;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.execution.ImperativeExecutionFlow;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.propagation.MutablePropagatedContext;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Executable;
import io.micronaut.core.type.UnsafeExecutable;
import io.micronaut.http.FullHttpRequest;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.filter.BaseFilterProcessor;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.FilterContinuation;
import io.micronaut.http.filter.FilterOrder;
import io.micronaut.http.filter.GenericHttpFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.reactive.execution.ReactiveExecutionFlow;
import io.micronaut.inject.ExecutableMethod;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Internal
public class FilterRunner {
    private static final Predicate<FilterMethodContext> FILTER_CONDITION_ALWAYS_TRUE = runner -> true;
    private final List<GenericHttpFilter> filters;
    private final PropagatedContext initialPropagatedContext = PropagatedContext.getOrEmpty();

    public FilterRunner(List<GenericHttpFilter> filters) {
        this.filters = Objects.requireNonNull(filters, "filters");
    }

    private static void checkOrdered(List<GenericHttpFilter> filters) {
        if (!filters.stream().allMatch(f -> f instanceof Ordered)) {
            throw new IllegalStateException("Some filters cannot be ordered: " + filters);
        }
    }

    public static void sort(@NonNull List<GenericHttpFilter> filters) {
        FilterRunner.checkOrdered(filters);
        OrderUtil.sort(filters);
    }

    public static void sortReverse(@NonNull List<GenericHttpFilter> filters) {
        FilterRunner.checkOrdered(filters);
        OrderUtil.reverseSort(filters);
    }

    protected ExecutionFlow<? extends HttpResponse<?>> processResponse(HttpRequest<?> request, HttpResponse<?> response, PropagatedContext propagatedContext) {
        return ExecutionFlow.just(response);
    }

    protected ExecutionFlow<? extends HttpResponse<?>> processFailure(HttpRequest<?> request, Throwable failure, PropagatedContext propagatedContext) {
        return ExecutionFlow.error((Throwable)failure);
    }

    public final ExecutionFlow<MutableHttpResponse<?>> run(HttpRequest<?> request) {
        return this.filterRequest(new FilterContext(request, this.initialPropagatedContext), this.filters.listIterator());
    }

    private ExecutionFlow<HttpResponse<?>> filterRequest(FilterContext context, ListIterator<GenericHttpFilter> iterator) {
        return this.filterRequest0(context, iterator).flatMap(newContext -> {
            if (newContext.response != null) {
                return this.filterResponse((FilterContext)newContext, iterator, null);
            }
            return ExecutionFlow.error((Throwable)new IllegalStateException("Request filters didn't produce any response!"));
        });
    }

    private ExecutionFlow<FilterContext> filterRequest0(FilterContext context, ListIterator<GenericHttpFilter> iterator) {
        if (context.response != null) {
            return ExecutionFlow.just((Object)context);
        }
        if (iterator.hasNext()) {
            GenericHttpFilter filter = iterator.next();
            return this.processRequestFilter(filter, context, newContext -> this.filterRequest0((FilterContext)newContext, iterator)).onErrorResume(throwable -> this.processFailure(context.request, (Throwable)throwable, context.propagatedContext).map(context::withResponse).onErrorResume(throwable2 -> this.filterResponse(context, iterator, (Throwable)throwable2).map(context::withResponse)));
        }
        return ExecutionFlow.just((Object)context);
    }

    private ExecutionFlow<HttpResponse<?>> filterResponse(FilterContext context, ListIterator<GenericHttpFilter> iterator, @Nullable Throwable exception) {
        if (iterator.hasPrevious()) {
            GenericHttpFilter filter = iterator.previous();
            return this.processResponseFilter(filter, context, exception).flatMap(newContext -> {
                if (context != newContext) {
                    return this.processResponse(newContext.request, newContext.response, newContext.propagatedContext).map(newContext::withResponse);
                }
                return ExecutionFlow.just((Object)newContext);
            }).onErrorResume(throwable -> this.processFailure(context.request, (Throwable)throwable, context.propagatedContext).map(context::withResponse)).flatMap(newContext -> this.filterResponse((FilterContext)newContext, iterator, newContext.response == null ? exception : null));
        }
        if (context.response != null) {
            return ExecutionFlow.just(context.response);
        }
        if (exception != null) {
            return ExecutionFlow.error((Throwable)exception);
        }
        return ExecutionFlow.error((Throwable)new IllegalStateException("No response after response filters completed!"));
    }

    private ExecutionFlow<FilterContext> processRequestFilter(GenericHttpFilter filter, FilterContext context, Function<FilterContext, ExecutionFlow<FilterContext>> downstream) {
        Executor executeOn;
        if (filter instanceof GenericHttpFilter.Async) {
            GenericHttpFilter.Async async = (GenericHttpFilter.Async)filter;
            executeOn = async.executor();
            filter = async.actual();
        } else {
            executeOn = null;
        }
        if (filter instanceof FilterMethod) {
            ExecutionFlow<FilterContext> filterMethodFlow;
            FilterMethod before = (FilterMethod)filter;
            if (before.isResponseFilter) {
                return downstream.apply(context);
            }
            MutablePropagatedContext mutablePropagatedContext = MutablePropagatedContext.of((PropagatedContext)context.propagatedContext);
            InternalFilterContinuation<?> continuation = before.isSuspended() ? before.createContinuation(downstream, context, mutablePropagatedContext) : null;
            FilterMethodContext filterMethodContext = new FilterMethodContext(mutablePropagatedContext, context.request, context.response, null, continuation);
            if (executeOn == null) {
                try (PropagatedContext.Scope ignore = context.propagatedContext.propagate();){
                    filterMethodFlow = before.filter(context, filterMethodContext);
                }
            } else {
                filterMethodFlow = ExecutionFlow.async((Executor)executeOn, () -> {
                    try (PropagatedContext.Scope ignore = context.propagatedContext.propagate();){
                        ExecutionFlow<FilterContext> executionFlow = before.filter(context, filterMethodContext);
                        return executionFlow;
                    }
                });
            }
            if (before.isSuspended()) {
                return filterMethodFlow;
            }
            return filterMethodFlow.flatMap(downstream);
        }
        if (filter instanceof GenericHttpFilter.AroundLegacy) {
            GenericHttpFilter.AroundLegacy around = (GenericHttpFilter.AroundLegacy)filter;
            FilterChainImpl chainSuspensionPoint = new FilterChainImpl(downstream, context);
            if (executeOn == null) {
                ExecutionFlow<FilterContext> executionFlow;
                block34: {
                    PropagatedContext.Scope ignore = context.propagatedContext.propagate();
                    try {
                        executionFlow = chainSuspensionPoint.processResult(around.bean().doFilter(context.request, chainSuspensionPoint));
                        if (ignore == null) break block34;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ignore != null) {
                                try {
                                    ignore.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            return ExecutionFlow.error((Throwable)e);
                        }
                    }
                    ignore.close();
                }
                return executionFlow;
            }
            return ExecutionFlow.async((Executor)executeOn, () -> {
                ExecutionFlow<FilterContext> executionFlow;
                block8: {
                    PropagatedContext.Scope ignore = context.propagatedContext.propagate();
                    try {
                        executionFlow = chainSuspensionPoint.processResult(around.bean().doFilter(context.request, chainSuspensionPoint));
                        if (ignore == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ignore != null) {
                                try {
                                    ignore.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            return ExecutionFlow.error((Throwable)e);
                        }
                    }
                    ignore.close();
                }
                return executionFlow;
            });
        }
        if (filter instanceof GenericHttpFilter.Terminal) {
            ExecutionFlow executionFlow;
            block35: {
                GenericHttpFilter.Terminal terminalFilter = (GenericHttpFilter.Terminal)filter;
                if (executeOn != null) {
                    throw new IllegalStateException("Async terminal filters not supported");
                }
                if (filter.isSuspended()) {
                    throw new IllegalStateException("Terminal filters cannot be suspended");
                }
                PropagatedContext.Scope ignore = context.propagatedContext.propagate();
                try {
                    executionFlow = terminalFilter.execute(context.request).map(context::withResponse).flatMap(downstream);
                    if (ignore == null) break block35;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        return ExecutionFlow.error((Throwable)e);
                    }
                }
                ignore.close();
            }
            return executionFlow;
        }
        throw new IllegalStateException("Unknown filter: " + filter);
    }

    private ExecutionFlow<FilterContext> processResponseFilter(GenericHttpFilter filter, FilterContext filterContext, Throwable exceptionToFilter) {
        Executor executeOn;
        if (filter instanceof GenericHttpFilter.Async) {
            GenericHttpFilter.Async async = (GenericHttpFilter.Async)filter;
            executeOn = async.executor();
            filter = async.actual();
        } else {
            executeOn = null;
        }
        if (exceptionToFilter != null && !filter.isFiltersException()) {
            return ExecutionFlow.just((Object)filterContext);
        }
        if (filter instanceof FilterMethod) {
            FilterMethod after = (FilterMethod)filter;
            if (after.isResponseFilter) {
                if (after.isSuspended()) {
                    return ExecutionFlow.error((Throwable)new IllegalStateException("Response filter cannot have a continuation!"));
                }
                PropagatedContext propagatedContext = filterContext.propagatedContext;
                MutablePropagatedContext mutablePropagatedContext = MutablePropagatedContext.of((PropagatedContext)propagatedContext);
                FilterMethodContext filterMethodContext = new FilterMethodContext(mutablePropagatedContext, filterContext.request, filterContext.response, exceptionToFilter, null);
                if (executeOn == null) {
                    try (PropagatedContext.Scope ignore = propagatedContext.propagate();){
                        ExecutionFlow<FilterContext> executionFlow = after.filter(filterContext, filterMethodContext);
                        return executionFlow;
                    }
                }
                return ExecutionFlow.async((Executor)executeOn, () -> {
                    try (PropagatedContext.Scope ignore = propagatedContext.propagate();){
                        ExecutionFlow<FilterContext> executionFlow = after.filter(filterContext, filterMethodContext);
                        return executionFlow;
                    }
                });
            }
        }
        return ExecutionFlow.just((Object)filterContext);
    }

    @Internal
    public static <T> FilterMethod<T> prepareFilterMethod(ConversionService conversionService, T bean, ExecutableMethod<T, ?> method, boolean isResponseFilter, FilterOrder order, RequestBinderRegistry argumentBinderRegistry) throws IllegalArgumentException {
        return FilterRunner.prepareFilterMethod(conversionService, bean, method, method.getArguments(), method.getReturnType().asArgument(), isResponseFilter, order, argumentBinderRegistry);
    }

    @Internal
    private static <T> FilterMethod<T> prepareFilterMethod(ConversionService conversionService, @Nullable T bean, @Nullable ExecutableMethod<T, ?> method, Argument<?>[] arguments, Argument<?> returnType, boolean isResponseFilter, FilterOrder order, RequestBinderRegistry argumentBinderRegistry) throws IllegalArgumentException {
        FilterArgBinder[] fulfilled = new FilterArgBinder[arguments.length];
        Predicate<FilterMethodContext> filterCondition = FILTER_CONDITION_ALWAYS_TRUE;
        boolean skipOnError = isResponseFilter;
        boolean filtersException = false;
        boolean waitForBody = false;
        ContinuationCreator continuationCreator = null;
        for (int i = 0; i < arguments.length; ++i) {
            Argument<?> argument = arguments[i];
            Class argumentType = argument.getType();
            AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
            if (annotationMetadata.hasStereotype(Bindable.class)) {
                ArgumentBinder argumentBinder = argumentBinderRegistry.findArgumentBinder(argument).orElse(null);
                if (argumentBinder != null) {
                    if (argumentBinder instanceof BaseFilterProcessor.RequiresRequestBodyBinder) {
                        if (isResponseFilter) {
                            throw new IllegalArgumentException("Cannot bind @Body in response filter method [" + method.getDescription(true) + "]");
                        }
                        waitForBody = true;
                    }
                    fulfilled[i] = ctx -> {
                        HttpRequest<?> request = ctx.request;
                        ArgumentConversionContext conversionContext = ConversionContext.of((Argument)argument);
                        ArgumentBinder.BindingResult result = argumentBinder.bind(conversionContext, request);
                        if (result.isPresentAndSatisfied()) {
                            return result.get();
                        }
                        List conversionErrors = result.getConversionErrors();
                        if (!conversionErrors.isEmpty()) {
                            throw new ConversionErrorException(argument, (ConversionError)conversionErrors.get(0));
                        }
                        throw new IllegalArgumentException("Unbindable argument [" + argument + "] to method [" + method.getDescription(true) + "]");
                    };
                    continue;
                }
                throw new IllegalArgumentException("Unsupported binding annotation in filter method [" + method.getDescription(true) + "]: " + (String)annotationMetadata.getAnnotationNameByStereotype(Bindable.class).orElse(null));
            }
            if (argumentType.isAssignableFrom(HttpRequest.class)) {
                fulfilled[i] = ctx -> ctx.request;
                continue;
            }
            if (argumentType.isAssignableFrom(MutableHttpRequest.class)) {
                fulfilled[i] = ctx -> {
                    HttpRequest<?> request = ctx.request;
                    if (!(ctx.request instanceof MutableHttpRequest)) {
                        request = ctx.request.mutate();
                    }
                    return request;
                };
                continue;
            }
            if (argumentType.isAssignableFrom(MutableHttpResponse.class)) {
                if (!isResponseFilter) {
                    throw new IllegalArgumentException("Filter is called before the response is known, can't have a response argument");
                }
                fulfilled[i] = ctx -> ctx.response;
                continue;
            }
            if (Throwable.class.isAssignableFrom(argumentType)) {
                if (!isResponseFilter) {
                    throw new IllegalArgumentException("Request filters cannot handle exceptions");
                }
                if (!argument.isNullable()) {
                    filterCondition = filterCondition.and(ctx -> ctx.failure != null && argument.isInstance((Object)ctx.failure));
                    fulfilled[i] = ctx -> ctx.failure;
                } else {
                    fulfilled[i] = ctx -> {
                        if (ctx.failure != null && argument.isInstance((Object)ctx.failure)) {
                            return ctx.failure;
                        }
                        return null;
                    };
                }
                filtersException = true;
                skipOnError = false;
                continue;
            }
            if (argumentType == FilterContinuation.class) {
                if (isResponseFilter) {
                    throw new IllegalArgumentException("Response filters cannot use filter continuations");
                }
                if (continuationCreator != null) {
                    throw new IllegalArgumentException("Only one continuation per filter is allowed");
                }
                Argument continuationReturnType = (Argument)argument.getFirstTypeVariable().orElseThrow(() -> new IllegalArgumentException("Continuations must specify generic type"));
                if (FilterRunner.isReactive(continuationReturnType) && continuationReturnType.getWrappedType().isAssignableFrom(MutableHttpResponse.class)) {
                    continuationCreator = FilterRunner.isReactive(returnType) ? ResultAwareReactiveContinuationImpl::new : ReactiveContinuationImpl::new;
                    fulfilled[i] = ctx -> ctx.continuation;
                    continue;
                }
                if (continuationReturnType.getType().isAssignableFrom(MutableHttpResponse.class)) {
                    continuationCreator = BlockingContinuationImpl::new;
                    fulfilled[i] = ctx -> ctx.continuation;
                    continue;
                }
                throw new IllegalArgumentException("Unsupported continuation type: " + continuationReturnType);
            }
            if (argumentType == MutablePropagatedContext.class) {
                fulfilled[i] = ctx -> ctx.mutablePropagatedContext;
                continue;
            }
            throw new IllegalArgumentException("Unsupported filter argument type: " + argument);
        }
        if (skipOnError) {
            filterCondition = filterCondition.and(ctx -> ctx.failure == null);
        } else if (filterCondition == FILTER_CONDITION_ALWAYS_TRUE) {
            filterCondition = null;
        }
        FilterReturnHandler returnHandler = FilterRunner.prepareReturnHandler(conversionService, returnType, isResponseFilter, continuationCreator != null, false);
        return new FilterMethod<T>(order, bean, method, isResponseFilter, fulfilled, filterCondition, continuationCreator, filtersException, waitForBody, returnHandler);
    }

    private static boolean isReactive(Argument<?> continuationReturnType) {
        return continuationReturnType.isReactive() || continuationReturnType.getType() == Publisher.class;
    }

    private static FilterReturnHandler prepareReturnHandler(ConversionService conversionService, Argument<?> type, boolean isResponseFilter, boolean hasContinuation, boolean fromOptional) throws IllegalArgumentException {
        boolean nullable;
        if (type.isOptional()) {
            FilterReturnHandler next = FilterRunner.prepareReturnHandler(conversionService, type.getWrappedType(), isResponseFilter, hasContinuation, true);
            return (r, o, c) -> next.handle(r, o == null ? null : ((Optional)o).orElse(null), c);
        }
        if (type.isVoid()) {
            if (hasContinuation) {
                return FilterReturnHandler.VOID_WITH_CONTINUATION;
            }
            return FilterReturnHandler.VOID;
        }
        boolean bl = nullable = type.isNullable() || fromOptional;
        if (!isResponseFilter) {
            if (type.getType() == HttpRequest.class || type.getType() == MutableHttpRequest.class) {
                if (hasContinuation) {
                    throw new IllegalArgumentException("Filter method that accepts a continuation cannot return an HttpRequest");
                }
                if (nullable) {
                    return FilterReturnHandler.REQUEST_NULLABLE;
                }
                return FilterReturnHandler.REQUEST;
            }
            if (type.getType() == HttpResponse.class || type.getType() == MutableHttpResponse.class) {
                if (nullable) {
                    return FilterReturnHandler.FROM_REQUEST_RESPONSE_NULLABLE;
                }
                return FilterReturnHandler.FROM_REQUEST_RESPONSE;
            }
        } else {
            if (hasContinuation) {
                throw new AssertionError();
            }
            if (type.getType() == HttpResponse.class || type.getType() == MutableHttpResponse.class) {
                if (nullable) {
                    return FilterReturnHandler.FROM_RESPONSE_RESPONSE_NULLABLE;
                }
                return FilterReturnHandler.FROM_RESPONSE_RESPONSE;
            }
        }
        if (FilterRunner.isReactive(type)) {
            FilterReturnHandler next = FilterRunner.prepareReturnHandler(conversionService, type.getWrappedType(), isResponseFilter, hasContinuation, false);
            return (context, returnValue, continuation) -> {
                if (returnValue == null && !nullable) {
                    return next.handle(context, null, continuation);
                }
                Mono publisher = Mono.from((Publisher)((Publisher)Publishers.convertPublisher((ConversionService)conversionService, (Object)returnValue, Publisher.class)));
                if (continuation instanceof ResultAwareContinuation) {
                    ResultAwareContinuation resultAwareContinuation = (ResultAwareContinuation)continuation;
                    return resultAwareContinuation.processResult(publisher);
                }
                return ReactiveExecutionFlow.fromPublisher(publisher).flatMap(v -> {
                    try {
                        return next.handle(context, v, continuation);
                    }
                    catch (Throwable e) {
                        return ExecutionFlow.error((Throwable)e);
                    }
                });
            };
        }
        if (type.isAsync()) {
            FilterReturnHandler next = FilterRunner.prepareReturnHandler(conversionService, type.getWrappedType(), isResponseFilter, hasContinuation, false);
            return new DelayedFilterReturnHandler(isResponseFilter, next, nullable){

                @Override
                protected ExecutionFlow<?> toFlow(FilterContext context, Object returnValue, InternalFilterContinuation<?> continuation) {
                    return CompletableFutureExecutionFlow.just(((CompletionStage)returnValue).toCompletableFuture());
                }
            };
        }
        throw new IllegalArgumentException("Unsupported filter return type " + type.getType().getName());
    }

    private record FilterContext(@NonNull HttpRequest<?> request, @Nullable HttpResponse<?> response, @NonNull PropagatedContext propagatedContext) {
        FilterContext(HttpRequest<?> request, PropagatedContext propagatedContext) {
            this(request, null, propagatedContext);
        }

        public FilterContext withRequest(@NonNull HttpRequest<?> request) {
            if (this.request == request) {
                return this;
            }
            if (this.response != null) {
                throw new IllegalStateException("Cannot modify the request after response is set!");
            }
            Objects.requireNonNull(request);
            return new FilterContext(request, this.response, this.propagatedContext);
        }

        public FilterContext withResponse(@NonNull HttpResponse<?> response) {
            if (this.response == response) {
                return this;
            }
            Objects.requireNonNull(response);
            return new FilterContext(this.request, response, this.propagatedContext);
        }

        public FilterContext withPropagatedContext(@NonNull PropagatedContext propagatedContext) {
            if (this.propagatedContext == propagatedContext) {
                return this;
            }
            Objects.requireNonNull(propagatedContext);
            return new FilterContext(this.request, this.response, propagatedContext);
        }
    }

    record FilterMethod<T>(FilterOrder order, T bean, Executable<T, ?> method, boolean isResponseFilter, FilterArgBinder[] argBinders, @Nullable Predicate<FilterMethodContext> filterCondition, ContinuationCreator continuationCreator, boolean filtersException, boolean waitForBody, FilterReturnHandler returnHandler) implements GenericHttpFilter,
    Ordered
    {
        @Override
        public boolean isSuspended() {
            return this.continuationCreator != null;
        }

        @Override
        public boolean isFiltersException() {
            return this.filtersException;
        }

        public int getOrder() {
            return this.order.getOrder(this.bean);
        }

        public InternalFilterContinuation<?> createContinuation(Function<FilterContext, ExecutionFlow<FilterContext>> downstream, FilterContext filterContext, MutablePropagatedContext mutablePropagatedContext) {
            return this.continuationCreator.create(downstream, filterContext, mutablePropagatedContext);
        }

        private ExecutionFlow<FilterContext> filter(FilterContext filterContext, FilterMethodContext methodContext) {
            try {
                ExecutionFlow<ByteBuffer<?>> buffered;
                FullHttpRequest fhr;
                HttpRequest<?> httpRequest;
                if (this.filterCondition != null && !this.filterCondition.test(methodContext)) {
                    return ExecutionFlow.just((Object)filterContext);
                }
                if (this.waitForBody && (httpRequest = filterContext.request) instanceof FullHttpRequest && !(fhr = (FullHttpRequest)httpRequest).isFull() && (buffered = fhr.bufferContents()) != null && buffered.tryComplete() == null) {
                    return buffered.then(() -> this.filter0(filterContext, methodContext));
                }
                return this.filter0(filterContext, methodContext);
            }
            catch (Throwable e) {
                return ExecutionFlow.error((Throwable)e);
            }
        }

        private ExecutionFlow<FilterContext> filter0(FilterContext filterContext, FilterMethodContext methodContext) {
            try {
                Object returnValue;
                Object[] args = this.bindArgs(methodContext);
                Executable<T, ?> executable = this.method;
                if (executable instanceof UnsafeExecutable) {
                    UnsafeExecutable unsafeExecutable = (UnsafeExecutable)executable;
                    returnValue = unsafeExecutable.invokeUnsafe(this.bean, args);
                } else {
                    returnValue = this.method.invoke(this.bean, args);
                }
                ExecutionFlow executionFlow = this.returnHandler.handle(filterContext, returnValue, methodContext.continuation);
                PropagatedContext mutatedPropagatedContext = methodContext.mutablePropagatedContext.getContext();
                if (mutatedPropagatedContext != filterContext.propagatedContext) {
                    executionFlow = executionFlow.map(fc -> fc.withPropagatedContext(mutatedPropagatedContext));
                }
                return executionFlow;
            }
            catch (Throwable e) {
                return ExecutionFlow.error((Throwable)e);
            }
        }

        private Object[] bindArgs(FilterMethodContext context) {
            Object[] args = new Object[this.argBinders.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.argBinders[i].bind(context);
            }
            return args;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface InternalFilterContinuation<R>
    extends FilterContinuation<R> {
        public FilterContext afterMethodContext();
    }

    private record FilterMethodContext(MutablePropagatedContext mutablePropagatedContext, HttpRequest<?> request, @Nullable HttpResponse<?> response, @Nullable Throwable failure, @Nullable InternalFilterContinuation<?> continuation) {
    }

    private static final class FilterChainImpl
    implements ClientFilterChain,
    ServerFilterChain {
        private final Function<FilterContext, ExecutionFlow<FilterContext>> downstream;
        private FilterContext filterContext;

        private FilterChainImpl(Function<FilterContext, ExecutionFlow<FilterContext>> downstream, FilterContext filterContext) {
            this.downstream = downstream;
            this.filterContext = filterContext;
        }

        @Override
        public Publisher<? extends HttpResponse<?>> proceed(MutableHttpRequest<?> request) {
            this.filterContext = this.filterContext.withRequest(request).withPropagatedContext(PropagatedContext.find().orElse(this.filterContext.propagatedContext));
            return ReactiveExecutionFlow.fromFlow(this.downstream.apply(this.filterContext).map(newFilterContext -> {
                this.filterContext = newFilterContext;
                return newFilterContext.response;
            })).toPublisher();
        }

        @Override
        public Publisher<MutableHttpResponse<?>> proceed(HttpRequest<?> request) {
            this.filterContext = this.filterContext.withRequest(request).withPropagatedContext(PropagatedContext.find().orElse(this.filterContext.propagatedContext));
            return ReactiveExecutionFlow.fromFlow(this.downstream.apply(this.filterContext).map(newFilterContext -> {
                this.filterContext = newFilterContext;
                return (MutableHttpResponse)newFilterContext.response;
            })).toPublisher();
        }

        public ExecutionFlow<FilterContext> processResult(Publisher<? extends HttpResponse<?>> publisher) {
            return ReactiveExecutionFlow.fromPublisher(publisher).map(httpResponse -> this.filterContext.withResponse((HttpResponse<?>)httpResponse));
        }
    }

    private static interface FilterArgBinder {
        public Object bind(FilterMethodContext var1);
    }

    private static interface ContinuationCreator {
        public InternalFilterContinuation<?> create(Function<FilterContext, ExecutionFlow<FilterContext>> var1, FilterContext var2, MutablePropagatedContext var3);
    }

    private static interface FilterReturnHandler {
        public static final FilterReturnHandler VOID_WITH_CONTINUATION = (filterContext, returnValue, continuation) -> ExecutionFlow.just((Object)continuation.afterMethodContext());
        public static final FilterReturnHandler VOID = (filterContext, returnValue, continuation) -> ExecutionFlow.just((Object)filterContext);
        public static final FilterReturnHandler REQUEST = (filterContext, returnValue, continuation) -> ExecutionFlow.just((Object)filterContext.withRequest((HttpRequest)Objects.requireNonNull(returnValue, "Returned request must not be null, or mark the method as @Nullable")));
        public static final FilterReturnHandler REQUEST_NULLABLE = (filterContext, returnValue, continuation) -> {
            if (returnValue == null) {
                return ExecutionFlow.just((Object)filterContext);
            }
            return ExecutionFlow.just((Object)filterContext.withRequest((HttpRequest)returnValue));
        };
        public static final FilterReturnHandler FROM_REQUEST_RESPONSE = (filterContext, returnValue, continuation) -> ExecutionFlow.just((Object)filterContext.withResponse((HttpResponse)Objects.requireNonNull(returnValue, "Returned response must not be null, or mark the method as @Nullable")));
        public static final FilterReturnHandler FROM_REQUEST_RESPONSE_NULLABLE = (filterContext, returnValue, continuation) -> {
            if (returnValue == null) {
                return ExecutionFlow.just((Object)filterContext);
            }
            return ExecutionFlow.just((Object)filterContext.withResponse((HttpResponse)returnValue));
        };
        public static final FilterReturnHandler FROM_RESPONSE_RESPONSE = (filterContext, returnValue, continuation) -> ExecutionFlow.just((Object)filterContext.withResponse((HttpResponse)Objects.requireNonNull(returnValue, "Returned response must not be null, or mark the method as @Nullable")));
        public static final FilterReturnHandler FROM_RESPONSE_RESPONSE_NULLABLE = (filterContext, returnValue, continuation) -> {
            if (returnValue == null) {
                return ExecutionFlow.just((Object)filterContext);
            }
            return ExecutionFlow.just((Object)filterContext.withResponse((HttpResponse)returnValue));
        };

        public ExecutionFlow<FilterContext> handle(FilterContext var1, @Nullable Object var2, @Nullable InternalFilterContinuation<?> var3) throws Throwable;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface ResultAwareContinuation<T>
    extends InternalFilterContinuation<T> {
        public ExecutionFlow<FilterContext> processResult(T var1);
    }

    private static final class BlockingContinuationImpl
    implements FilterContinuation<HttpResponse<?>>,
    InternalFilterContinuation<HttpResponse<?>> {
        private final Function<FilterContext, ExecutionFlow<FilterContext>> downstream;
        private FilterContext filterContext;
        private final MutablePropagatedContext mutablePropagatedContext;

        private BlockingContinuationImpl(Function<FilterContext, ExecutionFlow<FilterContext>> downstream, FilterContext filterContext, MutablePropagatedContext mutablePropagatedContext) {
            this.downstream = downstream;
            this.filterContext = filterContext;
            this.mutablePropagatedContext = mutablePropagatedContext;
        }

        @Override
        public FilterContinuation<HttpResponse<?>> request(HttpRequest<?> request) {
            this.filterContext = this.filterContext.withRequest(request);
            PropagatedContext propagatedContext = this.filterContext.propagatedContext;
            PropagatedContext mutatedPropagatedContext = this.mutablePropagatedContext.getContext();
            this.filterContext = propagatedContext != mutatedPropagatedContext ? this.filterContext.withPropagatedContext(mutatedPropagatedContext) : this.filterContext.withPropagatedContext(PropagatedContext.find().orElse(this.filterContext.propagatedContext));
            return new BlockingContinuationImpl(this.downstream, this.filterContext, this.mutablePropagatedContext);
        }

        @Override
        public HttpResponse<?> proceed() {
            boolean interrupted = false;
            while (true) {
                try {
                    this.filterContext = (FilterContext)this.downstream.apply(this.filterContext).toCompletableFuture().get();
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return this.filterContext.response;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        RuntimeException re = (RuntimeException)cause;
                        throw re;
                    }
                    throw new RuntimeException(cause);
                }
                break;
            }
        }

        @Override
        public FilterContext afterMethodContext() {
            return this.filterContext;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static class ReactiveContinuationImpl
    implements FilterContinuation<Publisher<HttpResponse<?>>>,
    InternalFilterContinuation<Publisher<HttpResponse<?>>> {
        protected FilterContext filterContext;
        private final Function<FilterContext, ExecutionFlow<FilterContext>> downstream;
        private final MutablePropagatedContext mutablePropagatedContext;

        private ReactiveContinuationImpl(Function<FilterContext, ExecutionFlow<FilterContext>> downstream, FilterContext filterContext, MutablePropagatedContext mutablePropagatedContext) {
            this.downstream = downstream;
            this.filterContext = filterContext;
            this.mutablePropagatedContext = mutablePropagatedContext;
        }

        @Override
        public FilterContinuation<Publisher<HttpResponse<?>>> request(HttpRequest<?> request) {
            return new ReactiveContinuationImpl(this.downstream, this.filterContext.withRequest(request), this.mutablePropagatedContext);
        }

        @Override
        public Publisher<HttpResponse<?>> proceed() {
            PropagatedContext propagatedContext = this.filterContext.propagatedContext;
            PropagatedContext mutatedPropagatedContext = this.mutablePropagatedContext.getContext();
            this.filterContext = propagatedContext != mutatedPropagatedContext ? this.filterContext.withPropagatedContext(mutatedPropagatedContext) : this.filterContext.withPropagatedContext(PropagatedContext.find().orElse(this.filterContext.propagatedContext));
            return ReactiveExecutionFlow.fromFlow(this.downstream.apply(this.filterContext).map(newFilterContext -> {
                this.filterContext = newFilterContext;
                return newFilterContext.response;
            })).toPublisher();
        }

        @Override
        public FilterContext afterMethodContext() {
            return this.filterContext;
        }
    }

    private static final class ResultAwareReactiveContinuationImpl
    extends ReactiveContinuationImpl
    implements ResultAwareContinuation<Publisher<HttpResponse<?>>> {
        private ResultAwareReactiveContinuationImpl(Function<FilterContext, ExecutionFlow<FilterContext>> next, FilterContext filterContext, MutablePropagatedContext mutablePropagatedContext) {
            super(next, filterContext, mutablePropagatedContext);
        }

        @Override
        public ExecutionFlow<FilterContext> processResult(Publisher<HttpResponse<?>> publisher) {
            return ReactiveExecutionFlow.fromPublisher(publisher).map(httpResponse -> this.filterContext.withResponse((HttpResponse<?>)httpResponse));
        }
    }

    private static abstract class DelayedFilterReturnHandler
    implements FilterReturnHandler {
        final boolean isResponseFilter;
        final FilterReturnHandler next;
        final boolean nullable;

        private DelayedFilterReturnHandler(boolean isResponseFilter, FilterReturnHandler next, boolean nullable) {
            this.isResponseFilter = isResponseFilter;
            this.next = next;
            this.nullable = nullable;
        }

        protected abstract ExecutionFlow<?> toFlow(FilterContext var1, Object var2, @Nullable InternalFilterContinuation<?> var3);

        @Override
        public ExecutionFlow<FilterContext> handle(FilterContext context, @Nullable Object returnValue, InternalFilterContinuation<?> continuation) throws Throwable {
            if (returnValue == null && this.nullable) {
                return this.next.handle(context, null, continuation);
            }
            ExecutionFlow<?> delayedFlow = this.toFlow(context, Objects.requireNonNull(returnValue, "Returned value must not be null, or mark the method as @Nullable"), continuation);
            ImperativeExecutionFlow doneFlow = delayedFlow.tryComplete();
            if (doneFlow != null) {
                if (doneFlow.getError() != null) {
                    throw doneFlow.getError();
                }
                return this.next.handle(context, doneFlow.getValue(), continuation);
            }
            return delayedFlow.flatMap(v -> {
                try {
                    return this.next.handle(context, v, continuation);
                }
                catch (Throwable e) {
                    return ExecutionFlow.error((Throwable)e);
                }
            });
        }
    }
}

