/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.converters;

import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.io.Readable;
import io.micronaut.core.io.ResourceResolver;
import jakarta.inject.Provider;
import java.net.URL;
import java.util.Optional;

@Prototype
public class HttpConverterRegistrar
implements TypeConverterRegistrar {
    private final Provider<ResourceResolver> resourceResolver;

    protected HttpConverterRegistrar(Provider<ResourceResolver> resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public void register(MutableConversionService conversionService) {
        conversionService.addConverter(CharSequence.class, Readable.class, (object, targetType, context) -> {
            String pathStr = object.toString();
            Optional supportingLoader = ((ResourceResolver)this.resourceResolver.get()).getSupportingLoader(pathStr);
            if (!supportingLoader.isPresent()) {
                context.reject((Object)pathStr, (Exception)new ConfigurationException("No supported resource loader for path [" + pathStr + "]. Prefix the path with a supported prefix such as 'classpath:' or 'file:'"));
                return Optional.empty();
            }
            Optional resource = ((ResourceResolver)this.resourceResolver.get()).getResource(pathStr);
            if (resource.isPresent()) {
                return Optional.of(Readable.of((URL)((URL)resource.get())));
            }
            context.reject(object, (Exception)new ConfigurationException("No resource exists for value: " + object));
            return Optional.empty();
        });
    }
}

