/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyHandler;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.RawMessageBodyHandler;
import io.micronaut.http.codec.CodecException;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Internal
abstract class RawMessageBodyHandlerRegistry
implements MessageBodyHandlerRegistry {
    private static final MessageBodyReader<Object> NO_READER = new NoReader();
    private static final MessageBodyWriter<Object> NO_WRITER = new NoWriter();
    private final Map<HandlerKey<?>, MessageBodyReader<?>> readers = new ConcurrentHashMap(10);
    private final Map<HandlerKey<?>, MessageBodyWriter<?>> writers = new ConcurrentHashMap(10);
    private final List<RawEntry> rawHandlers;

    RawMessageBodyHandlerRegistry(List<RawMessageBodyHandler<?>> rawHandlers) {
        this.rawHandlers = rawHandlers.stream().flatMap(h -> h.getTypes().stream().map(t -> new RawEntry((Class<?>)t, (MessageBodyHandler<?>)h))).toList();
    }

    @Nullable
    private <T> MessageBodyHandler<T> rawHandler(Argument<T> type, boolean covariant) {
        for (RawEntry entry : this.rawHandlers) {
            if (!(covariant ? entry.type.isAssignableFrom(type.getType()) : entry.type == type.getType())) continue;
            return entry.handler;
        }
        return null;
    }

    protected abstract <T> MessageBodyReader<T> findReaderImpl(Argument<T> var1, List<MediaType> var2);

    @Override
    public <T> Optional<MessageBodyReader<T>> findReader(Argument<T> type, List<MediaType> mediaTypes) {
        HandlerKey<T> key = new HandlerKey<T>(type, mediaTypes);
        MessageBodyReader<?> messageBodyReader = this.readers.get(key);
        if (messageBodyReader == null) {
            MessageBodyReader<T> reader = this.rawHandler(type, false);
            if (reader == null) {
                reader = this.findReaderImpl(type, mediaTypes);
            }
            if (reader != null) {
                this.readers.put(key, reader);
                return Optional.of(reader);
            }
            this.readers.put(key, NO_READER);
            return Optional.empty();
        }
        if (messageBodyReader instanceof NoReader) {
            return Optional.empty();
        }
        return Optional.of(messageBodyReader);
    }

    protected abstract <T> MessageBodyWriter<T> findWriterImpl(Argument<T> var1, List<MediaType> var2);

    @Override
    public <T> Optional<MessageBodyWriter<T>> findWriter(Argument<T> type, List<MediaType> mediaType) {
        HandlerKey<T> key = new HandlerKey<T>(type, mediaType);
        MessageBodyWriter<?> messageBodyWriter = this.writers.get(key);
        if (messageBodyWriter == null) {
            MessageBodyWriter<T> writer = this.rawHandler(type, true);
            if (writer == null && type.getType() != Object.class) {
                writer = this.findWriterImpl(type, mediaType);
            }
            if (writer != null) {
                this.writers.put(key, writer);
                return Optional.of(writer);
            }
            this.writers.put(key, NO_WRITER);
            return Optional.empty();
        }
        if (messageBodyWriter instanceof NoWriter) {
            return Optional.empty();
        }
        return Optional.of(messageBodyWriter);
    }

    private static void addContentType(MutableHeaders outgoingHeaders, @Nullable MediaType mediaType) {
        if (mediaType != null && !outgoingHeaders.contains("Content-Type")) {
            outgoingHeaders.set((CharSequence)"Content-Type", (CharSequence)mediaType);
        }
    }

    private record RawEntry(Class<?> type, MessageBodyHandler<?> handler) {
    }

    record HandlerKey<T>(Argument<T> type, List<MediaType> mediaTypes) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HandlerKey that = (HandlerKey)o;
            return this.type.equalsType(that.type) && this.mediaTypes.equals(that.mediaTypes);
        }

        @Override
        public int hashCode() {
            return ObjectUtils.hash((Object)this.type.typeHashCode(), this.mediaTypes);
        }
    }

    private static final class NoReader
    implements MessageBodyReader<Object> {
        private NoReader() {
        }

        @Override
        public boolean isReadable(Argument<Object> type, MediaType mediaType) {
            return false;
        }

        @Override
        public Object read(Argument<Object> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
            return null;
        }

        @Override
        public Object read(Argument<Object> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
            return null;
        }
    }

    private static final class NoWriter
    implements MessageBodyWriter<Object> {
        private NoWriter() {
        }

        @Override
        public boolean isWriteable(Argument<Object> type, MediaType mediaType) {
            return false;
        }

        @Override
        public void writeTo(Argument<Object> type, MediaType mediaType, Object object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
            throw new UnsupportedOperationException();
        }
    }

    @Requires(bean=ByteBufferFactory.class)
    @Singleton
    @BootstrapContextCompatible
    @Bean(typed={RawMessageBodyHandler.class})
    static final class RawByteBufferHandler
    implements RawMessageBodyHandler<ByteBuffer<?>> {
        private final ByteBufferFactory<?, ?> byteBufferFactory;

        RawByteBufferHandler(ByteBufferFactory<?, ?> byteBufferFactory) {
            this.byteBufferFactory = byteBufferFactory;
        }

        @Override
        public ByteBuffer<?> read(Argument<ByteBuffer<?>> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
            return RawByteBufferHandler.read0(byteBuffer);
        }

        private static ByteBuffer<?> read0(ByteBuffer<?> byteBuffer) {
            return byteBuffer;
        }

        @Override
        public ByteBuffer<?> read(Argument<ByteBuffer<?>> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
            try {
                return this.byteBufferFactory.wrap(inputStream.readAllBytes());
            }
            catch (IOException e) {
                throw new CodecException("Failed to read InputStream", e);
            }
        }

        @Override
        public void writeTo(Argument<ByteBuffer<?>> type, MediaType mediaType, ByteBuffer<?> object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
            RawMessageBodyHandlerRegistry.addContentType(outgoingHeaders, mediaType);
            try {
                object.toInputStream().transferTo(outputStream);
                if (object instanceof ReferenceCounted) {
                    ReferenceCounted rc = (ReferenceCounted)object;
                    rc.release();
                }
            }
            catch (IOException e) {
                throw new CodecException("Failed to write OutputStream", e);
            }
        }

        @Override
        public ByteBuffer<?> writeTo(Argument<ByteBuffer<?>> type, MediaType mediaType, ByteBuffer<?> object, MutableHeaders outgoingHeaders, ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
            RawMessageBodyHandlerRegistry.addContentType(outgoingHeaders, mediaType);
            return object;
        }

        @Override
        public Publisher<ByteBuffer<?>> readChunked(Argument<ByteBuffer<?>> type, MediaType mediaType, Headers httpHeaders, Publisher<ByteBuffer<?>> input) {
            return input;
        }

        @Override
        public Collection<Class<ByteBuffer<?>>> getTypes() {
            return List.of(ByteBuffer.class);
        }
    }

    @Singleton
    @BootstrapContextCompatible
    @Bean(typed={RawMessageBodyHandler.class})
    static final class RawByteArrayHandler
    implements RawMessageBodyHandler<byte[]> {
        RawByteArrayHandler() {
        }

        @Override
        public byte[] read(Argument<byte[]> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
            return RawByteArrayHandler.read0(byteBuffer);
        }

        private static byte[] read0(ByteBuffer<?> byteBuffer) {
            byte[] arr = byteBuffer.toByteArray();
            if (byteBuffer instanceof ReferenceCounted) {
                ReferenceCounted rc = (ReferenceCounted)byteBuffer;
                rc.release();
            }
            return arr;
        }

        @Override
        public byte[] read(Argument<byte[]> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
            try {
                return inputStream.readAllBytes();
            }
            catch (IOException e) {
                throw new CodecException("Failed to read InputStream", e);
            }
        }

        @Override
        public void writeTo(Argument<byte[]> type, MediaType mediaType, byte[] object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
            RawMessageBodyHandlerRegistry.addContentType(outgoingHeaders, mediaType);
            try {
                outputStream.write(object);
            }
            catch (IOException e) {
                throw new CodecException("Failed to write OutputStream", e);
            }
        }

        @Override
        public ByteBuffer<?> writeTo(Argument<byte[]> type, MediaType mediaType, byte[] object, MutableHeaders outgoingHeaders, ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
            RawMessageBodyHandlerRegistry.addContentType(outgoingHeaders, mediaType);
            return bufferFactory.wrap(object);
        }

        @Override
        public Publisher<byte[]> readChunked(Argument<byte[]> type, MediaType mediaType, Headers httpHeaders, Publisher<ByteBuffer<?>> input) {
            return Flux.from(input).map(RawByteArrayHandler::read0);
        }

        @Override
        public Collection<Class<byte[]>> getTypes() {
            return List.of(byte[].class);
        }
    }

    @Singleton
    @BootstrapContextCompatible
    @Bean(typed={RawMessageBodyHandler.class})
    static final class RawStringHandler
    implements RawMessageBodyHandler<Object> {
        private final ApplicationConfiguration applicationConfiguration;

        RawStringHandler(ApplicationConfiguration applicationConfiguration) {
            this.applicationConfiguration = applicationConfiguration;
        }

        @Override
        public Collection<Class<?>> getTypes() {
            return List.of(String.class, CharSequence.class);
        }

        @Override
        public String read(Argument<Object> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
            return this.read0(byteBuffer);
        }

        private String read0(ByteBuffer<?> byteBuffer) {
            String s = byteBuffer.toString(this.applicationConfiguration.getDefaultCharset());
            if (byteBuffer instanceof ReferenceCounted) {
                ReferenceCounted rc = (ReferenceCounted)byteBuffer;
                rc.release();
            }
            return s;
        }

        @Override
        public String read(Argument<Object> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
            try {
                return new String(inputStream.readAllBytes(), this.applicationConfiguration.getDefaultCharset());
            }
            catch (IOException e) {
                throw new CodecException("Failed to read InputStream", e);
            }
        }

        @Override
        public void writeTo(Argument<Object> type, MediaType mediaType, Object object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
            RawMessageBodyHandlerRegistry.addContentType(outgoingHeaders, mediaType);
            try {
                outputStream.write(object.toString().getBytes(this.applicationConfiguration.getDefaultCharset()));
            }
            catch (IOException e) {
                throw new CodecException("Failed to write OutputStream", e);
            }
        }

        @Override
        public ByteBuffer<?> writeTo(Argument<Object> type, MediaType mediaType, Object object, MutableHeaders outgoingHeaders, ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
            RawMessageBodyHandlerRegistry.addContentType(outgoingHeaders, mediaType);
            return bufferFactory.wrap(object.toString().getBytes(this.applicationConfiguration.getDefaultCharset()));
        }

        @Override
        public Publisher<Object> readChunked(Argument<Object> type, MediaType mediaType, Headers httpHeaders, Publisher<ByteBuffer<?>> input) {
            return Flux.from(input).map(this::read0);
        }
    }
}

