/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.core.io.buffer.ReadBufferFactory;
import io.micronaut.http.body.AvailableByteBody;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.stream.BaseSharedBuffer;
import io.micronaut.http.body.stream.BaseStreamingByteBody;
import io.micronaut.http.body.stream.BodySizeLimits;
import io.micronaut.http.body.stream.BufferConsumer;
import java.nio.charset.StandardCharsets;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;

@Internal
public class ConcatenatingSubscriber
implements BufferConsumer.Upstream,
CoreSubscriber<ByteBody>,
BufferConsumer {
    protected final BaseSharedBuffer sharedBuffer;
    protected final BaseStreamingByteBody<?> rootBody;
    private final ByteBodyFactory byteBodyFactory;
    private final Separators separators;
    private long forwarded;
    private long consumed;
    private Subscription subscription;
    private boolean cancelled;
    private volatile boolean disregardBackpressure;
    private boolean first = true;
    private BufferConsumer.Upstream currentComponent;
    private boolean start = false;
    private boolean delayedSubscriberCompletion = false;
    private boolean currentComponentDone = false;

    public ConcatenatingSubscriber(ByteBodyFactory byteBodyFactory, Separators separators) {
        this.byteBodyFactory = byteBodyFactory;
        this.separators = separators;
        ByteBodyFactory.StreamingBody sb = byteBodyFactory.createStreamingBody(BodySizeLimits.UNLIMITED, this);
        this.sharedBuffer = sb.sharedBuffer();
        this.rootBody = sb.rootBody();
    }

    public static CloseableByteBody concatenate(ByteBodyFactory byteBodyFactory, Publisher<ByteBody> publisher, Separators separators) {
        ConcatenatingSubscriber subscriber = new ConcatenatingSubscriber(byteBodyFactory, separators);
        publisher.subscribe((Subscriber)subscriber);
        return subscriber.rootBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSubscribe(Subscription s) {
        boolean start;
        boolean cancelled;
        ConcatenatingSubscriber concatenatingSubscriber = this;
        synchronized (concatenatingSubscriber) {
            this.subscription = s;
            cancelled = this.cancelled;
            start = this.start;
        }
        if (cancelled) {
            s.cancel();
        } else if (start) {
            s.request(1L);
        }
    }

    private void emitLeadingSeparator(boolean first) {
        ReadBuffer rb;
        ReadBuffer readBuffer = rb = first ? this.separators.beforeFirst : this.separators.between;
        if (rb != null) {
            this.add(rb.duplicate());
        }
    }

    private void emitFinalSeparator(boolean first) {
        ReadBuffer rb;
        ReadBuffer readBuffer = rb = first ? this.separators.empty : this.separators.afterLast;
        if (rb != null) {
            this.add(rb.duplicate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onComplete() {
        ConcatenatingSubscriber concatenatingSubscriber = this;
        synchronized (concatenatingSubscriber) {
            if (this.currentComponent != null) {
                this.delayedSubscriberCompletion = true;
                return;
            }
        }
        this.emitFinalSeparator(this.first);
        this.forwardComplete();
    }

    public final void onError(Throwable t) {
        this.forwardError(t);
    }

    @Nullable
    protected final BufferConsumer.Upstream forward(ByteBody body) {
        if (body instanceof AvailableByteBody) {
            AvailableByteBody abb = (AvailableByteBody)body;
            this.add(abb.toReadBuffer());
            this.complete();
            return null;
        }
        try (BaseStreamingByteBody<?> s = this.byteBodyFactory.toStreaming(body);){
            BufferConsumer.Upstream upstream = s.primary(this);
            return upstream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onForward(long n) {
        ConcatenatingSubscriber concatenatingSubscriber = this;
        synchronized (concatenatingSubscriber) {
            this.forwarded += n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onNext(ByteBody body) {
        long preAcknowledged;
        this.emitLeadingSeparator(this.first);
        this.first = false;
        BufferConsumer.Upstream component = this.forward(body);
        if (component == null) {
            return;
        }
        ConcatenatingSubscriber concatenatingSubscriber = this;
        synchronized (concatenatingSubscriber) {
            preAcknowledged = this.consumed - this.forwarded;
            this.currentComponent = component;
        }
        component.start();
        if (this.disregardBackpressure) {
            component.disregardBackpressure();
        } else if (preAcknowledged > 0L) {
            component.onBytesConsumed(preAcknowledged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() {
        Subscription initialDemand;
        ConcatenatingSubscriber concatenatingSubscriber = this;
        synchronized (concatenatingSubscriber) {
            initialDemand = this.subscription;
            this.start = true;
        }
        if (initialDemand != null) {
            initialDemand.request(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onBytesConsumed(long bytesConsumed) {
        boolean requestNewComponent;
        BufferConsumer.Upstream currentComponent;
        long delta;
        ConcatenatingSubscriber concatenatingSubscriber = this;
        synchronized (concatenatingSubscriber) {
            long newConsumed = this.consumed + bytesConsumed;
            if (newConsumed < this.consumed) {
                newConsumed = Long.MAX_VALUE;
            }
            delta = newConsumed - this.consumed;
            this.consumed = newConsumed;
            currentComponent = this.currentComponent;
            requestNewComponent = currentComponent == null && this.currentComponentDone && newConsumed >= this.forwarded;
        }
        if (currentComponent != null && delta > 0L) {
            currentComponent.onBytesConsumed(bytesConsumed);
        } else if (requestNewComponent) {
            this.subscription.request(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void allowDiscard() {
        Subscription subscription;
        BufferConsumer.Upstream component;
        ConcatenatingSubscriber concatenatingSubscriber = this;
        synchronized (concatenatingSubscriber) {
            component = this.currentComponent;
            subscription = this.subscription;
            this.cancelled = true;
        }
        if (subscription != null) {
            subscription.cancel();
        }
        if (component != null) {
            component.allowDiscard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void disregardBackpressure() {
        BufferConsumer.Upstream component;
        ConcatenatingSubscriber concatenatingSubscriber = this;
        synchronized (concatenatingSubscriber) {
            component = this.currentComponent;
            this.disregardBackpressure = true;
        }
        if (component != null) {
            component.disregardBackpressure();
        }
    }

    @Override
    public void add(@NonNull ReadBuffer buffer) {
        int n = buffer.readable();
        this.onForward(n);
        this.sharedBuffer.add(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void complete() {
        boolean requestNextComponent;
        boolean delayedSubscriberCompletion;
        ConcatenatingSubscriber concatenatingSubscriber = this;
        synchronized (concatenatingSubscriber) {
            this.currentComponent = null;
            delayedSubscriberCompletion = this.delayedSubscriberCompletion;
            requestNextComponent = !delayedSubscriberCompletion && (this.disregardBackpressure || this.consumed >= this.forwarded);
            this.currentComponentDone = !requestNextComponent;
        }
        if (delayedSubscriberCompletion) {
            this.onComplete();
        } else if (requestNextComponent) {
            this.subscription.request(1L);
        }
    }

    @Override
    public final void error(Throwable e) {
        this.subscription.cancel();
        this.forwardError(e);
    }

    protected void forwardComplete() {
        this.sharedBuffer.complete();
    }

    protected void forwardError(Throwable t) {
        this.sharedBuffer.error(t);
    }

    public record Separators(@Nullable ReadBuffer beforeFirst, @Nullable ReadBuffer afterLast, @Nullable ReadBuffer between, @Nullable ReadBuffer empty) {
        public static final Separators NONE = new Separators(null, null, null, null);
        public static final Separators JDK_JSON = Separators.jsonSeparators(ReadBufferFactory.getJdkFactory());

        @NonNull
        public static Separators jsonSeparators(@NonNull ReadBufferFactory factory) {
            return new Separators(factory.copyOf((CharSequence)"[", StandardCharsets.UTF_8), factory.copyOf((CharSequence)"]", StandardCharsets.UTF_8), factory.copyOf((CharSequence)",", StandardCharsets.UTF_8), factory.copyOf((CharSequence)"[]", StandardCharsets.UTF_8));
        }
    }
}

