/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.AbstractMessageBodyHandlerRegistry;
import io.micronaut.http.body.ByteArrayBodyHandler;
import io.micronaut.http.body.ByteBodyWriter;
import io.micronaut.http.body.ByteBufferBodyHandler;
import io.micronaut.http.body.CharSequenceBodyWriter;
import io.micronaut.http.body.MessageBodyHandler;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.StringBodyReader;
import io.micronaut.http.body.TextPlainObjectBodyReader;
import io.micronaut.http.body.TextPlainObjectBodyWriter;
import io.micronaut.http.body.TypedMessageBodyHandler;
import io.micronaut.http.body.TypedMessageBodyReader;
import io.micronaut.http.body.TypedMessageBodyWriter;
import io.micronaut.runtime.ApplicationConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Internal
public final class ContextlessMessageBodyHandlerRegistry
extends AbstractMessageBodyHandlerRegistry {
    private final List<ReaderEntry> readerEntries = new ArrayList<ReaderEntry>();
    private final List<WriterEntry> writerEntries = new ArrayList<WriterEntry>();
    private final List<TypedMessageBodyReader<?>> typedMessageBodyReaders;
    private final List<TypedMessageBodyWriter<?>> typedMessageBodyWriters;

    public ContextlessMessageBodyHandlerRegistry(ApplicationConfiguration applicationConfiguration, ByteBufferFactory<?, ?> byteBufferFactory, TypedMessageBodyHandler<?> ... otherRawHandlers) {
        this.typedMessageBodyReaders = new ArrayList(3 + otherRawHandlers.length);
        this.typedMessageBodyReaders.add(new StringBodyReader(applicationConfiguration));
        this.typedMessageBodyReaders.add(new ByteArrayBodyHandler());
        this.typedMessageBodyReaders.add(new ByteBufferBodyHandler(byteBufferFactory));
        this.typedMessageBodyWriters = new ArrayList(3 + otherRawHandlers.length);
        this.typedMessageBodyWriters.add(new CharSequenceBodyWriter(applicationConfiguration));
        this.typedMessageBodyWriters.add(new ByteArrayBodyHandler());
        this.typedMessageBodyWriters.add(new ByteBodyWriter());
        this.typedMessageBodyWriters.add(new ByteBufferBodyHandler(byteBufferFactory));
        for (TypedMessageBodyHandler<?> otherRawHandler : otherRawHandlers) {
            this.typedMessageBodyReaders.add(otherRawHandler);
            this.typedMessageBodyWriters.add(otherRawHandler);
        }
        this.add(MediaType.TEXT_PLAIN_TYPE, new TextPlainObjectBodyReader(applicationConfiguration, ConversionService.SHARED));
        this.add(MediaType.TEXT_PLAIN_TYPE, new TextPlainObjectBodyWriter());
    }

    public void add(@NonNull MediaType mediaType, @NonNull MessageBodyHandler<?> handler) {
        this.writerEntries.add(new WriterEntry(handler, mediaType));
        this.readerEntries.add(new ReaderEntry(handler, mediaType));
    }

    public void add(@NonNull MediaType mediaType, @NonNull MessageBodyWriter<?> handler) {
        this.writerEntries.add(new WriterEntry(handler, mediaType));
    }

    public void add(@NonNull MediaType mediaType, @NonNull MessageBodyReader<?> handler) {
        this.readerEntries.add(new ReaderEntry(handler, mediaType));
    }

    @Override
    protected <T> MessageBodyReader<T> findReaderImpl(Argument<T> type, List<MediaType> mediaTypes) {
        Iterator<Object> iterator = this.typedMessageBodyReaders.iterator();
        while (iterator.hasNext()) {
            TypedMessageBodyReader<?> messageBodyReader;
            TypedMessageBodyReader<?> reader = messageBodyReader = iterator.next();
            if ((!type.getType().isAssignableFrom(reader.getType().getType()) || !mediaTypes.isEmpty() || !reader.isReadable(type, null)) && !mediaTypes.stream().anyMatch(mt -> reader.isReadable(type, (MediaType)mt))) continue;
            return reader;
        }
        for (MediaType mediaType : mediaTypes) {
            for (ReaderEntry entry : this.readerEntries) {
                if (!mediaType.matches(entry.mediaType)) continue;
                return entry.handler;
            }
        }
        return null;
    }

    @Override
    protected <T> MessageBodyWriter<T> findWriterImpl(Argument<T> type, List<MediaType> mediaTypes) {
        Iterator<Object> iterator = this.typedMessageBodyWriters.iterator();
        while (iterator.hasNext()) {
            TypedMessageBodyWriter<?> messageBodyReader;
            TypedMessageBodyWriter<?> writer = messageBodyReader = iterator.next();
            if (!messageBodyReader.getType().isAssignableFrom(type.getType()) || (!mediaTypes.isEmpty() || !writer.isWriteable(type, null)) && !mediaTypes.stream().anyMatch(mt -> writer.isWriteable(type, (MediaType)mt))) continue;
            return messageBodyReader;
        }
        for (MediaType mediaType : mediaTypes) {
            for (WriterEntry entry : this.writerEntries) {
                if (!mediaType.matches(entry.mediaType)) continue;
                return entry.handler;
            }
        }
        return null;
    }

    private record WriterEntry(MessageBodyWriter<?> handler, MediaType mediaType) {
    }

    private record ReaderEntry(MessageBodyReader<?> handler, MediaType mediaType) {
    }
}

