/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body.stream;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.body.ByteBody;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
abstract class ExtendedInputStream
extends InputStream {
    private static final int CHUNK_SIZE = 8192;
    private static final Logger LOG = LoggerFactory.getLogger(ExtendedInputStream.class);

    ExtendedInputStream() {
    }

    static ExtendedInputStream wrap(InputStream inputStream) {
        return new Wrapper(inputStream);
    }

    @Override
    public int read() throws IOException {
        byte[] arr1 = new byte[1];
        int n = this.read(arr1);
        if (n == -1) {
            return -1;
        }
        if (n == 0) {
            throw new IllegalStateException("Read 0 bytes");
        }
        return arr1[0] & 0xFF;
    }

    @Override
    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public byte @Nullable [] readSome() throws IOException {
        byte[] arr = new byte[8192];
        int n = this.read(arr);
        if (n == -1) {
            return null;
        }
        if (n == arr.length) {
            return arr;
        }
        return Arrays.copyOf(arr, n);
    }

    @Override
    public void close() {
        this.allowDiscard();
        this.cancelInput();
    }

    public abstract void allowDiscard();

    public abstract void cancelInput();

    private static final class Wrapper
    extends ExtendedInputStream {
        private final Lock lock = new ReentrantLock();
        private final InputStream delegate;
        private boolean discarded;

        Wrapper(InputStream delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.lock.lock();
            try {
                if (this.discarded) {
                    throw ByteBody.BodyDiscardedException.create();
                }
                int n = this.delegate.read(b, off, len);
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void close() {
            try {
                this.delegate.close();
            }
            catch (IOException e) {
                LOG.debug("Failed to close request stream", (Throwable)e);
            }
        }

        @Override
        public void allowDiscard() {
            this.lock.lock();
            try {
                this.discarded = true;
                this.close();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void cancelInput() {
        }
    }
}

