/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.ssl;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.ssl.CertificateProvider;
import io.netty.pkitesting.CertificateBuilder;
import io.netty.pkitesting.X509Bundle;
import jakarta.inject.Named;
import java.security.KeyStore;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

@EachBean(value=Config.class)
@Requires(classes={X509Bundle.class})
@BootstrapContextCompatible
public final class SelfSignedCertificateProvider
implements CertificateProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SelfSignedCertificateProvider.class);
    private final String name;
    private final Flux<KeyStore> bundleFlux;

    SelfSignedCertificateProvider(@NonNull Config config, @NonNull @Named(value="scheduled") ExecutorService scheduler) throws Exception {
        this.name = config.name;
        Sinks.Many sink = Sinks.many().replay().latest();
        SelfSignedCertificateProvider.update(config, (Sinks.Many<KeyStore>)sink);
        ((ScheduledExecutorService)scheduler).scheduleAtFixedRate(() -> {
            try {
                SelfSignedCertificateProvider.update(config, (Sinks.Many<KeyStore>)sink);
            }
            catch (Exception e) {
                LOG.warn("Failed to build self-signed certificate '{}'", (Object)config.name, (Object)e);
            }
        }, config.updateInterval.toNanos(), config.updateInterval.toNanos(), TimeUnit.NANOSECONDS);
        this.bundleFlux = sink.asFlux();
    }

    private static void update(@NonNull Config config, @NonNull Sinks.Many<KeyStore> sink) throws Exception {
        X509Bundle bundle = new CertificateBuilder().algorithm(config.algorithm).subject(config.subject).notAfter(Instant.now().plus(config.lifetime)).setIsCertificateAuthority(true).buildSelfSigned();
        sink.tryEmitNext((Object)bundle.toKeyStore(null));
    }

    @Override
    @NonNull
    public @NonNull Publisher<@NonNull KeyStore> getKeyStore() {
        return this.bundleFlux;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @EachProperty(value="micronaut.certificate.self-signed")
    @BootstrapContextCompatible
    public static final class Config
    implements io.micronaut.core.naming.Named {
        private final String name;
        private CertificateBuilder.Algorithm algorithm = CertificateBuilder.Algorithm.rsa4096;
        private String subject = "CN=localhost";
        private Duration updateInterval = Duration.ofDays(1L);
        private Duration lifetime = Duration.ofDays(7L);

        public Config(@Parameter @NonNull String name) {
            this.name = name;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        @NonNull
        public CertificateBuilder.Algorithm getAlgorithm() {
            return this.algorithm;
        }

        public void setAlgorithm(@NonNull CertificateBuilder.Algorithm algorithm) {
            this.algorithm = algorithm;
        }

        @NonNull
        public String getSubject() {
            return this.subject;
        }

        public void setSubject(@NonNull String subject) {
            this.subject = subject;
        }

        @NonNull
        public Duration getUpdateInterval() {
            return this.updateInterval;
        }

        public void setUpdateInterval(@NonNull Duration updateInterval) {
            this.updateInterval = updateInterval;
        }

        @NonNull
        public Duration getLifetime() {
            return this.lifetime;
        }

        public void setLifetime(@NonNull Duration lifetime) {
            this.lifetime = lifetime;
        }
    }
}

