/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body.stream;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.core.io.buffer.ReadBufferFactory;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.body.InternalByteBody;
import io.micronaut.http.body.stream.BaseSharedBuffer;
import java.util.Objects;
import org.reactivestreams.Publisher;

public final class AvailableByteArrayBody
extends InternalByteBody
implements CloseableAvailableByteBody {
    private ReadBuffer readBuffer;

    private AvailableByteArrayBody(ReadBuffer readBuffer) {
        this.readBuffer = Objects.requireNonNull(readBuffer, "readBuffer");
    }

    @Deprecated
    @NonNull
    public static AvailableByteArrayBody create(@NonNull ByteBufferFactory<?, ?> bufferFactory, byte @NonNull [] array) {
        ArgumentUtils.requireNonNull((String)"bufferFactory", bufferFactory);
        ArgumentUtils.requireNonNull((String)"array", (Object)array);
        return new AvailableByteArrayBody(ReadBufferFactory.getJdkFactory().adapt(array));
    }

    @NonNull
    public static AvailableByteArrayBody create(@NonNull ReadBuffer readBuffer) {
        return new AvailableByteArrayBody(readBuffer);
    }

    @Override
    @NonNull
    public CloseableAvailableByteBody split() {
        if (this.readBuffer == null) {
            this.failClaim();
        }
        return new AvailableByteArrayBody(this.readBuffer.duplicate());
    }

    @Override
    public long length() {
        if (this.readBuffer == null) {
            this.failClaim();
        }
        return this.readBuffer.readable();
    }

    @Override
    public byte @NonNull [] toByteArray() {
        try (ReadBuffer rb = this.toReadBuffer();){
            byte[] byArray = rb.toArray();
            return byArray;
        }
    }

    @Override
    @NonNull
    public ReadBuffer toReadBuffer() {
        ReadBuffer a = this.readBuffer;
        if (a == null) {
            this.failClaim();
        }
        this.recordPrimaryOp();
        this.readBuffer = null;
        BaseSharedBuffer.logClaim();
        return a;
    }

    @Override
    @NonNull
    public Publisher<ReadBuffer> toReadBufferPublisher() {
        return Publishers.just((Object)this.toReadBuffer());
    }

    @Override
    @NonNull
    public CloseableAvailableByteBody move() {
        return new AvailableByteArrayBody(this.toReadBuffer());
    }

    @Override
    public void close() {
        ReadBuffer rb = this.readBuffer;
        if (rb != null) {
            this.recordClosed();
            rb.close();
            this.readBuffer = null;
        }
    }

    @Override
    @NonNull
    public ExecutionFlow<? extends CloseableAvailableByteBody> bufferFlow() {
        return ExecutionFlow.just((Object)this.move());
    }

    @Internal
    public ReadBuffer peek() {
        ReadBuffer b = this.readBuffer;
        if (b == null) {
            this.failClaim();
        }
        return b;
    }
}

