/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.core.io.buffer.ReadBufferFactory;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.CloseableAvailableByteBody;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.OptionalLong;
import org.reactivestreams.Publisher;

public interface AvailableByteBody
extends ByteBody {
    @Override
    @NonNull
    public CloseableAvailableByteBody split();

    @Override
    @Deprecated
    @NonNull
    default public CloseableAvailableByteBody split(@NonNull ByteBody.SplitBackpressureMode backpressureMode) {
        return this.split();
    }

    @Override
    @NonNull
    @Deprecated
    default public AvailableByteBody allowDiscard() {
        return this;
    }

    public long length();

    @Override
    @NonNull
    @Deprecated
    default public OptionalLong expectedLength() {
        return OptionalLong.of(this.length());
    }

    public byte @NonNull [] toByteArray();

    @NonNull
    default public ReadBuffer toReadBuffer() {
        return ReadBufferFactory.getJdkFactory().adapt(this.toByteArray());
    }

    @NonNull
    default public ByteBuffer<?> toByteBuffer() {
        try (ReadBuffer rb = this.toReadBuffer();){
            ByteBuffer byteBuffer = rb.toByteBuffer();
            return byteBuffer;
        }
    }

    @Override
    @NonNull
    default public InputStream toInputStream() {
        try (ReadBuffer rb = this.toReadBuffer();){
            InputStream inputStream = rb.toInputStream();
            return inputStream;
        }
    }

    @NonNull
    default public String toString(@NonNull Charset charset) {
        try (ReadBuffer rb = this.toReadBuffer();){
            String string = rb.toString(charset);
            return string;
        }
    }

    @Override
    @NonNull
    @Deprecated
    default public Publisher<ByteBuffer<?>> toByteBufferPublisher() {
        return Publishers.just(this.toByteBuffer());
    }

    @Override
    @NonNull
    @Deprecated
    default public Publisher<byte[]> toByteArrayPublisher() {
        return Publishers.just((Object)this.toByteArray());
    }

    @Override
    @NonNull
    @Deprecated
    default public Publisher<ReadBuffer> toReadBufferPublisher() {
        return Publishers.just((Object)this.toReadBuffer());
    }
}

