/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body.stream;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.DelayedExecutionFlow;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.core.io.buffer.ReadBufferFactory;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.stream.BodySizeLimits;
import io.micronaut.http.body.stream.BufferConsumer;
import io.micronaut.http.exceptions.BufferLengthExceededException;
import io.micronaut.http.exceptions.ContentLengthExceededException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

@Internal
public abstract class BaseSharedBuffer
implements BufferConsumer {
    private static final Class<ByteBody> SPLIT_LOG_CLASS = ByteBody.class;
    private static final Logger SPLIT_LOG = LoggerFactory.getLogger(SPLIT_LOG_CLASS);
    private final ReadBufferFactory readBufferFactory;
    private final BodySizeLimits limits;
    private final BufferConsumer.Upstream rootUpstream;
    private boolean complete;
    private Throwable error;
    private int reserved = 1;
    private List<@NonNull BufferConsumer> subscribers;
    private List<@NonNull DelayedExecutionFlow<ReadBuffer>> fullSubscribers;
    private boolean working = false;
    private long lengthSoFar = 0L;
    private volatile long expectedLength = -1L;
    private List<ReadBuffer> buffer;
    private BufferLengthExceededException bufferLimitsExceeded = null;

    public BaseSharedBuffer(ReadBufferFactory readBufferFactory, BodySizeLimits limits, BufferConsumer.Upstream rootUpstream) {
        this.readBufferFactory = readBufferFactory;
        this.limits = limits;
        this.rootUpstream = rootUpstream;
    }

    public static void logClaim() {
        if (SPLIT_LOG.isTraceEnabled()) {
            SPLIT_LOG.trace("Body split at this location. This is not an error, but may aid in debugging other errors", (Throwable)new Exception());
        }
    }

    public final OptionalLong getExpectedLength() {
        long l = this.expectedLength;
        return l < 0L ? OptionalLong.empty() : OptionalLong.of(l);
    }

    public final BodySizeLimits getLimits() {
        return this.limits;
    }

    public final BufferConsumer.Upstream getRootUpstream() {
        return this.rootUpstream;
    }

    public final void setExpectedLengthFrom(String contentLength) {
        long parsed;
        if (contentLength == null) {
            return;
        }
        try {
            parsed = Long.parseLong(contentLength);
        }
        catch (NumberFormatException e) {
            return;
        }
        if (parsed < 0L) {
            return;
        }
        if (parsed > this.limits.maxBodySize()) {
            this.error(new ContentLengthExceededException(this.limits.maxBodySize(), parsed));
        }
        this.setExpectedLength(parsed);
    }

    public final void setExpectedLength(long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("Should be > 0");
        }
        this.expectedLength = length;
    }

    protected void reserve0() {
        if (this.reserved == 0) {
            throw new IllegalStateException("Cannot go from streaming state back to buffering state");
        }
        ++this.reserved;
    }

    private void forwardInitialBuffer(@Nullable BufferConsumer subscriber, boolean last) {
        if (subscriber != null) {
            if (this.buffer != null) {
                subscriber.add(this.getBufferedData(last));
            }
        } else if (last) {
            this.discardBuffer();
        }
    }

    protected void afterSubscribe(boolean last) {
    }

    private ReadBuffer getBufferedData(boolean discardBuffer) {
        if (this.buffer == null) {
            return this.readBufferFactory.createEmpty();
        }
        if (discardBuffer) {
            List<ReadBuffer> pieces = this.buffer;
            this.buffer = null;
            return this.readBufferFactory.compose(pieces);
        }
        ArrayList<ReadBuffer> pieces = new ArrayList<ReadBuffer>(this.buffer.size());
        for (ReadBuffer buffer : this.buffer) {
            pieces.add(buffer.duplicate());
        }
        return this.readBufferFactory.compose(pieces);
    }

    protected final void subscribe0(@Nullable BufferConsumer subscriber, BufferConsumer.Upstream specificUpstream) {
        boolean last;
        assert (!this.working);
        if (this.reserved == 0) {
            throw new IllegalStateException("Need to reserve a spot first");
        }
        this.working = true;
        boolean bl = last = --this.reserved == 0;
        if (subscriber != null) {
            if (this.subscribers == null) {
                this.subscribers = new ArrayList<BufferConsumer>(1);
            }
            this.subscribers.add(subscriber);
            this.forwardInitialBuffer(subscriber, last);
            if (this.error != null) {
                subscriber.error(this.error);
            } else if (this.bufferLimitsExceeded != null) {
                subscriber.error(this.bufferLimitsExceeded);
                specificUpstream.allowDiscard();
            }
            if (this.complete) {
                subscriber.complete();
            }
        } else {
            this.forwardInitialBuffer(null, last);
        }
        this.afterSubscribe(last);
        this.working = false;
    }

    protected final ExecutionFlow<ReadBuffer> subscribeFull0(DelayedExecutionFlow<ReadBuffer> targetFlow, BufferConsumer.Upstream specificUpstream, boolean canReturnImmediate) {
        assert (!this.working);
        if (this.reserved <= 0) {
            throw new IllegalStateException("Need to reserve a spot first. This should not happen, StreamingNettyByteBody should guard against it");
        }
        ExecutionFlow ret = targetFlow;
        this.working = true;
        boolean last = --this.reserved == 0;
        Throwable error = this.error;
        if (error == null && this.lengthSoFar > this.limits.maxBufferSize()) {
            error = new BufferLengthExceededException(this.limits.maxBufferSize(), this.lengthSoFar);
            specificUpstream.allowDiscard();
        }
        if (error != null) {
            if (canReturnImmediate) {
                ret = ExecutionFlow.error((Throwable)error);
            } else {
                targetFlow.completeExceptionally(error);
            }
        } else if (this.bufferLimitsExceeded != null) {
            if (canReturnImmediate) {
                ret = ExecutionFlow.error((Throwable)this.bufferLimitsExceeded);
            } else {
                targetFlow.completeExceptionally((Throwable)this.bufferLimitsExceeded);
            }
        } else if (this.complete) {
            ReadBuffer buf = this.getBufferedData(last);
            if (canReturnImmediate) {
                ret = ExecutionFlow.just((Object)buf);
            } else {
                targetFlow.complete((Object)buf);
            }
        } else {
            if (this.fullSubscribers == null) {
                this.fullSubscribers = new ArrayList<DelayedExecutionFlow<ReadBuffer>>(1);
            }
            this.fullSubscribers.add((DelayedExecutionFlow<ReadBuffer>)targetFlow);
        }
        this.afterSubscribe(last);
        this.working = false;
        return ret;
    }

    private void discardBuffer() {
        if (this.buffer != null) {
            for (ReadBuffer rb : this.buffer) {
                rb.close();
            }
            this.buffer = null;
        }
    }

    @Override
    public void add(ReadBuffer rb) {
        try (ReadBuffer readBuffer = rb;){
            assert (!this.working);
            long newLength = this.lengthSoFar + (long)rb.readable();
            long expectedLength = this.expectedLength;
            if (expectedLength != -1L && newLength > expectedLength) {
                throw new IncorrectContentLengthException("Received more bytes than specified by Content-Length");
            }
            this.lengthSoFar = newLength;
            if (this.complete || this.error != null) {
                return;
            }
            if (newLength > this.limits.maxBodySize()) {
                this.error(new ContentLengthExceededException(this.limits.maxBodySize(), newLength));
                this.rootUpstream.allowDiscard();
                return;
            }
            this.working = true;
            if (this.subscribers != null) {
                for (BufferConsumer bufferConsumer : this.subscribers) {
                    bufferConsumer.add(rb.duplicate());
                }
            }
            if (this.reserved > 0 || this.fullSubscribers != null) {
                if (newLength > this.limits.maxBufferSize() || this.bufferLimitsExceeded != null) {
                    this.discardBuffer();
                    if (this.bufferLimitsExceeded == null) {
                        this.bufferLimitsExceeded = new BufferLengthExceededException(this.limits.maxBufferSize(), this.lengthSoFar);
                        if (this.fullSubscribers != null) {
                            for (DelayedExecutionFlow delayedExecutionFlow : this.fullSubscribers) {
                                delayedExecutionFlow.completeExceptionally((Throwable)this.bufferLimitsExceeded);
                            }
                            this.fullSubscribers = null;
                        }
                    }
                } else {
                    if (this.buffer == null) {
                        this.buffer = new ArrayList<ReadBuffer>();
                    }
                    this.buffer.add(rb.move());
                }
            }
            this.working = false;
        }
    }

    @Override
    public void complete() {
        if (this.expectedLength > this.lengthSoFar) {
            throw new IncorrectContentLengthException("Received fewer bytes than specified by Content-Length");
        }
        this.complete = true;
        this.expectedLength = this.lengthSoFar;
        if (this.subscribers != null) {
            for (BufferConsumer subscriber : this.subscribers) {
                subscriber.complete();
            }
        }
        if (this.fullSubscribers != null && this.bufferLimitsExceeded == null) {
            boolean last = this.reserved <= 0;
            Iterator<DelayedExecutionFlow<ReadBuffer>> iterator = this.fullSubscribers.iterator();
            while (iterator.hasNext()) {
                DelayedExecutionFlow<ReadBuffer> fullSubscriber = iterator.next();
                fullSubscriber.complete((Object)this.getBufferedData(last && !iterator.hasNext()));
            }
            this.fullSubscribers = null;
        }
    }

    @Override
    public void error(Throwable e) {
        if (this.error != null) {
            this.error.addSuppressed(e);
            return;
        }
        this.error = e;
        this.discardBuffer();
        if (this.subscribers != null) {
            for (BufferConsumer bufferConsumer : this.subscribers) {
                bufferConsumer.error(e);
            }
        }
        if (this.fullSubscribers != null && this.bufferLimitsExceeded == null) {
            for (DelayedExecutionFlow delayedExecutionFlow : this.fullSubscribers) {
                delayedExecutionFlow.completeExceptionally(e);
            }
            this.fullSubscribers = null;
        }
    }

    public static final class IncorrectContentLengthException
    extends IllegalStateException {
        IncorrectContentLengthException(String msg) {
            super(msg);
        }
    }

    public static final class AsFlux
    implements BufferConsumer {
        private final BaseSharedBuffer sharedBuffer;
        private final AtomicLong unconsumed = new AtomicLong(0L);
        private final Sinks.Many<ReadBuffer> sink = Sinks.many().unicast().onBackpressureBuffer();

        public AsFlux(BaseSharedBuffer sharedBuffer) {
            this.sharedBuffer = sharedBuffer;
        }

        @Override
        public void add(ReadBuffer buf) {
            long newLength = this.unconsumed.addAndGet(buf.readable());
            if (newLength > this.sharedBuffer.getLimits().maxBufferSize()) {
                this.sink.tryEmitError((Throwable)new BufferLengthExceededException(this.sharedBuffer.getLimits().maxBufferSize(), newLength));
                buf.close();
            } else if (this.sink.tryEmitNext((Object)buf) != Sinks.EmitResult.OK) {
                buf.close();
            }
        }

        @Override
        public void complete() {
            this.sink.tryEmitComplete();
        }

        @Override
        public void error(Throwable e) {
            this.sink.tryEmitError(e);
        }

        public Flux<ReadBuffer> asFlux(BufferConsumer.Upstream upstream) {
            return this.sink.asFlux().doOnSubscribe(s -> upstream.start()).doOnNext(bb -> {
                int size = bb.readable();
                this.unconsumed.addAndGet(-size);
                upstream.onBytesConsumed(size);
            }).doOnCancel(() -> {
                upstream.allowDiscard();
                upstream.disregardBackpressure();
            }).doOnDiscard(ReadBuffer.class, ReadBuffer::close);
        }
    }
}

