/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body.stream;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.InternalByteBody;
import io.micronaut.http.body.stream.BaseSharedBuffer;
import io.micronaut.http.body.stream.BufferConsumer;
import io.micronaut.http.body.stream.PublisherAsBlocking;
import io.micronaut.http.body.stream.PublisherAsStream;
import java.io.InputStream;
import java.util.OptionalLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

@Internal
public abstract class BaseStreamingByteBody<SB extends BaseSharedBuffer>
extends InternalByteBody
implements CloseableByteBody {
    protected final SB sharedBuffer;
    protected BufferConsumer.Upstream upstream;

    protected BaseStreamingByteBody(SB sharedBuffer, BufferConsumer.Upstream upstream) {
        this.sharedBuffer = sharedBuffer;
        this.upstream = upstream;
    }

    @Override
    @NonNull
    public final OptionalLong expectedLength() {
        return ((BaseSharedBuffer)this.sharedBuffer).getExpectedLength();
    }

    @NonNull
    public abstract BufferConsumer.Upstream primary(@Nullable BufferConsumer var1);

    @NonNull
    protected abstract BaseStreamingByteBody<SB> derive(@NonNull BufferConsumer.Upstream var1);

    @Override
    @NonNull
    public final Publisher<ReadBuffer> toReadBufferPublisher() {
        BaseSharedBuffer.AsFlux asFlux = new BaseSharedBuffer.AsFlux((BaseSharedBuffer)this.sharedBuffer);
        BufferConsumer.Upstream upstream = this.primary(asFlux);
        return asFlux.asFlux(upstream);
    }

    @Override
    @NonNull
    public final InputStream toInputStream() {
        PublisherAsBlocking publisherAsBlocking = new PublisherAsBlocking();
        this.toReadBufferPublisher().subscribe((Subscriber)publisherAsBlocking);
        return new PublisherAsStream(publisherAsBlocking);
    }

    @Override
    @NonNull
    public final CloseableByteBody move() {
        BufferConsumer.Upstream upstream = this.upstream;
        if (upstream == null) {
            this.failClaim();
        }
        this.recordPrimaryOp();
        this.upstream = null;
        return this.derive(upstream);
    }

    @Override
    @NonNull
    public final CloseableByteBody allowDiscard() {
        BufferConsumer.Upstream upstream = this.upstream;
        if (upstream == null) {
            this.failClaim();
        }
        upstream.allowDiscard();
        return this;
    }
}

