/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.ssl;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.ssl.AbstractCertificateFileConfig;
import io.micronaut.http.ssl.CertificateProvider;
import io.micronaut.http.ssl.PemParser;
import io.micronaut.http.ssl.SslBuilder;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Named;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

@EachBean(value=Config.class)
@BootstrapContextCompatible
public final class FileCertificateProvider
implements CertificateProvider {
    private static final Logger LOG = LoggerFactory.getLogger(FileCertificateProvider.class);
    private final String name;
    private final Flux<KeyStore> flux;
    private final WatchService watchService;

    FileCertificateProvider(@NonNull Config config, @NonNull @Named(value="scheduled") ExecutorService scheduler, @NonNull @Named(value="blocking") Executor blockingExecutor) throws Exception {
        if (config.refreshMode == RefreshMode.NONE) {
            this.flux = Flux.just((Object)FileCertificateProvider.load(config));
            this.watchService = null;
        } else {
            Sinks.Many sink = Sinks.many().replay().latest();
            this.flux = sink.asFlux();
            WatchService ws = null;
            if (config.refreshMode == RefreshMode.FILE_WATCHER || config.refreshMode == RefreshMode.FILE_WATCHER_OR_SCHEDULER) {
                Path directory = config.path.getParent();
                try {
                    ws = directory.getFileSystem().newWatchService();
                    directory.register(ws, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
                }
                catch (UnsupportedOperationException uoe) {
                    if (ws != null) {
                        try {
                            ws.close();
                        }
                        catch (IOException ioe) {
                            uoe.addSuppressed(ioe);
                        }
                        ws = null;
                    }
                    if (config.refreshMode == RefreshMode.FILE_WATCHER) {
                        throw uoe;
                    }
                    LOG.debug("Failed to create watch service, falling back on scheduled refresh", (Throwable)uoe);
                }
            }
            this.watchService = ws;
            sink.tryEmitNext((Object)FileCertificateProvider.load(config)).orThrow();
            if (ws != null) {
                WatchService finalWs = ws;
                blockingExecutor.execute(() -> {
                    try {
                        while (true) {
                            WatchKey key = finalWs.take();
                            boolean changed = false;
                            for (WatchEvent<?> event : key.pollEvents()) {
                                Path ctx;
                                Object patt5091$temp = event.context();
                                if (!(patt5091$temp instanceof Path) || !(ctx = (Path)patt5091$temp).getFileName().equals(config.path.getFileName()) && (config.certificatePath == null || !ctx.getFileName().equals(config.certificatePath.getFileName()))) continue;
                                changed = true;
                                break;
                            }
                            key.reset();
                            if (!changed) continue;
                            FileCertificateProvider.loadSafe((Sinks.Many<KeyStore>)sink, config);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (ClosedWatchServiceException e) {
                    }
                });
            } else {
                ((ScheduledExecutorService)scheduler).scheduleWithFixedDelay(() -> FileCertificateProvider.loadSafe((Sinks.Many<KeyStore>)sink, config), config.refreshInterval.toNanos(), config.refreshInterval.toNanos(), TimeUnit.NANOSECONDS);
            }
        }
        this.name = config.name;
    }

    @PreDestroy
    void close() throws IOException {
        this.watchService.close();
    }

    private static void loadSafe(Sinks.Many<KeyStore> sink, Config config) {
        try {
            sink.tryEmitNext((Object)FileCertificateProvider.load(config)).orThrow();
        }
        catch (Exception e) {
            LOG.error("Failed to load certificate file", (Throwable)e);
        }
    }

    @NonNull
    private static KeyStore load(Config config) throws GeneralSecurityException, PemParser.NotPemException, IOException {
        byte[] certBytes;
        byte[] mainBytes = Files.readAllBytes(config.path);
        if (config.certificatePath != null) {
            if (config.format != Format.PEM) {
                throw new ConfigurationException("A separate certificate-path is only permitted for PEM format. Please mark this certificate as PEM format explicitly.");
            }
            certBytes = Files.readAllBytes(config.certificatePath);
        } else {
            certBytes = null;
        }
        return FileCertificateProvider.load(config, mainBytes, certBytes);
    }

    @NonNull
    static KeyStore load(AbstractCertificateFileConfig config, byte[] mainBytes, byte[] certBytes) throws GeneralSecurityException, PemParser.NotPemException, IOException {
        KeyStore ks;
        if (config.format == null) {
            try {
                ks = FileCertificateProvider.load(config, mainBytes, certBytes, Format.JKS);
            }
            catch (IOException e) {
                if (e.getCause() instanceof UnrecoverableKeyException) {
                    throw e;
                }
                try {
                    ks = FileCertificateProvider.load(config, mainBytes, certBytes, Format.PEM);
                }
                catch (PemParser.NotPemException f) {
                    e.addSuppressed(new Exception("Also tried and failed to load the input as PEM", f));
                    throw e;
                }
                catch (Exception f) {
                    f.addSuppressed(new Exception("Also tried and failed to load the input as a key store", e));
                    throw f;
                }
            }
        } else {
            ks = FileCertificateProvider.load(config, mainBytes, certBytes, config.format);
        }
        return ks;
    }

    private static KeyStore load(AbstractCertificateFileConfig config, byte @NonNull [] mainBytes, byte @Nullable [] certBytes, @NonNull Format format) throws GeneralSecurityException, IOException, PemParser.NotPemException {
        KeyStore ks = KeyStore.getInstance(format == Format.JKS ? "JKS" : "PKCS12");
        if (format == Format.PEM) {
            ks.load(null, null);
            PemParser pemParser = new PemParser(null, config.password);
            List<Object> mainObjects = pemParser.loadPem(mainBytes);
            Object object = mainObjects.get(0);
            if (object instanceof PrivateKey) {
                List<Object> certObjects;
                PrivateKey pk = (PrivateKey)object;
                if (mainObjects.size() > 1) {
                    certObjects = mainObjects.subList(1, mainObjects.size());
                    if (certBytes != null) {
                        throw new ConfigurationException("Separate cert-path given but main file also contained certificates");
                    }
                } else {
                    certObjects = certBytes != null ? pemParser.loadPem(certBytes) : List.of();
                }
                ks.setKeyEntry("key", pk, null, SslBuilder.certificates(certObjects).toArray(new X509Certificate[0]));
            } else {
                if (certBytes != null) {
                    throw new ConfigurationException("Separate cert-path given but main file only contained certificates");
                }
                List<X509Certificate> certificates = SslBuilder.certificates(mainObjects);
                for (int i = 0; i < certificates.size(); ++i) {
                    ks.setCertificateEntry("cert" + i, certificates.get(i));
                }
            }
        } else {
            ks.load(new ByteArrayInputStream(mainBytes), config.password == null ? null : config.password.toCharArray());
        }
        return ks;
    }

    @Override
    @NonNull
    public @NonNull Publisher<@NonNull KeyStore> getKeyStore() {
        return this.flux;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @EachProperty(value="micronaut.certificate.file")
    @BootstrapContextCompatible
    public static final class Config
    extends AbstractCertificateFileConfig {
        @NonNull
        private Path path;
        @Nullable
        private Path certificatePath;
        @NonNull
        private RefreshMode refreshMode = RefreshMode.FILE_WATCHER_OR_SCHEDULER;
        @NonNull
        private Duration refreshInterval = Duration.ofHours(1L);

        public Config(@Parameter @NonNull String name) {
            super(name);
        }

        @NonNull
        public Path getPath() {
            return this.path;
        }

        public void setPath(@NonNull Path path) {
            this.path = path;
        }

        @Nullable
        public Path getCertificatePath() {
            return this.certificatePath;
        }

        public void setCertificatePath(@Nullable Path certificatePath) {
            this.certificatePath = certificatePath;
        }

        @NonNull
        public RefreshMode getRefreshMode() {
            return this.refreshMode;
        }

        public void setRefreshMode(@NonNull RefreshMode refreshMode) {
            this.refreshMode = refreshMode;
        }

        @NonNull
        public Duration getRefreshInterval() {
            return this.refreshInterval;
        }

        public void setRefreshInterval(@NonNull Duration refreshInterval) {
            this.refreshInterval = refreshInterval;
        }
    }

    public static enum RefreshMode {
        NONE,
        FILE_WATCHER,
        SCHEDULER,
        FILE_WATCHER_OR_SCHEDULER;

    }

    public static enum Format {
        JKS,
        PKCS12,
        PEM;

    }
}

