/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.bind.binders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import java.util.Optional;

@Internal
public final class CookieObjectArgumentBinder
implements RequestArgumentBinder<Cookie> {
    @Override
    public RequestArgumentBinder<Cookie> createSpecific(Argument<Cookie> argument) {
        String name = argument.getName();
        String fallback = NameUtils.hyphenate((String)name);
        return (context, source) -> {
            Cookies cookies = source.getCookies();
            Cookie cookie = cookies.get(name);
            if (cookie == null) {
                cookie = cookies.get(fallback);
            }
            Cookie finalCookie = cookie;
            return () -> finalCookie != null ? Optional.of(finalCookie) : Optional.empty();
        };
    }

    public ArgumentBinder.BindingResult<Cookie> bind(ArgumentConversionContext<Cookie> context, HttpRequest<?> source) {
        throw new IllegalStateException("Specific expected");
    }
}

