/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body.stream;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ReadBuffer;
import java.io.Closeable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.scheduler.NonBlocking;

@Internal
public final class PublisherAsBlocking
implements Subscriber<ReadBuffer>,
Closeable {
    private final Lock lock = new ReentrantLock();
    private final Condition newDataCondition = this.lock.newCondition();
    private boolean pendingDemand;
    private ReadBuffer swap;
    private Subscription subscription;
    private boolean done;
    private boolean closed;
    private Throwable failure;

    @Nullable
    public Throwable getFailure() {
        return this.failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSubscribe(Subscription s) {
        boolean closed;
        boolean pendingDemand;
        this.lock.lock();
        try {
            this.subscription = s;
            pendingDemand = this.pendingDemand;
            closed = this.closed;
        }
        finally {
            this.lock.unlock();
        }
        if (closed) {
            s.cancel();
        } else if (pendingDemand) {
            s.request(1L);
        }
    }

    public void onNext(ReadBuffer o) {
        this.lock.lock();
        try {
            if (this.closed) {
                o.close();
                return;
            }
            this.swap = o;
            this.newDataCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onError(Throwable t) {
        this.lock.lock();
        try {
            if (this.swap != null) {
                this.swap.close();
                this.swap = null;
            }
            this.failure = t;
            this.done = true;
            this.newDataCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onComplete() {
        this.lock.lock();
        try {
            this.done = true;
            this.newDataCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ReadBuffer take() throws InterruptedException {
        boolean demanded = false;
        while (true) {
            Subscription subscription;
            this.lock.lock();
            try {
                ReadBuffer swap = this.swap;
                if (swap != null) {
                    this.swap = null;
                    ReadBuffer readBuffer = swap;
                    return readBuffer;
                }
                if (this.done) {
                    ReadBuffer readBuffer = null;
                    return readBuffer;
                }
                if (demanded) {
                    if (Thread.currentThread() instanceof NonBlocking) {
                        throw new IllegalStateException("Attempted to do blocking operation on a thread marked as NonBlocking. (Maybe the netty event loop?) Please only run blocking operations on IO or virtual threads, for example by marking your controller with @ExecuteOn(TaskExecutors.BLOCKING).");
                    }
                    this.newDataCondition.await();
                }
                if ((subscription = this.subscription) == null) {
                    this.pendingDemand = true;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (demanded) continue;
            demanded = true;
            if (subscription == null) continue;
            subscription.request(1L);
        }
    }

    @Override
    public void close() {
        Subscription subscription;
        this.lock.lock();
        try {
            this.closed = true;
            subscription = this.subscription;
            if (this.swap != null) {
                this.swap.close();
                this.swap = null;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (subscription != null) {
            subscription.cancel();
        }
    }
}

