/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.cookie.SameSite;
import io.micronaut.http.cookie.SameSiteConverter;
import java.util.Optional;

@Internal
public final class HttpTypeConverterRegistrar
implements TypeConverterRegistrar {
    public void register(MutableConversionService conversionService) {
        conversionService.addConverter(CharSequence.class, MediaType.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty((CharSequence)object)) {
                return Optional.empty();
            }
            try {
                return Optional.of(MediaType.of(object.toString()));
            }
            catch (IllegalArgumentException e) {
                context.reject((Exception)e);
                return Optional.empty();
            }
        });
        conversionService.addConverter(CharSequence.class, SameSite.class, (TypeConverter)new SameSiteConverter());
    }
}

