/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyHandler;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.RawMessageBodyHandler;
import io.micronaut.http.body.RawMessageBodyHandlerRegistry;
import io.micronaut.runtime.ApplicationConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

@Internal
public final class ContextlessMessageBodyHandlerRegistry
extends RawMessageBodyHandlerRegistry {
    private final List<Entry> entries = new ArrayList<Entry>();

    public ContextlessMessageBodyHandlerRegistry(ApplicationConfiguration applicationConfiguration, ByteBufferFactory<?, ?> byteBufferFactory, RawMessageBodyHandler<?> ... otherRawHandlers) {
        super(Stream.concat(Stream.of(new RawMessageBodyHandlerRegistry.RawStringHandler(applicationConfiguration), new RawMessageBodyHandlerRegistry.RawByteArrayHandler(), new RawMessageBodyHandlerRegistry.RawByteBufferHandler(byteBufferFactory)), Stream.of(otherRawHandlers)).toList());
    }

    public void add(@NonNull MediaType mediaType, @NonNull MessageBodyHandler<?> handler) {
        this.entries.add(new Entry(handler, mediaType));
    }

    @Nullable
    private <T> MessageBodyHandler<T> findHandler(List<MediaType> mediaTypes) {
        for (MediaType mediaType : mediaTypes) {
            for (Entry entry : this.entries) {
                if (!mediaType.matches(entry.mediaType)) continue;
                return entry.handler;
            }
        }
        return null;
    }

    @Override
    protected <T> MessageBodyReader<T> findReaderImpl(Argument<T> type, List<MediaType> mediaTypes) {
        return this.findHandler(mediaTypes);
    }

    @Override
    protected <T> MessageBodyWriter<T> findWriterImpl(Argument<T> type, List<MediaType> mediaTypes) {
        return this.findHandler(mediaTypes);
    }

    private record Entry(MessageBodyHandler<?> handler, MediaType mediaType) {
    }
}

