/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body.stream;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.InternalByteBody;
import io.micronaut.http.body.stream.AvailableByteArrayBody;
import io.micronaut.http.body.stream.ExtendedInputStream;
import io.micronaut.http.body.stream.StreamPair;
import java.io.IOException;
import java.io.InputStream;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

public final class InputStreamByteBody
implements CloseableByteBody,
InternalByteBody {
    private final Context context;
    private ExtendedInputStream stream;

    private InputStreamByteBody(Context context, ExtendedInputStream stream) {
        this.context = context;
        this.stream = stream;
    }

    static void failClaim() {
        throw new IllegalStateException("Request body has already been claimed: Two conflicting sites are trying to access the request body. If this is intentional, the first user must ByteBody#split the body. To find out where the body was claimed, turn on TRACE logging for io.micronaut.http.server.netty.body.NettyByteBody.");
    }

    @NonNull
    public static CloseableByteBody create(@NonNull InputStream stream, @NonNull OptionalLong length, @NonNull Executor ioExecutor, @NonNull ByteBufferFactory<?, ?> bufferFactory) {
        ArgumentUtils.requireNonNull((String)"stream", (Object)stream);
        ArgumentUtils.requireNonNull((String)"length", (Object)length);
        ArgumentUtils.requireNonNull((String)"ioExecutor", (Object)ioExecutor);
        ArgumentUtils.requireNonNull((String)"bufferFactory", bufferFactory);
        return new InputStreamByteBody(new Context(length, ioExecutor, bufferFactory), ExtendedInputStream.wrap(stream));
    }

    @Override
    @NonNull
    public CloseableByteBody allowDiscard() {
        this.stream.allowDiscard();
        return this;
    }

    @Override
    public void close() {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    @Override
    @NonNull
    public CloseableByteBody split(ByteBody.SplitBackpressureMode backpressureMode) {
        if (this.stream == null) {
            InputStreamByteBody.failClaim();
        }
        StreamPair.Pair pair = StreamPair.createStreamPair(this.stream, backpressureMode);
        this.stream = pair.left();
        return new InputStreamByteBody(this.context, pair.right());
    }

    @Override
    @NonNull
    public OptionalLong expectedLength() {
        return this.context.expectedLength();
    }

    @Override
    @NonNull
    public ExtendedInputStream toInputStream() {
        ExtendedInputStream s = this.stream;
        if (s == null) {
            InputStreamByteBody.failClaim();
        }
        this.stream = null;
        return s;
    }

    @NonNull
    public Flux<byte[]> toByteArrayPublisher() {
        ExtendedInputStream s = this.toInputStream();
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        return sink.asFlux().doOnRequest(req -> {
            for (long remaining = req; remaining > 0L; --remaining) {
                byte[] arr;
                try {
                    arr = s.readSome();
                }
                catch (IOException e) {
                    sink.tryEmitError((Throwable)e);
                    break;
                }
                if (arr == null) {
                    sink.tryEmitComplete();
                    break;
                }
                sink.tryEmitNext((Object)arr);
            }
        }).doOnTerminate(s::close).doOnCancel(s::close).subscribeOn(Schedulers.fromExecutor((Executor)this.context.ioExecutor()));
    }

    @Override
    @NonNull
    public Publisher<ByteBuffer<?>> toByteBufferPublisher() {
        return this.toByteArrayPublisher().map(arg_0 -> this.context.bufferFactory.wrap(arg_0));
    }

    @Override
    @NonNull
    public ExecutionFlow<? extends CloseableAvailableByteBody> bufferFlow() {
        ExtendedInputStream s = this.toInputStream();
        return ExecutionFlow.async((Executor)this.context.ioExecutor, () -> {
            ExtendedInputStream t = s;
            try {
                ExecutionFlow executionFlow = ExecutionFlow.just((Object)AvailableByteArrayBody.create(this.context.bufferFactory(), t.readAllBytes()));
                if (t != null) {
                    t.close();
                }
                return executionFlow;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return ExecutionFlow.error((Throwable)e);
                }
            }
        });
    }

    private record Context(OptionalLong expectedLength, Executor ioExecutor, ByteBufferFactory<?, ?> bufferFactory) {
    }
}

