/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.filter;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.propagation.ReactivePropagation;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.util.Toggleable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.ConditionalFilter;
import io.micronaut.http.filter.FilterContext;
import io.micronaut.http.filter.FilterOrder;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.filter.InternalHttpFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.reactive.execution.ReactiveExecutionFlow;
import java.util.function.Function;
import org.reactivestreams.Publisher;

@Internal
record AroundLegacyFilter(HttpFilter bean, FilterOrder order) implements InternalHttpFilter,
Toggleable
{
    @Override
    public boolean isEnabled(HttpRequest<?> request) {
        HttpFilter httpFilter = this.bean;
        if (httpFilter instanceof ConditionalFilter) {
            ConditionalFilter conditionalFilter = (ConditionalFilter)((Object)httpFilter);
            return conditionalFilter.isEnabled(request);
        }
        return true;
    }

    @Override
    public boolean isFiltersRequest() {
        return true;
    }

    @Override
    public boolean isFiltersResponse() {
        return false;
    }

    @Override
    public boolean hasContinuation() {
        return true;
    }

    @Override
    public ExecutionFlow<FilterContext> processRequestFilter(FilterContext context, Function<FilterContext, ExecutionFlow<FilterContext>> downstream) {
        ExecutionFlow<FilterContext> executionFlow;
        block8: {
            FilterChainImpl chainSuspensionPoint = new FilterChainImpl(downstream, context);
            PropagatedContext.Scope ignore = context.propagatedContext().propagate();
            try {
                executionFlow = chainSuspensionPoint.processResult(this.bean().doFilter(context.request(), chainSuspensionPoint), context.propagatedContext());
                if (ignore == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return ExecutionFlow.error((Throwable)e);
                }
            }
            ignore.close();
        }
        return executionFlow;
    }

    public boolean isEnabled() {
        Toggleable t;
        HttpFilter httpFilter = this.bean;
        return !(httpFilter instanceof Toggleable) || (t = (Toggleable)httpFilter).isEnabled();
    }

    public int getOrder() {
        return this.order.getOrder(this.bean);
    }

    private static final class FilterChainImpl
    implements ClientFilterChain,
    ServerFilterChain {
        private final Function<FilterContext, ExecutionFlow<FilterContext>> downstream;
        private FilterContext filterContext;

        private FilterChainImpl(Function<FilterContext, ExecutionFlow<FilterContext>> downstream, FilterContext filterContext) {
            this.downstream = downstream;
            this.filterContext = filterContext;
        }

        @Override
        public Publisher<? extends HttpResponse<?>> proceed(MutableHttpRequest<?> request) {
            this.filterContext = this.filterContext.withRequest(request).withPropagatedContext(PropagatedContext.find().orElse(this.filterContext.propagatedContext()));
            return ReactiveExecutionFlow.fromFlow(this.downstream.apply(this.filterContext).map(newFilterContext -> {
                this.filterContext = newFilterContext;
                return newFilterContext.response();
            })).toPublisher();
        }

        @Override
        public Publisher<MutableHttpResponse<?>> proceed(HttpRequest<?> request) {
            this.filterContext = this.filterContext.withRequest(request).withPropagatedContext(PropagatedContext.find().orElse(this.filterContext.propagatedContext()));
            return ReactiveExecutionFlow.fromFlow(this.downstream.apply(this.filterContext).map(newFilterContext -> {
                this.filterContext = newFilterContext;
                return (MutableHttpResponse)newFilterContext.response();
            })).toPublisher();
        }

        private ExecutionFlow<FilterContext> processResult(Publisher<? extends HttpResponse<?>> publisher, PropagatedContext propagatedContext) {
            return ReactiveExecutionFlow.fromPublisher(ReactivePropagation.propagate((PropagatedContext)propagatedContext, publisher)).map(httpResponse -> this.filterContext.withResponse((HttpResponse<?>)httpResponse));
        }
    }
}

