/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import java.util.List;
import java.util.Optional;

public interface MessageBodyHandlerRegistry {
    public static final MessageBodyHandlerRegistry EMPTY = new MessageBodyHandlerRegistry(){

        @Override
        public <T> Optional<MessageBodyReader<T>> findReader(Argument<T> type, List<MediaType> mediaType) {
            return Optional.empty();
        }

        @Override
        public <T> Optional<MessageBodyWriter<T>> findWriter(Argument<T> type, List<MediaType> mediaType) {
            return Optional.empty();
        }
    };

    @NonNull
    default public <T> MessageBodyReader<T> getReader(@NonNull Argument<T> type, @Nullable List<MediaType> mediaType) {
        return this.findReader(type, mediaType).orElseThrow(() -> new CodecException("Cannot read value of argument [" + type + "]. No possible readers found for media type: " + mediaType));
    }

    public <T> Optional<MessageBodyReader<T>> findReader(@NonNull Argument<T> var1, @Nullable List<MediaType> var2);

    default public <T> Optional<MessageBodyReader<T>> findReader(@NonNull Argument<T> type, @Nullable MediaType mediaType) {
        return this.findReader(type, mediaType == null ? List.of() : List.of(mediaType));
    }

    default public <T> Optional<MessageBodyReader<T>> findReader(@NonNull Argument<T> type) {
        return this.findReader(type, List.of());
    }

    public <T> Optional<MessageBodyWriter<T>> findWriter(@NonNull Argument<T> var1, @NonNull List<MediaType> var2);

    default public <T> Optional<MessageBodyWriter<T>> findWriter(@NonNull Argument<T> type, @Nullable MediaType mediaType) {
        return this.findWriter(type, mediaType == null ? List.of() : List.of(mediaType));
    }

    default public <T> Optional<MessageBodyWriter<T>> findWriter(@NonNull Argument<T> type) {
        return this.findWriter(type, List.of());
    }

    @NonNull
    default public <T> MessageBodyWriter<T> getWriter(@NonNull Argument<T> type, @NonNull List<MediaType> mediaType) {
        return this.findWriter(type, mediaType).orElseThrow(() -> new CodecException("Cannot encode value of argument [" + type + "]. No possible encoders found for media type: " + mediaType));
    }
}

