/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.bind.binders;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.AbstractArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.CookieValue;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import io.micronaut.http.bind.binders.RequestArgumentBinder;

public class CookieAnnotationBinder<T>
extends AbstractArgumentBinder<T>
implements AnnotatedRequestArgumentBinder<CookieValue, T> {
    public CookieAnnotationBinder(ConversionService conversionService) {
        super(conversionService);
    }

    public CookieAnnotationBinder(ConversionService conversionService, Argument<T> argument) {
        super(conversionService, argument);
    }

    @Override
    public RequestArgumentBinder<T> createSpecific(Argument<T> argument) {
        return new CookieAnnotationBinder<T>(this.conversionService, argument);
    }

    public Class<CookieValue> getAnnotationType() {
        return CookieValue.class;
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> argument, HttpRequest<?> source) {
        return this.doBind(argument, source.getCookies());
    }

    protected String getParameterName(Argument<T> argument) {
        AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
        return annotationMetadata.stringValue(CookieValue.class).orElse(argument.getName());
    }

    protected String getFallbackFormat(Argument<?> argument) {
        return NameUtils.hyphenate((String)argument.getName());
    }
}

