/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body.stream;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.body.stream.BufferConsumer;

@Internal
public final class LazyUpstream
implements BufferConsumer.Upstream {
    private boolean start;
    private boolean allowDiscard;
    private boolean disregardBackpressure;
    private long consumed;

    @Override
    public void start() {
        this.start = true;
    }

    @Override
    public void onBytesConsumed(long bytesConsumed) {
        long newConsumed = this.consumed + bytesConsumed;
        if (newConsumed < 0L) {
            newConsumed = Long.MAX_VALUE;
        }
        this.consumed = newConsumed;
    }

    @Override
    public void allowDiscard() {
        this.allowDiscard = true;
    }

    @Override
    public void disregardBackpressure() {
        this.disregardBackpressure = true;
    }

    public void forward(BufferConsumer.Upstream actual) {
        if (this.consumed != 0L) {
            actual.onBytesConsumed(this.consumed);
        }
        if (this.start) {
            actual.start();
        }
        if (this.allowDiscard) {
            actual.allowDiscard();
        }
        if (this.disregardBackpressure) {
            actual.disregardBackpressure();
        }
    }
}

