/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.utils;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.NameUtils;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

@Internal
public abstract class PublicMethodVisitor
extends ClassCodeVisitorSupport
implements GroovyObject {
    private final SourceUnit sourceUnit;
    private final Set<String> processed;
    private ClassNode current;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public PublicMethodVisitor(SourceUnit sourceUnit) {
        SourceUnit sourceUnit2;
        MetaClass metaClass;
        HashSet<String> hashSet = new HashSet<String>();
        this.processed = hashSet;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.sourceUnit = sourceUnit2 = sourceUnit;
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void accept(ClassNode classNode) {
        while (classNode != null && ScriptBytecodeAdapter.compareNotEqual((Object)classNode.getName(), (Object)Object.class.getName())) {
            ClassNode classNode2;
            ClassNode classNode3;
            this.current = classNode3 = classNode;
            classNode.visitContents((GroovyClassVisitor)this);
            Object i2 = null;
            for (Object i2 : classNode.getAllInterfaces()) {
                if (!ScriptBytecodeAdapter.compareNotEqual((Object)((ClassNode)i2).getName(), (Object)GroovyObject.class.getName())) continue;
                Object var5_5 = i2;
                this.current = (ClassNode)ScriptBytecodeAdapter.castToType(var5_5, ClassNode.class);
                ((ClassNode)i2).visitContents((GroovyClassVisitor)this);
            }
            classNode = classNode2 = classNode.getSuperClass();
        }
    }

    public void visitMethod(MethodNode node) {
        if (this.isAcceptable(node)) {
            String key = node.getText();
            if (!this.processed.contains(key)) {
                this.processed.add(key);
                ClassNode classNode = this.current;
                this.accept(DefaultTypeTransformation.booleanUnbox((Object)classNode) ? classNode : node.getDeclaringClass(), node);
            }
        }
    }

    public void visitProperty(PropertyNode node) {
        Parameter param = new Parameter(node.getType(), node.getName());
        MethodNode setter = new MethodNode(NameUtils.setterNameFor((String)node.getName()), node.getModifiers(), ClassHelper.makeCached(Void.TYPE), new Parameter[]{param}, null, null);
        setter.addAnnotations(node.getField().getAnnotations());
        setter.setDeclaringClass(node.getDeclaringClass());
        MethodNode getter = new MethodNode(NameUtils.getterNameFor((String)node.getName()), node.getModifiers(), node.getType(), new Parameter[0], null, null);
        getter.addAnnotations(node.getField().getAnnotations());
        getter.setDeclaringClass(node.getDeclaringClass());
        ClassNode classNode = this.current;
        ClassNode classNode2 = DefaultTypeTransformation.booleanUnbox((Object)classNode) ? classNode : node.getDeclaringClass();
        String key = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)classNode2.getName(), (CharSequence)"#"), (CharSequence)node.getName());
        if (!this.processed.contains(key)) {
            this.processed.add(key);
            if (this.isAcceptable(setter)) {
                this.accept(classNode2, setter);
            }
            if (this.isAcceptable(getter)) {
                this.accept(classNode2, getter);
            }
        }
    }

    protected boolean isAcceptable(MethodNode node) {
        return node.isPublic() && !node.isStatic() && !node.isSynthetic() && !node.isFinal();
    }

    public abstract void accept(ClassNode var1, MethodNode var2);

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != PublicMethodVisitor.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @groovy.transform.Internal
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @groovy.transform.Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @groovy.transform.Internal
    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @groovy.transform.Internal
    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @groovy.transform.Internal
    public void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

