/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Script;
import groovy.lang.Singleton;
import groovy.transform.CompilationUnitAware;
import groovy.transform.Generated;
import groovy.transform.PackageScope;
import io.micronaut.aop.Adapter;
import io.micronaut.aop.Around;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.Introduction;
import io.micronaut.aop.writer.AopProxyWriter;
import io.micronaut.ast.groovy.annotation.GroovyAnnotationMetadataBuilder;
import io.micronaut.ast.groovy.config.GroovyConfigurationMetadataBuilder;
import io.micronaut.ast.groovy.utils.AstAnnotationUtils;
import io.micronaut.ast.groovy.utils.AstClassUtils;
import io.micronaut.ast.groovy.utils.AstGenericUtils;
import io.micronaut.ast.groovy.utils.AstMessageUtils;
import io.micronaut.ast.groovy.utils.ExtendedParameter;
import io.micronaut.ast.groovy.utils.InMemoryByteCodeGroovyClassLoader;
import io.micronaut.ast.groovy.utils.PublicAbstractMethodVisitor;
import io.micronaut.ast.groovy.utils.PublicMethodVisitor;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Configuration;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationInject;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.context.annotation.Executable;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.PropertySource;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AnnotationMetadataReference;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.configuration.ConfigurationMetadata;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.configuration.PropertyMetadata;
import io.micronaut.inject.processing.ProcessedTypes;
import io.micronaut.inject.writer.BeanConfigurationWriter;
import io.micronaut.inject.writer.BeanDefinitionReferenceWriter;
import io.micronaut.inject.writer.BeanDefinitionVisitor;
import io.micronaut.inject.writer.BeanDefinitionWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.DirectoryClassWriterOutputVisitor;
import io.micronaut.inject.writer.ExecutableMethodWriter;
import io.micronaut.inject.writer.GeneratedFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Scope;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.StringReaderSource;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class InjectTransform
implements ASTTransformation,
CompilationUnitAware,
GroovyObject {
    public static final String ANN_VALID = "javax.validation.Valid";
    public static final String ANN_CONSTRAINT = "javax.validation.Constraint";
    public static final String ANN_CONFIGURATION_ADVICE = "io.micronaut.runtime.context.env.ConfigurationAdvice";
    public static final String ANN_VALIDATED = "io.micronaut.validation.Validated";
    private CompilationUnit unit;
    private ConfigurationMetadataBuilder<ClassNode> configurationMetadataBuilder;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public InjectTransform() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void visit(ASTNode[] nodes, SourceUnit source) {
        GroovyConfigurationMetadataBuilder groovyConfigurationMetadataBuilder;
        this.configurationMetadataBuilder = groovyConfigurationMetadataBuilder = new GroovyConfigurationMetadataBuilder(source, this.unit);
        ModuleNode moduleNode = source.getAST();
        LinkedHashMap beanDefinitionWriters = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        File classesDir = source.getConfiguration().getTargetDirectory();
        DirectoryClassWriterOutputVisitor outputVisitor = new DirectoryClassWriterOutputVisitor(classesDir);
        List classes = moduleNode.getClasses();
        if (classes.size() == 1) {
            ClassNode classNode = (ClassNode)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)classes, (int)0), ClassNode.class);
            if (ScriptBytecodeAdapter.compareEqual((Object)classNode.getNameWithoutPackage(), (Object)"package-info")) {
                PackageNode packageNode = classNode.getPackage();
                if (AstAnnotationUtils.hasStereotype(source, this.unit, (AnnotatedNode)packageNode, Configuration.class)) {
                    BeanConfigurationWriter writer = new BeanConfigurationWriter(classNode.getPackageName(), AstAnnotationUtils.getAnnotationMetadata(source, this.unit, (AnnotatedNode)packageNode));
                    try {
                        writer.accept((ClassWriterOutputVisitor)outputVisitor);
                        outputVisitor.finish();
                    }
                    catch (Throwable e) {
                        AstMessageUtils.error(source, (ASTNode)classNode, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{classNode.getName(), e.getMessage()}, new String[]{"Error generating bean configuration for package-info class [", "]: ", ""})));
                    }
                }
                return;
            }
        }
        ClassNode classNode = null;
        Iterator iterator = classes.iterator();
        while (iterator.hasNext()) {
            classNode = (ClassNode)ScriptBytecodeAdapter.castToType(iterator.next(), ClassNode.class);
            if (classNode instanceof InnerClassNode && !Modifier.isStatic(classNode.getModifiers())) continue;
            if (classNode.isInterface()) {
                if (!(AstAnnotationUtils.hasStereotype(source, this.unit, (AnnotatedNode)classNode, InjectVisitor.INTRODUCTION_TYPE) || AstAnnotationUtils.hasStereotype(source, this.unit, (AnnotatedNode)classNode, ConfigurationReader.class))) continue;
                InjectVisitor injectVisitor = new InjectVisitor(source, this.unit, classNode, this.configurationMetadataBuilder);
                injectVisitor.visitClass(classNode);
                beanDefinitionWriters.putAll(injectVisitor.getBeanDefinitionWriters());
                continue;
            }
            InjectVisitor injectVisitor = new InjectVisitor(source, this.unit, classNode, this.configurationMetadataBuilder);
            injectVisitor.visitClass(classNode);
            beanDefinitionWriters.putAll(injectVisitor.getBeanDefinitionWriters());
        }
        boolean defineClassesInMemory = source.getClassLoader() instanceof InMemoryByteCodeGroovyClassLoader;
        Reference classStreams = new Reference(null);
        Object entry = null;
        Iterator iterator2 = DefaultGroovyMethods.iterator((Object)beanDefinitionWriters);
        while (iterator2.hasNext()) {
            entry = iterator2.next();
            BeanDefinitionVisitor beanDefWriter = (BeanDefinitionVisitor)ScriptBytecodeAdapter.castToType(((Map.Entry)entry).getValue(), BeanDefinitionVisitor.class);
            String beanTypeName = beanDefWriter.getBeanTypeName();
            AnnotatedNode beanClassNode = (AnnotatedNode)ScriptBytecodeAdapter.castToType(((Map.Entry)entry).getKey(), AnnotatedNode.class);
            try {
                String beanDefinitionName = beanDefWriter.getBeanDefinitionName();
                if (beanClassNode instanceof ClassNode) {
                    ClassNode cn = (ClassNode)ScriptBytecodeAdapter.castToType((Object)beanClassNode, ClassNode.class);
                    ClassNode providerType = AstGenericUtils.resolveInterfaceGenericType(cn, Provider.class);
                    if (providerType != null) {
                        String string;
                        beanTypeName = string = providerType.getName();
                    }
                }
                BeanDefinitionReferenceWriter beanReferenceWriter = new BeanDefinitionReferenceWriter(beanTypeName, beanDefinitionName, beanDefWriter.getAnnotationMetadata());
                beanReferenceWriter.setRequiresMethodProcessing(beanDefWriter.requiresMethodProcessing());
                beanReferenceWriter.setContextScope(AstAnnotationUtils.hasStereotype(source, this.unit, beanClassNode, Context.class));
                beanDefWriter.visitBeanDefinitionEnd();
                if (classesDir != null) {
                    beanReferenceWriter.accept((ClassWriterOutputVisitor)outputVisitor);
                    beanDefWriter.accept((ClassWriterOutputVisitor)outputVisitor);
                    continue;
                }
                if (!(source.getSource() instanceof StringReaderSource && defineClassesInMemory)) continue;
                if ((Map)classStreams.get() == null) {
                    Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                    classStreams.set((Object)map);
                }
                ClassWriterOutputVisitor visitor = new ClassWriterOutputVisitor(this, classStreams){
                    public /* synthetic */ Reference classStreams;
                    public /* synthetic */ InjectTransform this$0;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private transient /* synthetic */ MetaClass metaClass;
                    {
                        MetaClass metaClass;
                        Reference reference;
                        InjectTransform injectTransform;
                        this.this$0 = injectTransform = p0;
                        this.classStreams = reference = p1;
                        this.metaClass = metaClass = this.$getStaticMetaClass();
                    }

                    public OutputStream visitClass(String classname) throws IOException {
                        ByteArrayOutputStream stream = new ByteArrayOutputStream();
                        ((Map)this.classStreams.get()).put(classname, stream);
                        return stream;
                    }

                    public void visitServiceDescriptor(String type, String classname) {
                    }

                    public Optional<File> visitMetaInfFile(String path) throws IOException {
                        return Optional.empty();
                    }

                    public Optional<GeneratedFile> visitGeneratedFile(String path) {
                        return Optional.empty();
                    }

                    public void finish() {
                    }

                    public /* synthetic */ Object methodMissing(String name, Object args) {
                        return this.this$0.this$dist$invoke$1(name, args);
                    }

                    public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                        return ScriptBytecodeAdapter.invokeMethodN(1.class, InjectTransform.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                    }

                    public /* synthetic */ void propertyMissing(String name, Object val) {
                        this.this$0.this$dist$set$1(name, val);
                    }

                    public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                        Object object = val;
                        ScriptBytecodeAdapter.setProperty((Object)object, null, InjectTransform.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                    }

                    public /* synthetic */ Object propertyMissing(String name) {
                        return this.this$0.this$dist$get$1(name);
                    }

                    public static /* synthetic */ Object $static_propertyMissing(String name) {
                        return ScriptBytecodeAdapter.getProperty(1.class, InjectTransform.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != 1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    @Generated
                    @groovy.transform.Internal
                    public /* synthetic */ MetaClass getMetaClass() {
                        MetaClass metaClass = this.metaClass;
                        if (metaClass != null) {
                            return metaClass;
                        }
                        this.metaClass = this.$getStaticMetaClass();
                        return this.metaClass;
                    }

                    @Generated
                    @groovy.transform.Internal
                    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                        this.metaClass = metaClass;
                    }

                    @Generated
                    @groovy.transform.Internal
                    public /* synthetic */ Object invokeMethod(String string, Object object) {
                        return this.getMetaClass().invokeMethod((Object)this, string, object);
                    }

                    @Generated
                    @groovy.transform.Internal
                    public /* synthetic */ Object getProperty(String string) {
                        return this.getMetaClass().getProperty((Object)this, string);
                    }

                    @Generated
                    @groovy.transform.Internal
                    public /* synthetic */ void setProperty(String string, Object object) {
                        this.getMetaClass().setProperty((Object)this, string, object);
                    }
                };
                beanReferenceWriter.accept(visitor);
                beanDefWriter.accept(visitor);
            }
            catch (Throwable e) {
                AstMessageUtils.error(source, (ASTNode)beanClassNode, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{beanTypeName, e.getMessage()}, new String[]{"Error generating bean definition class for dependency injection of class [", "]: ", ""})));
                e.printStackTrace(System.err);
            }
        }
        if (!beanDefinitionWriters.isEmpty()) {
            try {
                outputVisitor.finish();
            }
            catch (Throwable e) {
                AstMessageUtils.error(source, (ASTNode)moduleNode, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Error generating META-INF/services files: ", ""})));
                if (e.getMessage() == null) {
                    e.printStackTrace(System.err);
                }
            }
        }
        if ((Map)classStreams.get() != null) {
            InMemoryByteCodeGroovyClassLoader classLoader = (InMemoryByteCodeGroovyClassLoader)((Object)ScriptBytecodeAdapter.castToType((Object)source.getClassLoader(), InMemoryByteCodeGroovyClassLoader.class));
            if (defineClassesInMemory && classLoader != null) {
                Object streamEntry = null;
                Iterator iterator3 = DefaultGroovyMethods.iterator((Object)((Map)classStreams.get()));
                while (iterator3.hasNext()) {
                    streamEntry = iterator3.next();
                    classLoader.addClass(ShortTypeHandling.castToString(((Map.Entry)streamEntry).getKey()), ((ByteArrayOutputStream)((Map.Entry)streamEntry).getValue()).toByteArray());
                }
            }
        }
        AstAnnotationUtils.invalidateCache();
    }

    public void setCompilationUnit(CompilationUnit unit) {
        CompilationUnit compilationUnit;
        this.unit = compilationUnit = unit;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != InjectTransform.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(InjectTransform.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, InjectTransform.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(InjectTransform.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @groovy.transform.Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @groovy.transform.Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @groovy.transform.Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @groovy.transform.Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @groovy.transform.Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public CompilationUnit getUnit() {
        return this.unit;
    }

    @Generated
    public void setUnit(CompilationUnit compilationUnit) {
        this.unit = compilationUnit;
    }

    @Generated
    public ConfigurationMetadataBuilder<ClassNode> getConfigurationMetadataBuilder() {
        return this.configurationMetadataBuilder;
    }

    @Generated
    public void setConfigurationMetadataBuilder(ConfigurationMetadataBuilder<ClassNode> configurationMetadataBuilder) {
        this.configurationMetadataBuilder = configurationMetadataBuilder;
    }

    static class InjectVisitor
    extends ClassCodeVisitorSupport
    implements GroovyObject {
        public static final String AROUND_TYPE = "io.micronaut.aop.Around";
        public static final String INTRODUCTION_TYPE = "io.micronaut.aop.Introduction";
        private final SourceUnit sourceUnit;
        private final ClassNode concreteClass;
        private final AnnotationMetadata annotationMetadata;
        private final boolean isConfigurationProperties;
        private final boolean isFactoryClass;
        private final boolean isExecutableType;
        private final boolean isAopProxyType;
        private final boolean isDeclaredBean;
        private final OptionalValues<Boolean> aopSettings;
        private final ConfigurationMetadataBuilder<ClassNode> configurationMetadataBuilder;
        private ConfigurationMetadata configurationMetadata;
        private final Map<AnnotatedNode, BeanDefinitionVisitor> beanDefinitionWriters;
        private BeanDefinitionVisitor beanWriter;
        private BeanDefinitionVisitor aopProxyWriter;
        private final AtomicInteger adaptedMethodIndex;
        private final AtomicInteger factoryMethodIndex;
        private final CompilationUnit compilationUnit;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public InjectVisitor(SourceUnit sourceUnit, CompilationUnit compilationUnit, ClassNode targetClassNode, ConfigurationMetadataBuilder<ClassNode> configurationMetadataBuilder) {
            this(sourceUnit, compilationUnit, targetClassNode, null, configurationMetadataBuilder);
        }

        /*
         * WARNING - void declaration
         */
        public InjectVisitor(SourceUnit sourceUnit, CompilationUnit compilationUnit, ClassNode targetClassNode, Boolean configurationProperties, ConfigurationMetadataBuilder<ClassNode> configurationMetadataBuilder) {
            boolean bl;
            boolean bl2;
            OptionalValues optionalValues;
            boolean bl3;
            boolean bl4;
            AnnotationMetadata annotationMetadata;
            ClassNode classNode;
            SourceUnit sourceUnit2;
            CompilationUnit compilationUnit2;
            MetaClass metaClass;
            AtomicInteger atomicInteger;
            AtomicInteger atomicInteger2;
            Map map;
            void var2_2;
            Reference sourceUnit3 = new Reference((Object)sourceUnit);
            Reference compilationUnit3 = new Reference((Object)var2_2);
            this.beanDefinitionWriters = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.adaptedMethodIndex = atomicInteger2 = new AtomicInteger(0);
            this.factoryMethodIndex = atomicInteger = new AtomicInteger(0);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.compilationUnit = compilationUnit2 = (CompilationUnit)compilationUnit3.get();
            this.sourceUnit = sourceUnit2 = (SourceUnit)sourceUnit3.get();
            ConfigurationMetadataBuilder<ClassNode> configurationMetadataBuilder2 = configurationMetadataBuilder;
            this.configurationMetadataBuilder = configurationMetadataBuilder2;
            this.concreteClass = classNode = targetClassNode;
            AnnotationMetadata annotationMetadata2 = AstAnnotationUtils.getAnnotationMetadata((SourceUnit)sourceUnit3.get(), (CompilationUnit)compilationUnit3.get(), (AnnotatedNode)targetClassNode);
            this.annotationMetadata = annotationMetadata = annotationMetadata2;
            this.isFactoryClass = bl4 = annotationMetadata2.hasStereotype(Factory.class);
            this.isAopProxyType = bl3 = annotationMetadata2.hasStereotype(AROUND_TYPE) && !targetClassNode.isAbstract();
            this.aopSettings = optionalValues = this.isAopProxyType ? annotationMetadata2.getValues(AROUND_TYPE, Boolean.class) : OptionalValues.empty();
            this.isExecutableType = bl2 = this.isAopProxyType || annotationMetadata2.hasStereotype(Executable.class);
            Boolean bl5 = configurationProperties != null ? configurationProperties : Boolean.valueOf(annotationMetadata2.hasDeclaredStereotype(ConfigurationReader.class));
            this.isConfigurationProperties = DefaultTypeTransformation.booleanUnbox((Object)bl5);
            if (this.isConfigurationProperties) {
                ConfigurationMetadata configurationMetadata;
                this.configurationMetadata = configurationMetadata = configurationMetadataBuilder.visitProperties((Object)this.concreteClass, null);
            }
            if (this.isAopProxyType && Modifier.isFinal(targetClassNode.getModifiers())) {
                this.addError(StringGroovyMethods.plus((String)"Cannot apply AOP advice to final class. Class must be made non-final to support proxying: ", (CharSequence)targetClassNode.getName()), (ASTNode)targetClassNode);
            } else if (this.isFactoryClass || this.isConfigurationProperties || annotationMetadata2.hasStereotype(new Class[]{Bean.class, Scope.class})) {
                this.defineBeanDefinition(this.concreteClass);
            }
            this.isDeclaredBean = bl = this.isExecutableType || this.isConfigurationProperties || this.isFactoryClass || annotationMetadata2.hasStereotype(Scope.class) || annotationMetadata2.hasStereotype(DefaultScope.class) || DefaultGroovyMethods.any((Iterable)this.concreteClass.getDeclaredConstructors(), (Closure)new _closure1((Object)this, (Object)this, sourceUnit3, compilationUnit3));
        }

        public BeanDefinitionVisitor getBeanWriter() {
            if (this.beanWriter == null) {
                this.defineBeanDefinition(this.concreteClass);
            }
            return this.beanWriter;
        }

        public void addError(String msg, ASTNode expr) {
            SourceUnit source = this.getSourceUnit();
            source.getErrorCollector().addError((Message)new SyntaxErrorMessage(new SyntaxException(StringGroovyMethods.plus((String)msg, (CharSequence)"\n"), expr.getLineNumber(), expr.getColumnNumber(), expr.getLastLineNumber(), expr.getLastColumnNumber()), source));
        }

        public void visitClass(ClassNode node) {
            AnnotationMetadata annotationMetadata = AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)node);
            boolean isInterface = node.isInterface();
            if (this.isConfigurationProperties && isInterface) {
                AnnotationMetadata annotationMetadata2;
                annotationMetadata = annotationMetadata2 = this.addAnnotation(annotationMetadata, ANN_CONFIGURATION_ADVICE);
            }
            if (annotationMetadata.hasStereotype(INTRODUCTION_TYPE)) {
                String packageName = node.getPackageName();
                String beanClassName = node.getNameWithoutPackage();
                Object[] aroundInterceptors = annotationMetadata.getAnnotationNamesByStereotype(AROUND_TYPE).toArray();
                Object[] introductionInterceptors = annotationMetadata.getAnnotationNamesByStereotype(Introduction.class).toArray();
                Object[] interceptorTypes = ArrayUtils.concat((Object[])aroundInterceptors, (Object[])introductionInterceptors);
                String[] interfaceTypes = (String[])ScriptBytecodeAdapter.castToType((Object)annotationMetadata.getValue(Introduction.class, "interfaces", String[].class).orElse(new String[0]), String[].class);
                AopProxyWriter aopProxyWriter = new AopProxyWriter(packageName, beanClassName, isInterface, annotationMetadata, (Object[])ScriptBytecodeAdapter.castToType((Object)interfaceTypes, Object[].class), interceptorTypes);
                this.populateProxyWriterConstructor(node, aopProxyWriter);
                this.beanDefinitionWriters.put((AnnotatedNode)node, (BeanDefinitionVisitor)aopProxyWriter);
                this.visitIntroductionTypePublicMethods(aopProxyWriter, node);
                if (ArrayUtils.isNotEmpty((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)interfaceTypes, Object[].class)))) {
                    List annotationNodes = node.getAnnotations();
                    Set interfacesToVisit = (Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
                    this.populateIntroducedInterfaces(annotationNodes, interfacesToVisit);
                    if (!interfacesToVisit.isEmpty()) {
                        Object itce2 = null;
                        for (Object itce2 : interfacesToVisit) {
                            this.visitIntroductionTypePublicMethods(aopProxyWriter, (ClassNode)ScriptBytecodeAdapter.castToType(itce2, ClassNode.class));
                        }
                    }
                }
                if (!isInterface) {
                    node.visitContents((GroovyClassVisitor)this);
                }
            } else {
                List list;
                boolean isOwningClass = ScriptBytecodeAdapter.compareEqual((Object)node, (Object)this.concreteClass);
                if (isOwningClass && this.concreteClass.isAbstract() && !this.isDeclaredBean) {
                    return;
                }
                ClassNode superClass = node.getSuperClass();
                List superClasses = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                while (superClass != null) {
                    ClassNode classNode;
                    superClasses.add(superClass);
                    superClass = classNode = superClass.getSuperClass();
                }
                superClasses = list = DefaultGroovyMethods.reverse((List)superClasses);
                Object classNode2 = null;
                for (Object classNode2 : superClasses) {
                    if (!(ScriptBytecodeAdapter.compareNotEqual((Object)((ClassNode)classNode2).getName(), (Object)ClassHelper.OBJECT_TYPE.getName()) && ScriptBytecodeAdapter.compareNotEqual((Object)((ClassNode)classNode2).getName(), (Object)GroovyObjectSupport.class.getName()) && ScriptBytecodeAdapter.compareNotEqual((Object)((ClassNode)classNode2).getName(), (Object)Script.class.getName()))) continue;
                    ((ClassNode)classNode2).visitContents((GroovyClassVisitor)this);
                }
                super.visitClass(node);
            }
        }

        private void populateIntroducedInterfaces(List<AnnotationNode> annotationNodes, Set<ClassNode> interfacesToVisit) {
            AnnotationNode ann2 = null;
            for (AnnotationNode ann2 : annotationNodes) {
                if (ScriptBytecodeAdapter.compareEqual((Object)ann2.getClassNode().getName(), (Object)Introduction.class.getName())) {
                    Expression expression = ann2.getMember("interfaces");
                    if (expression instanceof ClassExpression) {
                        interfacesToVisit.add(((ClassExpression)ScriptBytecodeAdapter.castToType((Object)expression, ClassExpression.class)).getType());
                        continue;
                    }
                    if (!(expression instanceof ListExpression)) continue;
                    ListExpression list = (ListExpression)ScriptBytecodeAdapter.castToType((Object)expression, ListExpression.class);
                    Object expr2 = null;
                    for (Object expr2 : list.getExpressions()) {
                        if (!(expr2 instanceof ClassExpression)) continue;
                        interfacesToVisit.add(((ClassExpression)ScriptBytecodeAdapter.castToType(expr2, ClassExpression.class)).getType());
                    }
                    continue;
                }
                if (!AstAnnotationUtils.hasStereotype(this.sourceUnit, this.compilationUnit, (AnnotatedNode)ann2.getClassNode(), Introduction.class)) continue;
                this.populateIntroducedInterfaces(ann2.getClassNode().getAnnotations(), interfacesToVisit);
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void visitIntroductionTypePublicMethods(AopProxyWriter aopProxyWriter, ClassNode node) {
            void var2_2;
            Reference aopProxyWriter2 = new Reference((Object)aopProxyWriter);
            Reference node2 = new Reference((Object)var2_2);
            Reference typeAnnotationMetadata = new Reference((Object)((AopProxyWriter)aopProxyWriter2.get()).getAnnotationMetadata());
            Reference source = new Reference((Object)this.sourceUnit);
            Reference unit = new Reference((Object)this.compilationUnit);
            PublicAbstractMethodVisitor publicMethodVisitor = new PublicAbstractMethodVisitor(this, source, unit, node2, aopProxyWriter2, typeAnnotationMetadata, (SourceUnit)source.get(), (CompilationUnit)unit.get()){
                public /* synthetic */ Reference typeAnnotationMetadata;
                public /* synthetic */ Reference aopProxyWriter;
                public /* synthetic */ Reference node;
                public /* synthetic */ Reference unit;
                public /* synthetic */ Reference source;
                public /* synthetic */ InjectVisitor this$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    InjectVisitor injectVisitor;
                    this.this$0 = injectVisitor = p0;
                    super((SourceUnit)ScriptBytecodeAdapter.castToType((Object)p7, SourceUnit.class), (CompilationUnit)ScriptBytecodeAdapter.castToType((Object)p8, CompilationUnit.class));
                    this.typeAnnotationMetadata = reference5 = p5;
                    this.aopProxyWriter = reference4 = p4;
                    this.node = reference3 = p3;
                    this.unit = reference2 = p2;
                    this.source = reference = p1;
                }

                @Override
                protected boolean isAcceptableMethod(MethodNode methodNode) {
                    return super.isAcceptableMethod(methodNode) || AstAnnotationUtils.getAnnotationMetadata((SourceUnit)ScriptBytecodeAdapter.castToType((Object)this.source.get(), SourceUnit.class), (CompilationUnit)ScriptBytecodeAdapter.castToType((Object)this.unit.get(), CompilationUnit.class), (AnnotatedNode)methodNode).hasDeclaredStereotype(AROUND_TYPE);
                }

                @Override
                public void accept(ClassNode classNode, MethodNode methodNode) {
                    LinkedHashMap targetMethodParamsToType = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                    LinkedHashMap targetGenericParams = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                    LinkedHashMap targetAnnotationMetadata = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                    LinkedHashMap targetMethodGenericTypeMap = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                    Map<String, ClassNode> boundTypes = AstGenericUtils.createGenericsSpec(classNode);
                    if (!classNode.isPrimaryClassNode()) {
                        AstGenericUtils.createGenericsSpec(methodNode, boundTypes);
                    }
                    Object resolvedReturnType = AstGenericUtils.resolveTypeReference(methodNode.getReturnType(), boundTypes);
                    Map<String, Object> resolvedGenericTypes = AstGenericUtils.buildGenericTypeInfo(methodNode.getReturnType(), boundTypes);
                    this.this$0.populateParameterData(methodNode, targetMethodParamsToType, targetGenericParams, targetAnnotationMetadata, targetMethodGenericTypeMap, boundTypes, false);
                    AnnotationMetadataReference annotationMetadata = null;
                    if (AstAnnotationUtils.isAnnotated(((ClassNode)this.node.get()).getName(), (AnnotatedNode)methodNode) || AstAnnotationUtils.hasAnnotation(methodNode, Override.class)) {
                        AnnotationMetadata annotationMetadata2 = AstAnnotationUtils.newBuilder((SourceUnit)ScriptBytecodeAdapter.castToType((Object)this.source.get(), SourceUnit.class), (CompilationUnit)ScriptBytecodeAdapter.castToType((Object)this.unit.get(), CompilationUnit.class)).buildForParent(((ClassNode)this.node.get()).getName(), this.node.get(), methodNode);
                        annotationMetadata = annotationMetadata2;
                    } else {
                        AnnotationMetadataReference annotationMetadataReference;
                        annotationMetadata = annotationMetadataReference = new AnnotationMetadataReference(StringGroovyMethods.plus((String)((AopProxyWriter)this.aopProxyWriter.get()).getBeanDefinitionName(), (CharSequence)BeanDefinitionReferenceWriter.REF_SUFFIX), (AnnotationMetadata)ScriptBytecodeAdapter.castToType((Object)this.typeAnnotationMetadata.get(), AnnotationMetadata.class));
                    }
                    if (!annotationMetadata.hasStereotype(InjectTransform.ANN_VALIDATED) && this.this$0.getIsDeclaredBean()) {
                        int hasConstraint = 0;
                        Parameter p2 = null;
                        Parameter[] parameterArray = methodNode.getParameters();
                        if (parameterArray != null) {
                            for (Parameter p2 : parameterArray) {
                                int n;
                                AnnotationMetadata parameterMetadata = AstAnnotationUtils.getAnnotationMetadata((SourceUnit)ScriptBytecodeAdapter.castToType((Object)this.source.get(), SourceUnit.class), (CompilationUnit)ScriptBytecodeAdapter.castToType((Object)this.unit.get(), CompilationUnit.class), (AnnotatedNode)p2);
                                if (!(parameterMetadata.hasStereotype(ANN_CONSTRAINT) || parameterMetadata.hasStereotype(ANN_VALID))) continue;
                                hasConstraint = n = 1;
                                break;
                            }
                        }
                        if (hasConstraint != 0) {
                            AnnotationMetadata annotationMetadata3 = this.this$0.addValidated((AnnotationMetadata)annotationMetadata);
                            annotationMetadata = annotationMetadata3;
                        }
                    }
                    if (this.this$0.getIsConfigurationProperties() && methodNode.isAbstract()) {
                        if (!((AopProxyWriter)this.aopProxyWriter.get()).isValidated()) {
                            ((AopProxyWriter)this.aopProxyWriter.get()).setValidated(annotationMetadata.hasStereotype(ANN_CONSTRAINT) || annotationMetadata.hasStereotype(ANN_VALID));
                        }
                        if (!NameUtils.isGetterName((String)methodNode.getName())) {
                            this.error(StringGroovyMethods.plus((String)"Only getter methods are allowed on @ConfigurationProperties interfaces: ", (CharSequence)methodNode.getName()), classNode);
                            return;
                        }
                        if (DefaultTypeTransformation.booleanUnbox((Object)targetMethodParamsToType)) {
                            this.error(StringGroovyMethods.plus((String)"Only zero argument getter methods are allowed on @ConfigurationProperties interfaces: ", (CharSequence)methodNode.getName()), classNode);
                            return;
                        }
                        String propertyName = NameUtils.getPropertyNameForGetter((String)methodNode.getName());
                        String propertyType = methodNode.getReturnType().getName();
                        if ("void".equals(propertyType)) {
                            this.error(StringGroovyMethods.plus((String)"Getter methods must return a value @ConfigurationProperties interfaces: ", (CharSequence)methodNode.getName()), classNode);
                            return;
                        }
                        PropertyMetadata propertyMetadata = this.this$0.getConfigurationMetadataBuilder().visitProperty((Object)(this.getCurrent().isInterface() ? this.getCurrent() : classNode), (Object)classNode, propertyType, propertyName, null, ShortTypeHandling.castToString(annotationMetadata.stringValue(Bindable.class, "defaultValue").orElse(null)));
                        AnnotationMetadata annotationMetadata4 = this.this$0.addPropertyMetadata((AnnotationMetadata)annotationMetadata, propertyMetadata);
                        annotationMetadata = annotationMetadata4;
                        ClassNode typeElement = (ClassNode)ScriptBytecodeAdapter.castToType((Object)(!ClassUtils.isJavaBasicType((String)propertyType) ? methodNode.getReturnType() : null), ClassNode.class);
                        if (typeElement != null && AstAnnotationUtils.hasStereotype((SourceUnit)ScriptBytecodeAdapter.castToType((Object)this.source.get(), SourceUnit.class), (CompilationUnit)ScriptBytecodeAdapter.castToType((Object)this.unit.get(), CompilationUnit.class), (AnnotatedNode)typeElement, Scope.class)) {
                            AnnotationMetadata annotationMetadata5 = this.addBeanConfigAdvise((AnnotationMetadata)annotationMetadata);
                            annotationMetadata = annotationMetadata5;
                        } else {
                            AnnotationMetadata annotationMetadata6 = this.this$0.addAnnotation((AnnotationMetadata)annotationMetadata, ShortTypeHandling.castToString((Object)this.getProperty("ANN_CONFIGURATION_ADVICE")));
                            annotationMetadata = annotationMetadata6;
                        }
                    }
                    if (AstAnnotationUtils.hasStereotype((SourceUnit)ScriptBytecodeAdapter.castToType((Object)this.source.get(), SourceUnit.class), (CompilationUnit)ScriptBytecodeAdapter.castToType((Object)this.unit.get(), CompilationUnit.class), (AnnotatedNode)methodNode, AROUND_TYPE)) {
                        Object[] interceptorTypeReferences = annotationMetadata.getAnnotationNamesByStereotype(Around.class).toArray();
                        ((AopProxyWriter)this.aopProxyWriter.get()).visitInterceptorTypes(interceptorTypeReferences);
                    }
                    if (methodNode.isAbstract()) {
                        ((AopProxyWriter)this.aopProxyWriter.get()).visitIntroductionMethod(AstGenericUtils.resolveTypeReference(methodNode.getDeclaringClass()), this.this$0.resolveReturnType(classNode, methodNode, boundTypes), resolvedReturnType, resolvedGenericTypes, methodNode.getName(), (Map)targetMethodParamsToType, (Map)targetGenericParams, (Map)targetAnnotationMetadata, (Map)targetMethodGenericTypeMap, (AnnotationMetadata)annotationMetadata);
                    } else {
                        ((AopProxyWriter)this.aopProxyWriter.get()).visitAroundMethod(AstGenericUtils.resolveTypeReference(methodNode.getDeclaringClass()), this.this$0.resolveReturnType(classNode, methodNode, boundTypes), resolvedReturnType, resolvedGenericTypes, methodNode.getName(), (Map)targetMethodParamsToType, (Map)targetGenericParams, (Map)targetAnnotationMetadata, (Map)targetMethodGenericTypeMap, (AnnotationMetadata)annotationMetadata, methodNode.getDeclaringClass().isInterface(), false);
                    }
                }

                private void error(String msg, ClassNode classNode) {
                    CallSite[] callSiteArray = 2.$getCallSiteArray();
                    callSiteArray[0].callCurrent((GroovyObject)this, (Object)msg, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((ASTNode)classNode), ASTNode.class));
                }

                private AnnotationMetadata addBeanConfigAdvise(AnnotationMetadata annotationMetadata) {
                    CallSite[] callSiteArray = 2.$getCallSiteArray();
                    return (AnnotationMetadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(callSiteArray[2].callConstructor(GroovyAnnotationMetadataBuilder.class, this.source.get(), callSiteArray[3].callGroovyObjectGetProperty((Object)this)), (Object)annotationMetadata, callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(AnnotationValue.class, callSiteArray[7].callGroovyObjectGetProperty((Object)this)), (Object)"bean", (Object)true))), AnnotationMetadata.class);
                }

                public /* synthetic */ Object methodMissing(String name, Object args) {
                    return this.this$0.this$dist$invoke$3(name, args);
                }

                public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                    return ScriptBytecodeAdapter.invokeMethodN(2.class, InjectVisitor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public /* synthetic */ void propertyMissing(String name, Object val) {
                    this.this$0.this$dist$set$3(name, val);
                }

                public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                    Object object = val;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, InjectVisitor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object propertyMissing(String name) {
                    return this.this$0.this$dist$get$3(name);
                }

                public static /* synthetic */ Object $static_propertyMissing(String name) {
                    return ScriptBytecodeAdapter.getProperty(2.class, InjectVisitor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                @Override
                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != 2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ boolean super$5$isAcceptableMethod(MethodNode methodNode) {
                    return super.isAcceptableMethod(methodNode);
                }

                public /* synthetic */ MetaClass super$5$$getStaticMetaClass() {
                    return super.$getStaticMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "addError";
                    stringArray[1] = "annotate";
                    stringArray[2] = "<$constructor$>";
                    stringArray[3] = "compilationUnit";
                    stringArray[4] = "build";
                    stringArray[5] = "member";
                    stringArray[6] = "builder";
                    stringArray[7] = "ANN_CONFIGURATION_ADVICE";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[8];
                    2.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = 2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            };
            publicMethodVisitor.accept((ClassNode)node2.get());
        }

        private Object resolveReturnType(ClassNode classNode, MethodNode methodNode, Map<String, ClassNode> boundTypes) {
            boolean isPrimaryClassNode = classNode.isPrimaryClassNode();
            ClassNode returnType = methodNode.getReturnType();
            if (isPrimaryClassNode || DefaultTypeTransformation.booleanUnbox((Object)classNode.getGenericsTypes())) {
                if (!isPrimaryClassNode && returnType.isArray()) {
                    Map<String, ClassNode> genericSpec = AstGenericUtils.createGenericsSpec(classNode.redirect());
                    return AstGenericUtils.resolveTypeReference(returnType, genericSpec);
                }
                return AstGenericUtils.resolveTypeReference(returnType);
            }
            return AstGenericUtils.resolveTypeReference(returnType, boundTypes);
        }

        protected void visitConstructorOrMethod(MethodNode methodNode, boolean isConstructor) {
            Reference methodNode2 = new Reference((Object)methodNode);
            if (((MethodNode)methodNode2.get()).isSynthetic() || ((MethodNode)methodNode2.get()).getName().contains("$")) {
                return;
            }
            String methodName = ((MethodNode)methodNode2.get()).getName();
            ClassNode declaringClass = ((MethodNode)methodNode2.get()).getDeclaringClass();
            Reference methodAnnotationMetadata = new Reference((Object)AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)((MethodNode)methodNode2.get())));
            if (this.isFactoryClass && !isConstructor && ((AnnotationMetadata)methodAnnotationMetadata.get()).hasDeclaredStereotype(new Class[]{Bean.class, Scope.class})) {
                AnnotationMetadata annotationMetadata = new GroovyAnnotationMetadataBuilder(this.sourceUnit, this.compilationUnit).buildForParent(((MethodNode)methodNode2.get()).getReturnType(), (MethodNode)methodNode2.get(), true);
                methodAnnotationMetadata.set((Object)annotationMetadata);
                if (this.annotationMetadata.hasDeclaredStereotype(Around.class)) {
                    this.visitExecutableMethod(declaringClass, (MethodNode)methodNode2.get(), (AnnotationMetadata)methodAnnotationMetadata.get(), methodName, ((MethodNode)methodNode2.get()).isPublic());
                }
                Reference producedType = new Reference((Object)((MethodNode)methodNode2.get()).getReturnType());
                String beanDefinitionPackage = this.concreteClass.getPackageName();
                String upperCaseMethodName = NameUtils.capitalize((String)((MethodNode)methodNode2.get()).getName());
                String factoryMethodBeanDefinitionName = StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)beanDefinitionPackage, (CharSequence)".$"), (CharSequence)this.concreteClass.getNameWithoutPackage()), (CharSequence)"$"), (CharSequence)upperCaseMethodName), (Object)this.factoryMethodIndex.getAndIncrement()), (CharSequence)"Definition");
                Reference beanMethodWriter = new Reference((Object)new BeanDefinitionWriter(((ClassNode)producedType.get()).getPackageName(), ((ClassNode)producedType.get()).getNameWithoutPackage(), factoryMethodBeanDefinitionName, ((ClassNode)producedType.get()).getName(), ((ClassNode)producedType.get()).isInterface(), (AnnotationMetadata)methodAnnotationMetadata.get()));
                ClassNode returnType = ((MethodNode)methodNode2.get()).getReturnType();
                Map<String, ClassNode> genericsSpec = AstGenericUtils.createGenericsSpec(returnType);
                if (DefaultTypeTransformation.booleanUnbox(genericsSpec)) {
                    LinkedHashMap boundTypes = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                    GenericsType[] genericsTypes = returnType.redirect().getGenericsTypes();
                    LinkedHashMap typeArguments = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                    Object gt = null;
                    Iterator iterator = DefaultGroovyMethods.iterator((Object)genericsTypes);
                    while (iterator.hasNext()) {
                        gt = iterator.next();
                        ClassNode cn = (ClassNode)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(genericsSpec, (Object)((GenericsType)gt).getName()), ClassNode.class);
                        boundTypes.put(((GenericsType)gt).getName(), AstGenericUtils.resolveTypeReference(cn));
                    }
                    typeArguments.put(DefaultGroovyMethods.toString((Object)AstGenericUtils.resolveTypeReference(returnType)), boundTypes);
                    AstGenericUtils.populateTypeArguments(returnType, typeArguments);
                    ((BeanDefinitionWriter)beanMethodWriter.get()).visitTypeArguments((Map)typeArguments);
                }
                LinkedHashMap paramsToType = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                LinkedHashMap paramsGenerics = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                LinkedHashMap argumentAnnotationMetadata = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                LinkedHashMap genericTypeMap = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                this.populateParameterData((MethodNode)methodNode2.get(), paramsToType, paramsGenerics, argumentAnnotationMetadata, genericTypeMap, genericsSpec, false);
                ((BeanDefinitionWriter)beanMethodWriter.get()).visitBeanFactoryMethod(AstGenericUtils.resolveTypeReference(this.concreteClass), AstGenericUtils.resolveTypeReference((ClassNode)producedType.get()), methodName, (AnnotationMetadata)methodAnnotationMetadata.get(), (Map)paramsToType, (Map)argumentAnnotationMetadata, (Map)genericTypeMap);
                if (((AnnotationMetadata)methodAnnotationMetadata.get()).hasStereotype(AROUND_TYPE)) {
                    if (Modifier.isFinal(returnType.getModifiers())) {
                        this.addError(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{(MethodNode)methodNode2.get()}, new String[]{"Cannot apply AOP advice to final class. Class must be made non-final to support proxying: ", ""})), (ASTNode)((MethodNode)methodNode2.get()));
                        return;
                    }
                    Object[] interceptorTypeReferences = ((AnnotationMetadata)methodAnnotationMetadata.get()).getAnnotationNamesByStereotype(Around.class).toArray();
                    OptionalValues aopSettings = ((AnnotationMetadata)methodAnnotationMetadata.get()).getValues(AROUND_TYPE, Boolean.class);
                    LinkedHashMap finalSettings = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                    Object key = null;
                    Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethod0(InjectVisitor.class, (Object)aopSettings, (String)"iterator"), Iterator.class);
                    while (iterator.hasNext()) {
                        key = iterator.next();
                        finalSettings.put(key, aopSettings.get((CharSequence)ScriptBytecodeAdapter.castToType(key, CharSequence.class)).get());
                    }
                    finalSettings.put(Interceptor.PROXY_TARGET, true);
                    Reference proxyWriter = new Reference((Object)new AopProxyWriter((BeanDefinitionWriter)beanMethodWriter.get(), OptionalValues.of(Boolean.class, (Map)finalSettings), interceptorTypeReferences));
                    if (((ClassNode)producedType.get()).isInterface()) {
                        ((AopProxyWriter)proxyWriter.get()).visitBeanDefinitionConstructor(AnnotationMetadata.EMPTY_METADATA, false);
                    } else {
                        this.populateProxyWriterConstructor((ClassNode)producedType.get(), (AopProxyWriter)proxyWriter.get());
                    }
                    Reference source = new Reference((Object)this.sourceUnit);
                    Reference unit = new Reference((Object)this.compilationUnit);
                    new PublicMethodVisitor(this, source, unit, methodNode2, producedType, beanMethodWriter, methodAnnotationMetadata, proxyWriter, (SourceUnit)source.get()){
                        public /* synthetic */ Reference proxyWriter;
                        public /* synthetic */ Reference methodAnnotationMetadata;
                        public /* synthetic */ Reference beanMethodWriter;
                        public /* synthetic */ Reference producedType;
                        public /* synthetic */ Reference methodNode;
                        public /* synthetic */ Reference unit;
                        public /* synthetic */ Reference source;
                        public /* synthetic */ InjectVisitor this$0;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        {
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            Reference reference4;
                            Reference reference5;
                            Reference reference6;
                            Reference reference7;
                            InjectVisitor injectVisitor;
                            this.this$0 = injectVisitor = p0;
                            super((SourceUnit)ScriptBytecodeAdapter.castToType((Object)p9, SourceUnit.class));
                            this.proxyWriter = reference7 = p7;
                            this.methodAnnotationMetadata = reference6 = p6;
                            this.beanMethodWriter = reference5 = p5;
                            this.producedType = reference4 = p4;
                            this.methodNode = reference3 = p3;
                            this.unit = reference2 = p2;
                            this.source = reference = p1;
                        }

                        @Override
                        public void accept(ClassNode classNode, MethodNode targetBeanMethodNode) {
                            LinkedHashMap targetMethodParamsToType = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                            LinkedHashMap targetGenericParams = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                            LinkedHashMap targetAnnotationMetadata = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                            LinkedHashMap targetMethodGenericTypeMap = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                            Map<String, Map<String, ClassNode>> genericInfo = AstGenericUtils.buildAllGenericElementInfo(classNode, new GroovyVisitorContext((SourceUnit)ScriptBytecodeAdapter.castToType((Object)this.source.get(), SourceUnit.class), (CompilationUnit)ScriptBytecodeAdapter.castToType((Object)this.unit.get(), CompilationUnit.class)));
                            Map<String, ClassNode> declaringTypeGenericInfo = (Map<String, ClassNode>)ScriptBytecodeAdapter.castToType(genericInfo.get(((MethodNode)this.methodNode.get()).getDeclaringClass().getName()), Map.class);
                            if (declaringTypeGenericInfo == null) {
                                Map<String, ClassNode> map;
                                declaringTypeGenericInfo = map = Collections.emptyMap();
                            }
                            Object resolvedReturnType = AstGenericUtils.resolveTypeReference(targetBeanMethodNode.getReturnType(), declaringTypeGenericInfo);
                            Object returnTypeReference = this.this$0.resolveReturnType(classNode, targetBeanMethodNode, declaringTypeGenericInfo);
                            Map<String, Object> resolvedGenericTypes = AstGenericUtils.buildGenericTypeInfo(((MethodNode)this.methodNode.get()).getReturnType(), declaringTypeGenericInfo);
                            this.this$0.populateParameterData(targetBeanMethodNode, targetMethodParamsToType, targetGenericParams, targetAnnotationMetadata, targetMethodGenericTypeMap, declaringTypeGenericInfo, false);
                            AnnotationMetadataReference annotationMetadata = null;
                            if (AstAnnotationUtils.isAnnotated(((ClassNode)this.producedType.get()).getName(), (AnnotatedNode)ScriptBytecodeAdapter.castToType((Object)this.methodNode.get(), AnnotatedNode.class))) {
                                AnnotationMetadata annotationMetadata2 = AstAnnotationUtils.newBuilder((SourceUnit)ScriptBytecodeAdapter.castToType((Object)this.source.get(), SourceUnit.class), (CompilationUnit)ScriptBytecodeAdapter.castToType((Object)this.unit.get(), CompilationUnit.class)).buildForParent(((ClassNode)this.producedType.get()).getName(), this.methodNode.get(), targetBeanMethodNode);
                                annotationMetadata = annotationMetadata2;
                            } else {
                                AnnotationMetadataReference annotationMetadataReference;
                                annotationMetadata = annotationMetadataReference = new AnnotationMetadataReference(StringGroovyMethods.plus((String)((BeanDefinitionWriter)this.beanMethodWriter.get()).getBeanDefinitionName(), (CharSequence)BeanDefinitionReferenceWriter.REF_SUFFIX), (AnnotationMetadata)ScriptBytecodeAdapter.castToType((Object)this.methodAnnotationMetadata.get(), AnnotationMetadata.class));
                            }
                            ExecutableMethodWriter writer = ((BeanDefinitionWriter)this.beanMethodWriter.get()).visitExecutableMethod(AstGenericUtils.resolveTypeReference(targetBeanMethodNode.getDeclaringClass()), returnTypeReference, resolvedReturnType, resolvedGenericTypes, targetBeanMethodNode.getName(), (Map)targetMethodParamsToType, (Map)targetGenericParams, (Map)targetAnnotationMetadata, (Map)targetMethodGenericTypeMap, (AnnotationMetadata)annotationMetadata, targetBeanMethodNode.getDeclaringClass().isInterface(), false);
                            ((AopProxyWriter)this.proxyWriter.get()).visitAroundMethod(AstGenericUtils.resolveTypeReference(targetBeanMethodNode.getDeclaringClass()), returnTypeReference, resolvedReturnType, resolvedGenericTypes, targetBeanMethodNode.getName(), (Map)targetMethodParamsToType, (Map)targetGenericParams, (Map)targetAnnotationMetadata, (Map)targetMethodGenericTypeMap, (AnnotationMetadata)new AnnotationMetadataReference(writer.getClassName(), (AnnotationMetadata)annotationMetadata), targetBeanMethodNode.getDeclaringClass().isInterface(), false);
                        }

                        public /* synthetic */ Object methodMissing(String name, Object args) {
                            return this.this$0.this$dist$invoke$3(name, args);
                        }

                        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                            return ScriptBytecodeAdapter.invokeMethodN(3.class, InjectVisitor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                        }

                        public /* synthetic */ void propertyMissing(String name, Object val) {
                            this.this$0.this$dist$set$3(name, val);
                        }

                        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                            Object object = val;
                            ScriptBytecodeAdapter.setProperty((Object)object, null, InjectVisitor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                        }

                        public /* synthetic */ Object propertyMissing(String name) {
                            return this.this$0.this$dist$get$3(name);
                        }

                        public static /* synthetic */ Object $static_propertyMissing(String name) {
                            return ScriptBytecodeAdapter.getProperty(3.class, InjectVisitor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                        }

                        @Override
                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != 3.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }.accept(returnType);
                    this.beanDefinitionWriters.put(new AnnotatedNode(), (BeanDefinitionVisitor)((AopProxyWriter)proxyWriter.get()));
                }
                Optional preDestroy = ((AnnotationMetadata)methodAnnotationMetadata.get()).getValue(Bean.class, "preDestroy", String.class);
                if (preDestroy.isPresent()) {
                    String destroyMethodName = ShortTypeHandling.castToString(preDestroy.get());
                    MethodNode destroyMethod = ((ClassNode)producedType.get()).getMethod(destroyMethodName, new Parameter[0]);
                    if (destroyMethod != null) {
                        ((BeanDefinitionWriter)beanMethodWriter.get()).visitPreDestroyMethod((Object)destroyMethod.getDeclaringClass().getName(), AstGenericUtils.resolveTypeReference(destroyMethod.getReturnType(), genericsSpec), destroyMethodName);
                    } else {
                        this.addError(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{destroyMethodName}, new String[]{"@Bean method defines a preDestroy method that does not exist or is not public: ", ""})), (ASTNode)((MethodNode)methodNode2.get()));
                    }
                }
                this.beanDefinitionWriters.put((AnnotatedNode)((MethodNode)methodNode2.get()), (BeanDefinitionVisitor)((BeanDefinitionWriter)beanMethodWriter.get()));
            } else if (((AnnotationMetadata)methodAnnotationMetadata.get()).hasStereotype(new String[]{Inject.class.getName(), ProcessedTypes.POST_CONSTRUCT, ProcessedTypes.PRE_DESTROY})) {
                if (isConstructor && ((AnnotationMetadata)methodAnnotationMetadata.get()).hasStereotype(Inject.class)) {
                    this.defineBeanDefinition(this.concreteClass);
                } else if (!isConstructor && !((MethodNode)methodNode2.get()).isStatic() && !((MethodNode)methodNode2.get()).isAbstract()) {
                    boolean isParent = ScriptBytecodeAdapter.compareNotEqual((Object)declaringClass, (Object)this.concreteClass);
                    MethodNode overriddenMethod = isParent ? this.concreteClass.getMethod(methodName, ((MethodNode)methodNode2.get()).getParameters()) : (MethodNode)methodNode2.get();
                    boolean overridden = isParent && ScriptBytecodeAdapter.compareNotEqual((Object)overriddenMethod.getDeclaringClass(), (Object)declaringClass);
                    boolean isPackagePrivate = this.isPackagePrivate((AnnotatedNode)((MethodNode)methodNode2.get()), ((MethodNode)methodNode2.get()).getModifiers());
                    boolean isPrivate = ((MethodNode)methodNode2.get()).isPrivate();
                    if (isParent && !isPrivate && !isPackagePrivate && overridden) {
                        return;
                    }
                    boolean packagesDiffer = ScriptBytecodeAdapter.compareNotEqual((Object)overriddenMethod.getDeclaringClass().getPackageName(), (Object)declaringClass.getPackageName());
                    boolean isPackagePrivateAndPackagesDiffer = overridden && packagesDiffer && isPackagePrivate;
                    boolean requiresReflection = isPrivate || isPackagePrivateAndPackagesDiffer;
                    boolean overriddenInjected = overridden && AstAnnotationUtils.hasStereotype(this.sourceUnit, this.compilationUnit, (AnnotatedNode)overriddenMethod, Inject.class);
                    if (isParent && isPackagePrivate && !isPackagePrivateAndPackagesDiffer && overriddenInjected) {
                        return;
                    }
                    if (isParent && overridden && !overriddenInjected && !isPackagePrivateAndPackagesDiffer && !isPrivate) {
                        return;
                    }
                    if (!requiresReflection && this.isInheritedAndNotPublic((AnnotatedNode)((MethodNode)methodNode2.get()), declaringClass, ((MethodNode)methodNode2.get()).getModifiers())) {
                        boolean bl;
                        requiresReflection = bl = true;
                    }
                    LinkedHashMap paramsToType = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                    LinkedHashMap argumentAnnotationMetadata = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                    LinkedHashMap genericTypeMap = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                    this.populateParameterData((MethodNode)methodNode2.get(), paramsToType, paramsToType, argumentAnnotationMetadata, genericTypeMap, Collections.emptyMap(), false);
                    if (this.isDeclaredBean && ((AnnotationMetadata)methodAnnotationMetadata.get()).hasStereotype(ProcessedTypes.POST_CONSTRUCT)) {
                        this.defineBeanDefinition(this.concreteClass);
                        BeanDefinitionVisitor beanWriter = this.getBeanWriter();
                        if (this.aopProxyWriter instanceof AopProxyWriter && !((AopProxyWriter)ScriptBytecodeAdapter.castToType((Object)this.aopProxyWriter, AopProxyWriter.class)).isProxyTarget()) {
                            BeanDefinitionVisitor beanDefinitionVisitor;
                            beanWriter = beanDefinitionVisitor = this.aopProxyWriter;
                        }
                        beanWriter.visitPostConstructMethod(AstGenericUtils.resolveTypeReference(declaringClass), requiresReflection, AstGenericUtils.resolveTypeReference(((MethodNode)methodNode2.get()).getReturnType()), methodName, (Map)paramsToType, (Map)argumentAnnotationMetadata, (Map)genericTypeMap, (AnnotationMetadata)methodAnnotationMetadata.get());
                    } else if (this.isDeclaredBean && ((AnnotationMetadata)methodAnnotationMetadata.get()).hasStereotype(ProcessedTypes.PRE_DESTROY)) {
                        this.defineBeanDefinition(this.concreteClass);
                        BeanDefinitionVisitor beanWriter = this.getBeanWriter();
                        if (this.aopProxyWriter instanceof AopProxyWriter && !((AopProxyWriter)ScriptBytecodeAdapter.castToType((Object)this.aopProxyWriter, AopProxyWriter.class)).isProxyTarget()) {
                            BeanDefinitionVisitor beanDefinitionVisitor;
                            beanWriter = beanDefinitionVisitor = this.aopProxyWriter;
                        }
                        beanWriter.visitPreDestroyMethod(AstGenericUtils.resolveTypeReference(declaringClass), requiresReflection, AstGenericUtils.resolveTypeReference(((MethodNode)methodNode2.get()).getReturnType()), methodName, (Map)paramsToType, (Map)argumentAnnotationMetadata, (Map)genericTypeMap, (AnnotationMetadata)methodAnnotationMetadata.get());
                    } else if (((AnnotationMetadata)methodAnnotationMetadata.get()).hasStereotype(Inject.class)) {
                        this.defineBeanDefinition(this.concreteClass);
                        this.getBeanWriter().visitMethodInjectionPoint(AstGenericUtils.resolveTypeReference(declaringClass), requiresReflection, AstGenericUtils.resolveTypeReference(((MethodNode)methodNode2.get()).getReturnType()), methodName, (Map)paramsToType, (Map)argumentAnnotationMetadata, (Map)genericTypeMap, (AnnotationMetadata)methodAnnotationMetadata.get());
                    }
                }
            } else if (!isConstructor) {
                boolean hasInvalidModifiers = ((MethodNode)methodNode2.get()).isStatic() || ((MethodNode)methodNode2.get()).isAbstract() || ((MethodNode)methodNode2.get()).isSynthetic() || ((AnnotationMetadata)methodAnnotationMetadata.get()).hasAnnotation(Internal.class) || ((MethodNode)methodNode2.get()).isPrivate();
                boolean isPublic = ((MethodNode)methodNode2.get()).isPublic() && !hasInvalidModifiers;
                boolean isExecutable = (this.isExecutableType && isPublic || ((AnnotationMetadata)methodAnnotationMetadata.get()).hasStereotype(Executable.class)) && !hasInvalidModifiers;
                if (isExecutable) {
                    this.visitExecutableMethod(declaringClass, (MethodNode)methodNode2.get(), (AnnotationMetadata)methodAnnotationMetadata.get(), methodName, isPublic);
                } else if (this.isConfigurationProperties && isPublic) {
                    if (NameUtils.isSetterName((String)((MethodNode)methodNode2.get()).getName()) && ((MethodNode)methodNode2.get()).getParameters().length == 1) {
                        String propertyName = NameUtils.getPropertyNameForSetter((String)((MethodNode)methodNode2.get()).getName());
                        Parameter parameter = (Parameter)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])((MethodNode)methodNode2.get()).getParameters(), (int)0), Parameter.class);
                        if (((AnnotationMetadata)methodAnnotationMetadata.get()).hasStereotype(ConfigurationBuilder.class)) {
                            this.getBeanWriter().visitConfigBuilderMethod((Object)parameter.getType().getName(), NameUtils.getterNameFor((String)propertyName), (AnnotationMetadata)methodAnnotationMetadata.get(), this.configurationMetadataBuilder, parameter.getType().isInterface());
                            try {
                                this.visitConfigurationBuilder(declaringClass, (AnnotationMetadata)methodAnnotationMetadata.get(), parameter.getType(), this.getBeanWriter());
                            }
                            finally {
                                this.getBeanWriter().visitConfigBuilderEnd();
                            }
                        } else if (declaringClass.getField(propertyName) == null) {
                            if (this.shouldExclude(this.configurationMetadata, propertyName)) {
                                return;
                            }
                            PropertyMetadata propertyMetadata = this.configurationMetadataBuilder.visitProperty((Object)this.concreteClass, (Object)declaringClass, parameter.getType().getName(), propertyName, null, null);
                            AnnotationMetadata annotationMetadata = this.addPropertyMetadata((AnnotationMetadata)methodAnnotationMetadata.get(), propertyMetadata);
                            methodAnnotationMetadata.set((Object)annotationMetadata);
                            this.getBeanWriter().visitSetterValue(AstGenericUtils.resolveTypeReference(((MethodNode)methodNode2.get()).getDeclaringClass()), AstGenericUtils.resolveTypeReference(((MethodNode)methodNode2.get()).getReturnType()), (AnnotationMetadata)methodAnnotationMetadata.get(), false, this.resolveParameterType(parameter), ((MethodNode)methodNode2.get()).getName(), this.resolveGenericTypes(parameter), AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)parameter), true);
                        }
                    } else if (NameUtils.isGetterName((String)((MethodNode)methodNode2.get()).getName()) && !this.getBeanWriter().isValidated() && ((AnnotationMetadata)methodAnnotationMetadata.get()).hasStereotype(InjectTransform.ANN_CONSTRAINT)) {
                        this.getBeanWriter().setValidated(true);
                    }
                } else if (isPublic) {
                    Reference sourceUnit = new Reference((Object)this.sourceUnit);
                    Reference compilationUnit = new Reference((Object)this.compilationUnit);
                    public final class _visitConstructorOrMethod_closure2
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference sourceUnit;
                        private /* synthetic */ Reference compilationUnit;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _visitConstructorOrMethod_closure2(Object _outerInstance, Object _thisObject, Reference sourceUnit, Reference compilationUnit) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            this.sourceUnit = reference2 = sourceUnit;
                            this.compilationUnit = reference = compilationUnit;
                        }

                        public Object doCall(Parameter p) {
                            return AstAnnotationUtils.hasStereotype((SourceUnit)ScriptBytecodeAdapter.castToType((Object)this.sourceUnit.get(), SourceUnit.class), (CompilationUnit)ScriptBytecodeAdapter.castToType((Object)this.compilationUnit.get(), CompilationUnit.class), (AnnotatedNode)p, ANN_CONSTRAINT) || AstAnnotationUtils.hasStereotype((SourceUnit)ScriptBytecodeAdapter.castToType((Object)this.sourceUnit.get(), SourceUnit.class), (CompilationUnit)ScriptBytecodeAdapter.castToType((Object)this.compilationUnit.get(), CompilationUnit.class), (AnnotatedNode)p, ANN_VALID);
                        }

                        public Object call(Parameter p) {
                            return this.doCall(p);
                        }

                        public Object getSourceUnit() {
                            return this.sourceUnit.get();
                        }

                        public Object getCompilationUnit() {
                            return this.compilationUnit.get();
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _visitConstructorOrMethod_closure2.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    boolean isConstrained = this.isDeclaredBean && DefaultGroovyMethods.any((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)((MethodNode)methodNode2.get()).getParameters(), Object[].class)), (Closure)new _visitConstructorOrMethod_closure2((Object)this, (Object)this, sourceUnit, compilationUnit));
                    if (isConstrained) {
                        this.visitExecutableMethod(declaringClass, (MethodNode)methodNode2.get(), (AnnotationMetadata)methodAnnotationMetadata.get(), methodName, isPublic);
                    }
                }
            }
        }

        private AnnotationMetadata addPropertyMetadata(AnnotationMetadata methodAnnotationMetadata, PropertyMetadata propertyMetadata) {
            return DefaultAnnotationMetadata.mutateMember((AnnotationMetadata)methodAnnotationMetadata, (String)PropertySource.class.getName(), (String)AnnotationMetadata.VALUE_MEMBER, Collections.singletonList(new AnnotationValue(Property.class.getName(), Collections.singletonMap((CharSequence)"name", propertyMetadata.getPath()))));
        }

        private void visitExecutableMethod(ClassNode declaringClass, MethodNode methodNode, AnnotationMetadata methodAnnotationMetadata, String methodName, boolean isPublic) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)declaringClass, (Object)ClassHelper.OBJECT_TYPE)) {
                boolean isOwningClass = ScriptBytecodeAdapter.compareEqual((Object)declaringClass, (Object)this.concreteClass);
                Map<String, Map<String, ClassNode>> genericInfo = AstGenericUtils.buildAllGenericElementInfo(this.concreteClass, new GroovyVisitorContext(this.sourceUnit, this.compilationUnit));
                Map<String, ClassNode> declaringTypeGenericInfo = (Map<String, ClassNode>)ScriptBytecodeAdapter.castToType(genericInfo.get(methodNode.getDeclaringClass().getName()), Map.class);
                if (declaringTypeGenericInfo == null) {
                    Map<String, ClassNode> map;
                    declaringTypeGenericInfo = map = Collections.emptyMap();
                }
                List resolvedParameters = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                Parameter p2 = null;
                Parameter[] parameterArray = methodNode.getParameters();
                if (parameterArray != null) {
                    for (Parameter p2 : parameterArray) {
                        if (p2.getType().isGenericsPlaceHolder()) {
                            String name = ((GenericsType)BytecodeInterface8.objectArrayGet((Object[])p2.getType().getGenericsTypes(), (int)0)).getName();
                            resolvedParameters.add(new Parameter((ClassNode)ScriptBytecodeAdapter.castToType((Object)declaringTypeGenericInfo.get(name), ClassNode.class), p2.getName()));
                            continue;
                        }
                        resolvedParameters.add(p2);
                    }
                }
                boolean isParent = ScriptBytecodeAdapter.compareNotEqual((Object)declaringClass, (Object)this.concreteClass);
                MethodNode overriddenMethod = isParent ? this.concreteClass.getMethod(methodName, (Parameter[])ScriptBytecodeAdapter.asType((Object)resolvedParameters, Parameter[].class)) : methodNode;
                if (!isOwningClass && overriddenMethod != null && ScriptBytecodeAdapter.compareNotEqual((Object)overriddenMethod.getDeclaringClass(), (Object)declaringClass)) {
                    return;
                }
                Map<String, Object> returnTypeGenerics = AstGenericUtils.buildGenericTypeInfo(methodNode.getReturnType(), declaringTypeGenericInfo);
                LinkedHashMap paramsToType = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                LinkedHashMap genericParams = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                LinkedHashMap argumentAnnotationMetadata = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                LinkedHashMap genericTypeMap = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                this.populateParameterData(methodNode, paramsToType, genericParams, argumentAnnotationMetadata, genericTypeMap, declaringTypeGenericInfo, false);
                this.defineBeanDefinition(this.concreteClass);
                boolean preprocess = DefaultTypeTransformation.booleanUnbox((Object)methodAnnotationMetadata.booleanValue(Executable.class, "processOnStartup").orElse(false));
                if (preprocess) {
                    this.getBeanWriter().setRequiresMethodProcessing(true);
                }
                public final class _visitExecutableMethod_closure3
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _visitExecutableMethod_closure3(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object am) {
                        return ((AnnotationMetadata)am).hasStereotype(ANN_CONSTRAINT) || ((AnnotationMetadata)am).hasStereotype(ANN_VALID);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _visitExecutableMethod_closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                boolean hasConstraints = argumentAnnotationMetadata.values().stream().anyMatch((Predicate)ScriptBytecodeAdapter.castToType((Object)((Object)new _visitExecutableMethod_closure3((Object)this, (Object)this)), Predicate.class));
                if (hasConstraints && !methodAnnotationMetadata.hasStereotype(InjectTransform.ANN_VALIDATED)) {
                    AnnotationMetadata annotationMetadata;
                    methodAnnotationMetadata = annotationMetadata = this.addValidated(methodAnnotationMetadata);
                }
                ExecutableMethodWriter executableMethodWriter = this.getBeanWriter().visitExecutableMethod(AstGenericUtils.resolveTypeReference(methodNode.getDeclaringClass()), AstGenericUtils.resolveTypeReference(methodNode.getReturnType()), AstGenericUtils.resolveTypeReference(methodNode.getReturnType(), declaringTypeGenericInfo), returnTypeGenerics, methodName, (Map)paramsToType, (Map)genericParams, (Map)argumentAnnotationMetadata, (Map)genericTypeMap, methodAnnotationMetadata, methodNode.getDeclaringClass().isInterface(), false);
                if (methodAnnotationMetadata.hasStereotype(Adapter.class)) {
                    this.visitAdaptedMethod(methodNode, methodAnnotationMetadata);
                }
                boolean hasAround = hasConstraints || methodAnnotationMetadata.hasStereotype(AROUND_TYPE);
                if (this.isAopProxyType && isPublic || hasAround && !this.concreteClass.isAbstract()) {
                    boolean hasExplicitAround = methodAnnotationMetadata.hasDeclaredStereotype(AROUND_TYPE);
                    if (methodNode.isFinal()) {
                        if (hasExplicitAround) {
                            this.addError("Method defines AOP advice but is declared final. Change the method to be non-final in order for AOP advice to be applied.", (ASTNode)methodNode);
                        } else {
                            this.addError("Public method inherits AOP advice but is declared final. Change the method to be non-final in order for AOP advice to be applied.", (ASTNode)methodNode);
                        }
                    } else {
                        Object[] interceptorTypeReferences = methodAnnotationMetadata.getAnnotationNamesByStereotype(Around.class).toArray();
                        if (hasConstraints) {
                            Object[] objectArray = ArrayUtils.concat((Object[])interceptorTypeReferences, (Object[])new Object[]{InjectTransform.ANN_VALIDATED});
                            interceptorTypeReferences = objectArray;
                        }
                        OptionalValues aopSettings = methodAnnotationMetadata.getValues(AROUND_TYPE, Boolean.class);
                        AopProxyWriter proxyWriter = this.resolveProxyWriter((OptionalValues<Boolean>)aopSettings, false, interceptorTypeReferences);
                        if (proxyWriter != null && !methodNode.isFinal()) {
                            proxyWriter.visitInterceptorTypes(interceptorTypeReferences);
                            proxyWriter.visitAroundMethod(AstGenericUtils.resolveTypeReference(methodNode.getDeclaringClass()), AstGenericUtils.resolveTypeReference(methodNode.getReturnType()), AstGenericUtils.resolveTypeReference(methodNode.getReturnType()), returnTypeGenerics, methodName, (Map)paramsToType, (Map)genericParams, (Map)argumentAnnotationMetadata, (Map)genericTypeMap, (AnnotationMetadata)new AnnotationMetadataReference(executableMethodWriter.getClassName(), methodAnnotationMetadata), methodNode.getDeclaringClass().isInterface(), false);
                        }
                    }
                }
            }
        }

        private AnnotationMetadata addValidated(AnnotationMetadata methodAnnotationMetadata) {
            CallSite[] callSiteArray = InjectVisitor.$getCallSiteArray();
            return (AnnotationMetadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callCurrent((GroovyObject)this, (Object)methodAnnotationMetadata, (Object)InjectTransform.ANN_VALIDATED), AnnotationMetadata.class);
        }

        private AnnotationMetadata addAnnotation(AnnotationMetadata methodAnnotationMetadata, String annotationName) {
            CallSite[] callSiteArray = InjectVisitor.$getCallSiteArray();
            Object object = callSiteArray[1].call(callSiteArray[2].callConstructor(GroovyAnnotationMetadataBuilder.class, (Object)this.sourceUnit, (Object)this.compilationUnit), (Object)methodAnnotationMetadata, callSiteArray[3].call(callSiteArray[4].call(AnnotationValue.class, (Object)annotationName)));
            methodAnnotationMetadata = (AnnotationMetadata)ScriptBytecodeAdapter.castToType((Object)object, AnnotationMetadata.class);
            return methodAnnotationMetadata;
        }

        private AopProxyWriter resolveProxyWriter(OptionalValues<Boolean> aopSettings, boolean isFactoryType, Object ... interceptorTypeReferences) {
            AopProxyWriter proxyWriter = (AopProxyWriter)ScriptBytecodeAdapter.castToType((Object)this.aopProxyWriter, AopProxyWriter.class);
            if (proxyWriter == null) {
                AopProxyWriter aopProxyWriter;
                proxyWriter = aopProxyWriter = new AopProxyWriter((BeanDefinitionWriter)ScriptBytecodeAdapter.castToType((Object)this.getBeanWriter(), BeanDefinitionWriter.class), aopSettings, interceptorTypeReferences);
                ClassNode targetClass = this.concreteClass;
                this.populateProxyWriterConstructor(targetClass, proxyWriter);
                String beanDefinitionName = this.getBeanWriter().getBeanDefinitionName();
                if (isFactoryType) {
                    proxyWriter.visitSuperBeanDefinitionFactory(beanDefinitionName);
                } else {
                    proxyWriter.visitSuperBeanDefinition(beanDefinitionName);
                }
                AopProxyWriter aopProxyWriter2 = proxyWriter;
                this.aopProxyWriter = aopProxyWriter2;
                AnnotatedNode node = new AnnotatedNode();
                this.beanDefinitionWriters.put(node, (BeanDefinitionVisitor)proxyWriter);
            }
            return proxyWriter;
        }

        protected void populateProxyWriterConstructor(ClassNode targetClass, AopProxyWriter proxyWriter) {
            List constructors = targetClass.getDeclaredConstructors();
            if (constructors.isEmpty()) {
                proxyWriter.visitBeanDefinitionConstructor(AnnotationMetadata.EMPTY_METADATA, false);
            } else {
                ConstructorNode constructorNode = this.findConcreteConstructor(constructors);
                if (constructorNode != null) {
                    LinkedHashMap constructorParamsToType = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                    LinkedHashMap constructorArgumentMetadata = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                    LinkedHashMap constructorGenericTypeMap = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                    this.populateParameterData((MethodNode)constructorNode, constructorParamsToType, constructorParamsToType, constructorArgumentMetadata, constructorGenericTypeMap, Collections.emptyMap(), false);
                    AnnotationMetadata constructorMetadata = AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)constructorNode);
                    proxyWriter.visitBeanDefinitionConstructor(constructorMetadata, constructorNode.isPrivate(), (Map)constructorParamsToType, (Map)constructorArgumentMetadata, (Map)constructorGenericTypeMap);
                } else {
                    this.addError("Class must have at least one non private constructor in order to be a candidate for dependency injection", (ASTNode)targetClass);
                }
            }
        }

        protected boolean isPackagePrivate(AnnotatedNode annotatedNode, int modifiers) {
            return !Modifier.isProtected(modifiers) && !Modifier.isPublic(modifiers) && !Modifier.isPrivate(modifiers) || !annotatedNode.getAnnotations(ClassHelper.makeCached(PackageScope.class)).isEmpty();
        }

        public void visitField(FieldNode fieldNode) {
            if (ScriptBytecodeAdapter.compareEqual((Object)fieldNode.getName(), (Object)"metaClass")) {
                return;
            }
            int modifiers = fieldNode.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                return;
            }
            if (fieldNode.isSynthetic() && !this.isPackagePrivate((AnnotatedNode)fieldNode, fieldNode.getModifiers())) {
                return;
            }
            ClassNode declaringClass = fieldNode.getDeclaringClass();
            AnnotationMetadata fieldAnnotationMetadata = AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)fieldNode);
            if (Modifier.isFinal(modifiers) && !fieldAnnotationMetadata.hasStereotype(ConfigurationBuilder.class)) {
                return;
            }
            boolean isInject = fieldAnnotationMetadata.hasStereotype(Inject.class);
            boolean isValue = this.isValueInjection(fieldNode, fieldAnnotationMetadata);
            if ((isInject || isValue) && declaringClass.getProperty(fieldNode.getName()) == null) {
                this.defineBeanDefinition(this.concreteClass);
                if (!fieldNode.isStatic()) {
                    boolean isPrivate = Modifier.isPrivate(modifiers);
                    boolean requiresReflection = isPrivate || this.isInheritedAndNotPublic((AnnotatedNode)fieldNode, fieldNode.getDeclaringClass(), modifiers);
                    if (!this.getBeanWriter().isValidated() && fieldAnnotationMetadata.hasStereotype(ANN_CONSTRAINT)) {
                        this.getBeanWriter().setValidated(true);
                    }
                    String fieldName = fieldNode.getName();
                    Object fieldType = AstGenericUtils.resolveTypeReference(fieldNode.getType());
                    if (isValue) {
                        if (this.isConfigurationProperties && fieldAnnotationMetadata.hasStereotype(ConfigurationBuilder.class)) {
                            if (requiresReflection) {
                                Reference fieldGetterName = new Reference((Object)NameUtils.getterNameFor((String)fieldName));
                                List list = declaringClass.getMethods();
                                public final class _visitField_closure4
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference fieldGetterName;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _visitField_closure4(Object _outerInstance, Object _thisObject, Reference fieldGetterName) {
                                        super(_outerInstance, _thisObject);
                                        Reference reference;
                                        this.fieldGetterName = reference = fieldGetterName;
                                    }

                                    public Object doCall(Object it) {
                                        return ScriptBytecodeAdapter.compareEqual((Object)((MethodNode)it).getName(), (Object)this.fieldGetterName.get());
                                    }

                                    public String getFieldGetterName() {
                                        return ShortTypeHandling.castToString((Object)this.fieldGetterName.get());
                                    }

                                    public Object call(Object args) {
                                        return this.doCall(args);
                                    }

                                    public Object call() {
                                        return this.doCall(null);
                                    }

                                    @Generated
                                    public Object doCall() {
                                        return this.doCall(null);
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _visitField_closure4.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }
                                }
                                MethodNode getterMethod = (MethodNode)ScriptBytecodeAdapter.castToType(list != null ? DefaultGroovyMethods.find((Collection)list, (Closure)new _visitField_closure4((Object)this, (Object)this, fieldGetterName)) : null, MethodNode.class);
                                if (getterMethod != null) {
                                    this.getBeanWriter().visitConfigBuilderMethod(fieldType, getterMethod.getName(), fieldAnnotationMetadata, this.configurationMetadataBuilder, fieldNode.getType().isInterface());
                                } else {
                                    this.addError("ConfigurationBuilder applied to a non accessible (private or package-private/protected in a different package) field must have a corresponding non-private getter method.", (ASTNode)fieldNode);
                                }
                            } else {
                                this.getBeanWriter().visitConfigBuilderField(fieldType, fieldName, fieldAnnotationMetadata, this.configurationMetadataBuilder, fieldNode.getType().isInterface());
                            }
                            try {
                                this.visitConfigurationBuilder(declaringClass, fieldAnnotationMetadata, fieldNode.getType(), this.getBeanWriter());
                            }
                            finally {
                                this.getBeanWriter().visitConfigBuilderEnd();
                            }
                        } else {
                            if (this.isConfigurationProperties) {
                                AnnotationMetadata annotationMetadata;
                                if (this.shouldExclude(this.configurationMetadata, fieldName)) {
                                    return;
                                }
                                PropertyMetadata propertyMetadata = this.configurationMetadataBuilder.visitProperty((Object)this.concreteClass, (Object)declaringClass, fieldNode.getType().getName(), fieldName, null, null);
                                fieldAnnotationMetadata = annotationMetadata = DefaultAnnotationMetadata.mutateMember((AnnotationMetadata)fieldAnnotationMetadata, (String)PropertySource.class.getName(), (String)AnnotationMetadata.VALUE_MEMBER, Collections.singletonList(new AnnotationValue(Property.class.getName(), Collections.singletonMap((CharSequence)"name", propertyMetadata.getPath()))));
                            }
                            this.getBeanWriter().visitFieldValue(AstGenericUtils.resolveTypeReference(declaringClass), fieldType, fieldName, requiresReflection, fieldAnnotationMetadata, AstGenericUtils.buildGenericTypeInfo(fieldNode.getType(), Collections.emptyMap()), this.isConfigurationProperties);
                        }
                    } else {
                        this.getBeanWriter().visitFieldInjectionPoint(AstGenericUtils.resolveTypeReference(declaringClass), fieldType, fieldName, requiresReflection, fieldAnnotationMetadata, AstGenericUtils.buildGenericTypeInfo(fieldNode.getType(), Collections.emptyMap()));
                    }
                }
            }
        }

        public Object resolveParameterType(Parameter parameter) {
            ClassNode parameterType = parameter.getType();
            if (parameterType.isResolved()) {
                return parameterType.getTypeClass();
            }
            return parameterType.getName();
        }

        public Map<String, Object> resolveGenericTypes(Parameter parameter, Map<String, ClassNode> boundTypes) {
            ClassNode parameterType = parameter.getType();
            GenericsType[] genericsTypes = parameterType.getGenericsTypes();
            if (genericsTypes != null && genericsTypes.length > 0) {
                return AstGenericUtils.buildGenericTypeInfo(parameterType, boundTypes);
            }
            if (parameterType.isArray()) {
                LinkedHashMap genericTypeList = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                genericTypeList.put("E", AstGenericUtils.resolveTypeReference(parameterType.getComponentType(), boundTypes));
                return genericTypeList;
            }
            return (Map)ScriptBytecodeAdapter.castToType(null, Map.class);
        }

        public void visitProperty(PropertyNode propertyNode) {
            FieldNode fieldNode = propertyNode.getField();
            if (ScriptBytecodeAdapter.compareEqual((Object)fieldNode.getName(), (Object)"metaClass")) {
                return;
            }
            int modifiers = propertyNode.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                return;
            }
            AnnotationMetadata fieldAnnotationMetadata = AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)fieldNode);
            if (Modifier.isFinal(modifiers) && !fieldAnnotationMetadata.hasStereotype(ConfigurationBuilder.class)) {
                return;
            }
            boolean isInject = fieldNode != null && fieldAnnotationMetadata.hasStereotype(Inject.class);
            boolean isValue = this.isValueInjection(fieldNode, fieldAnnotationMetadata);
            String propertyName = propertyNode.getName();
            if (!propertyNode.isStatic() && (isInject || isValue)) {
                this.defineBeanDefinition(this.concreteClass);
                ClassNode fieldType = fieldNode.getType();
                GenericsType[] genericsTypes = fieldType.getGenericsTypes();
                Map genericTypeList = null;
                if (genericsTypes != null && genericsTypes.length > 0) {
                    Map map;
                    genericTypeList = map = AstGenericUtils.buildGenericTypeInfo(fieldType, GenericsUtils.createGenericsSpec((ClassNode)this.concreteClass));
                } else if (fieldType.isArray()) {
                    Map map;
                    genericTypeList = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                    ((HashMap)ScriptBytecodeAdapter.castToType((Object)genericTypeList, HashMap.class)).put(fieldNode.getName(), AstGenericUtils.resolveTypeReference(fieldType.getComponentType()));
                }
                ClassNode declaringClass = fieldNode.getDeclaringClass();
                if (!this.getBeanWriter().isValidated() && fieldAnnotationMetadata.hasStereotype(ANN_CONSTRAINT)) {
                    this.getBeanWriter().setValidated(true);
                }
                Object fieldTypeReference = AstGenericUtils.resolveTypeReference(fieldType);
                if (isInject) {
                    this.getBeanWriter().visitMethodInjectionPoint(AstGenericUtils.resolveTypeReference(declaringClass), false, Void.TYPE, GeneralUtils.getSetterName((String)propertyName), Collections.singletonMap(propertyName, fieldTypeReference), Collections.singletonMap(propertyName, fieldAnnotationMetadata), Collections.singletonMap(propertyName, genericTypeList), fieldAnnotationMetadata);
                } else if (isValue) {
                    if (this.isConfigurationProperties && fieldAnnotationMetadata.hasStereotype(ConfigurationBuilder.class)) {
                        Object resolvedFieldType = fieldNode.getType().isResolved() ? fieldNode.getType().getTypeClass() : fieldNode.getType().getName();
                        this.getBeanWriter().visitConfigBuilderMethod(resolvedFieldType, GeneralUtils.getGetterName((PropertyNode)propertyNode), fieldAnnotationMetadata, this.configurationMetadataBuilder, fieldNode.getType().isInterface());
                        try {
                            this.visitConfigurationBuilder(declaringClass, fieldAnnotationMetadata, fieldNode.getType(), this.getBeanWriter());
                        }
                        finally {
                            this.getBeanWriter().visitConfigBuilderEnd();
                        }
                    } else {
                        if (this.isConfigurationProperties) {
                            AnnotationMetadata annotationMetadata;
                            if (this.shouldExclude(this.configurationMetadata, propertyName)) {
                                return;
                            }
                            PropertyMetadata propertyMetadata = this.configurationMetadataBuilder.visitProperty((Object)this.concreteClass, (Object)declaringClass, propertyNode.getType().getName(), propertyNode.getName(), null, null);
                            fieldAnnotationMetadata = annotationMetadata = DefaultAnnotationMetadata.mutateMember((AnnotationMetadata)fieldAnnotationMetadata, (String)PropertySource.class.getName(), (String)AnnotationMetadata.VALUE_MEMBER, Collections.singletonList(new AnnotationValue(Property.class.getName(), Collections.singletonMap((CharSequence)"name", propertyMetadata.getPath()))));
                        }
                        this.getBeanWriter().visitSetterValue(AstGenericUtils.resolveTypeReference(declaringClass), Void.TYPE, fieldAnnotationMetadata, false, fieldTypeReference, fieldNode.getName(), GeneralUtils.getSetterName((String)propertyName), genericTypeList, this.isConfigurationProperties);
                    }
                }
            } else if (this.isAopProxyType && !propertyNode.isStatic()) {
                AopProxyWriter aopWriter = (AopProxyWriter)ScriptBytecodeAdapter.castToType((Object)this.aopProxyWriter, AopProxyWriter.class);
                if (this.aopProxyWriter != null) {
                    Map map;
                    Map map2;
                    LinkedHashMap resolvedGenericTypes = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{propertyName, AstGenericUtils.extractPlaceholders(propertyNode.getType())}), LinkedHashMap.class);
                    Object propertyType = AstGenericUtils.resolveTypeReference(propertyNode.getType());
                    LinkedHashMap resolvedArguments = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{propertyName, propertyType}), LinkedHashMap.class);
                    AnnotationMetadata fieldMetadata = AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)propertyNode.getField());
                    Map resolvedAnnotationMetadata = null;
                    Map emptyMap = Collections.emptyMap();
                    resolvedAnnotationMetadata = fieldMetadata != null ? (map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{propertyName, fieldMetadata})) : (map = emptyMap);
                    this.beanWriter.visitExecutableMethod((Object)propertyNode.getDeclaringClass().getName(), Void.TYPE, Void.TYPE, emptyMap, GeneralUtils.getSetterName((String)propertyName), (Map)resolvedArguments, (Map)resolvedArguments, resolvedAnnotationMetadata, (Map)resolvedGenericTypes, fieldAnnotationMetadata, propertyNode.getDeclaringClass().isInterface(), false);
                    aopWriter.visitAroundMethod((Object)propertyNode.getDeclaringClass().getName(), Void.TYPE, Void.TYPE, emptyMap, GeneralUtils.getSetterName((String)propertyName), (Map)resolvedArguments, (Map)resolvedArguments, resolvedAnnotationMetadata, (Map)resolvedGenericTypes, fieldAnnotationMetadata, propertyNode.getDeclaringClass().isInterface(), false);
                    this.beanWriter.visitExecutableMethod((Object)propertyNode.getDeclaringClass().getName(), propertyType, propertyType, emptyMap, GeneralUtils.getGetterName((PropertyNode)propertyNode), emptyMap, emptyMap, emptyMap, emptyMap, fieldAnnotationMetadata, propertyNode.getDeclaringClass().isInterface(), false);
                    aopWriter.visitAroundMethod((Object)propertyNode.getDeclaringClass().getName(), propertyType, propertyType, emptyMap, GeneralUtils.getGetterName((PropertyNode)propertyNode), emptyMap, emptyMap, emptyMap, emptyMap, fieldAnnotationMetadata, propertyNode.getDeclaringClass().isInterface(), false);
                }
            }
        }

        private boolean isValueInjection(FieldNode fieldNode, AnnotationMetadata fieldAnnotationMetadata) {
            return fieldNode != null && (fieldAnnotationMetadata.hasStereotype(Value.class) || fieldAnnotationMetadata.hasStereotype(Property.class) || this.isConfigurationProperties);
        }

        protected boolean isInheritedAndNotPublic(AnnotatedNode annotatedNode, ClassNode declaringClass, int modifiers) {
            return ScriptBytecodeAdapter.compareNotEqual((Object)declaringClass, (Object)this.concreteClass) && ScriptBytecodeAdapter.compareNotEqual((Object)declaringClass.getPackageName(), (Object)this.concreteClass.getPackageName()) && (Modifier.isProtected(modifiers) || !Modifier.isPublic(modifiers) || !annotatedNode.getAnnotations(ClassHelper.makeCached(PackageScope.class)).isEmpty());
        }

        protected SourceUnit getSourceUnit() {
            return this.sourceUnit;
        }

        private void defineBeanDefinition(ClassNode classNode) {
            if (!this.beanDefinitionWriters.containsKey(classNode)) {
                if (classNode.getPackageName() == null) {
                    this.addError("Micronaut beans cannot be in the default package", (ASTNode)classNode);
                    return;
                }
                ClassNode providerGenericType = AstGenericUtils.resolveInterfaceGenericType(classNode, Provider.class);
                boolean isProvider = providerGenericType != null;
                AnnotationMetadata annotationMetadata = AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)classNode);
                if (annotationMetadata.hasStereotype(Singleton.class)) {
                    this.addError("Class annotated with groovy.lang.Singleton instead of javax.inject.Singleton. Import javax.inject.Singleton to use Micronaut Dependency Injection.", (ASTNode)classNode);
                }
                if (this.configurationMetadata != null) {
                    AnnotationMetadata annotationMetadata2;
                    String existingPrefix = ShortTypeHandling.castToString((Object)annotationMetadata.getValue(ConfigurationReader.class, "prefix", String.class).orElse(""));
                    annotationMetadata = annotationMetadata2 = DefaultAnnotationMetadata.mutateMember((AnnotationMetadata)annotationMetadata, (String)ConfigurationReader.class.getName(), (String)"prefix", (Object)(StringUtils.isNotEmpty((CharSequence)existingPrefix) ? StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)existingPrefix, (CharSequence)"."), (CharSequence)this.configurationMetadata.getName()) : this.configurationMetadata.getName()));
                }
                if (isProvider) {
                    BeanDefinitionWriter beanDefinitionWriter = new BeanDefinitionWriter(classNode.getPackageName(), classNode.getNameWithoutPackage(), providerGenericType.getName(), classNode.isInterface(), annotationMetadata);
                    this.beanWriter = beanDefinitionWriter;
                } else {
                    BeanDefinitionWriter beanDefinitionWriter = new BeanDefinitionWriter(classNode.getPackageName(), classNode.getNameWithoutPackage(), annotationMetadata);
                    this.beanWriter = beanDefinitionWriter;
                }
                this.visitTypeArguments(classNode, (BeanDefinitionWriter)ScriptBytecodeAdapter.castToType((Object)this.beanWriter, BeanDefinitionWriter.class));
                this.beanDefinitionWriters.put((AnnotatedNode)classNode, this.beanWriter);
                List constructors = classNode.getDeclaredConstructors();
                if (constructors.isEmpty()) {
                    this.beanWriter.visitBeanDefinitionConstructor(AnnotationMetadata.EMPTY_METADATA, false, Collections.emptyMap(), null, null);
                } else {
                    ConstructorNode constructorNode = this.findConcreteConstructor(constructors);
                    if (constructorNode != null) {
                        AnnotationMetadata constructorMetadata = AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)constructorNode);
                        boolean isConstructBinding = constructorMetadata.hasDeclaredStereotype(ConfigurationInject.class);
                        if (isConstructBinding) {
                            ConfigurationMetadata configurationMetadata;
                            this.configurationMetadata = configurationMetadata = this.configurationMetadataBuilder.visitProperties((Object)this.concreteClass, null);
                        }
                        LinkedHashMap paramsToType = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                        LinkedHashMap qualifierTypes = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                        LinkedHashMap genericTypeMap = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                        this.populateParameterData((MethodNode)constructorNode, paramsToType, paramsToType, qualifierTypes, genericTypeMap, Collections.emptyMap(), isConstructBinding);
                        this.beanWriter.visitBeanDefinitionConstructor(constructorMetadata, constructorNode.isPrivate(), (Map)paramsToType, (Map)qualifierTypes, (Map)genericTypeMap);
                        public final class _defineBeanDefinition_closure5
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _defineBeanDefinition_closure5(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object it) {
                                return ((AnnotationMetadata)it).hasStereotype(ANN_CONSTRAINT) || ((AnnotationMetadata)it).hasStereotype(ANN_VALID);
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _defineBeanDefinition_closure5.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        this.beanWriter.setValidated(DefaultGroovyMethods.any(qualifierTypes.values(), (Closure)new _defineBeanDefinition_closure5((Object)this, (Object)this)));
                    } else {
                        this.addError("Class must have at least one non private constructor in order to be a candidate for dependency injection", (ASTNode)classNode);
                    }
                }
                if (this.isAopProxyType) {
                    Object[] interceptorTypeReferences = annotationMetadata.getAnnotationNamesByStereotype(Around.class).toArray();
                    this.resolveProxyWriter(this.aopSettings, false, interceptorTypeReferences);
                }
            } else {
                BeanDefinitionVisitor beanDefinitionVisitor = this.beanDefinitionWriters.get(classNode);
                this.beanWriter = (BeanDefinitionVisitor)ScriptBytecodeAdapter.castToType((Object)beanDefinitionVisitor, BeanDefinitionVisitor.class);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void visitAdaptedMethod(MethodNode method, AnnotationMetadata methodAnnotationMetadata) {
            void var2_2;
            Reference method2 = new Reference((Object)method);
            Reference methodAnnotationMetadata2 = new Reference((Object)var2_2);
            CallSite[] callSiteArray = InjectVisitor.$getCallSiteArray();
            public final class _visitAdaptedMethod_closure6
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _visitAdaptedMethod_closure6(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _visitAdaptedMethod_closure6.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(String s) {
                    Reference s2 = new Reference((Object)s);
                    CallSite[] callSiteArray = _visitAdaptedMethod_closure6.$getCallSiteArray();
                    public final class _closure10
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference s;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure10(Object _outerInstance, Object _thisObject, Reference s) {
                            Reference reference;
                            CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.s = reference = s;
                        }

                        public Object doCall(ClassNode cn) {
                            CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                            return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty((Object)cn), (Object)this.s.get());
                        }

                        public Object call(ClassNode cn) {
                            CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                            return callSiteArray[1].callCurrent((GroovyObject)this, (Object)cn);
                        }

                        public String getS() {
                            CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                            return ShortTypeHandling.castToString((Object)this.s.get());
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure10.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "name";
                            stringArray[1] = "doCall";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[2];
                            _closure10.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure10.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure10.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    ClassNode cn = (ClassNode)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(callSiteArray[2].callGetProperty(callSiteArray[3].callGroovyObjectGetProperty((Object)this))), (Object)new _closure10((Object)this, this.getThisObject(), s2)), ClassNode.class);
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)cn, null)) {
                        return callSiteArray[4].call(Optional.class, (Object)cn);
                    }
                    Object type = callSiteArray[5].call(callSiteArray[6].call(ClassUtils.class, (Object)((String)s2.get()), callSiteArray[7].callGetProperty(InjectTransform.class)), null);
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)type, null)) {
                        return callSiteArray[8].call(Optional.class, callSiteArray[9].call(ClassHelper.class, type));
                    }
                    return callSiteArray[10].call(Optional.class);
                }

                public Object call(String s) {
                    Reference s2 = new Reference((Object)s);
                    CallSite[] callSiteArray = _visitAdaptedMethod_closure6.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[11].callCurrent((GroovyObject)this, (Object)((String)s2.get()));
                    }
                    return this.doCall((String)s2.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _visitAdaptedMethod_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "find";
                    stringArray[1] = "classes";
                    stringArray[2] = "AST";
                    stringArray[3] = "sourceUnit";
                    stringArray[4] = "of";
                    stringArray[5] = "orElse";
                    stringArray[6] = "forName";
                    stringArray[7] = "classLoader";
                    stringArray[8] = "of";
                    stringArray[9] = "make";
                    stringArray[10] = "empty";
                    stringArray[11] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[12];
                    _visitAdaptedMethod_closure6.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_visitAdaptedMethod_closure6.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _visitAdaptedMethod_closure6.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Optional adaptedType = (Optional)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].call(callSiteArray[6].call((Object)((AnnotationMetadata)methodAnnotationMetadata2.get()), Adapter.class, String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Function)ScriptBytecodeAdapter.asType((Object)((Object)new _visitAdaptedMethod_closure6((Object)this, (Object)this)), Function.class)), Function.class)), Optional.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].call((Object)adaptedType))) {
                Reference typeToImplement = new Reference((Object)((ClassNode)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].call((Object)adaptedType), ClassNode.class)));
                boolean isInterface = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].call((Object)((ClassNode)typeToImplement.get())));
                if (isInterface) {
                    String packageName = ShortTypeHandling.castToString((Object)callSiteArray[10].callGetProperty((Object)this.concreteClass));
                    String declaringClassSimpleName = ShortTypeHandling.castToString((Object)callSiteArray[11].callGetProperty((Object)this.concreteClass));
                    String beanClassName = ShortTypeHandling.castToString((Object)callSiteArray[12].callCurrent((GroovyObject)this, (Object)declaringClassSimpleName, (Object)((ClassNode)typeToImplement.get()), (Object)((MethodNode)method2.get())));
                    Reference aopProxyWriter = new Reference((Object)((AopProxyWriter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].callConstructor(AopProxyWriter.class, ArrayUtil.createArray((Object)packageName, (Object)beanClassName, (Object)true, (Object)false, (Object)((AnnotationMetadata)methodAnnotationMetadata2.get()), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Object[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[14].callGetProperty((Object)((ClassNode)typeToImplement.get()))}), Object[].class)), Object[].class), (Object)callSiteArray[15].callGetProperty(ArrayUtils.class))), AopProxyWriter.class)));
                    callSiteArray[16].call((Object)((AopProxyWriter)aopProxyWriter.get()), (Object)((AnnotationMetadata)methodAnnotationMetadata2.get()), (Object)false);
                    callSiteArray[17].call(this.beanDefinitionWriters, callSiteArray[18].call(ClassHelper.class, callSiteArray[19].call(callSiteArray[20].call((Object)packageName, (Object)"."), (Object)beanClassName)), (Object)((AopProxyWriter)aopProxyWriter.get()));
                    GenericsType[] typeArguments = (GenericsType[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].call((Object)((ClassNode)typeToImplement.get())), GenericsType[].class);
                    Object object = callSiteArray[23].callSafe((Object)typeArguments);
                    Reference typeVariables = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].callConstructor(HashMap.class, DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Integer.valueOf(1)), Map.class)));
                    GenericsType typeArgument = null;
                    Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].call((Object)typeArguments), Iterator.class);
                    while (iterator.hasNext()) {
                        typeArgument = (GenericsType)ScriptBytecodeAdapter.castToType(iterator.next(), GenericsType.class);
                        callSiteArray[25].call((Object)((Map)typeVariables.get()), callSiteArray[26].callGetProperty((Object)typeArgument), callSiteArray[27].callGetProperty((Object)typeArgument));
                    }
                    Reference thisVisitor = new Reference((Object)this);
                    Reference source = new Reference((Object)this.sourceUnit);
                    Reference unit = new Reference((Object)this.compilationUnit);
                    PublicAbstractMethodVisitor visitor = new PublicAbstractMethodVisitor(this, thisVisitor, typeToImplement, method2, typeVariables, aopProxyWriter, source, unit, methodAnnotationMetadata2, (SourceUnit)source.get(), (CompilationUnit)unit.get()){
                        public /* synthetic */ Reference methodAnnotationMetadata;
                        public /* synthetic */ Reference unit;
                        public /* synthetic */ Reference source;
                        public /* synthetic */ Reference aopProxyWriter;
                        public /* synthetic */ Reference typeVariables;
                        public /* synthetic */ Reference method;
                        public /* synthetic */ Reference typeToImplement;
                        public /* synthetic */ Reference thisVisitor;
                        private boolean first;
                        public /* synthetic */ InjectVisitor this$0;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;
                        {
                            boolean bl;
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            Reference reference4;
                            Reference reference5;
                            Reference reference6;
                            Reference reference7;
                            Reference reference8;
                            InjectVisitor injectVisitor;
                            CallSite[] callSiteArray = 4.$getCallSiteArray();
                            this.this$0 = injectVisitor = p0;
                            super((SourceUnit)ScriptBytecodeAdapter.castToType((Object)p10, SourceUnit.class), (CompilationUnit)ScriptBytecodeAdapter.castToType((Object)p11, CompilationUnit.class));
                            this.methodAnnotationMetadata = reference8 = p8;
                            this.unit = reference7 = p7;
                            this.source = reference6 = p6;
                            this.aopProxyWriter = reference5 = p5;
                            this.typeVariables = reference4 = p4;
                            this.method = reference3 = p3;
                            this.typeToImplement = reference2 = p2;
                            this.thisVisitor = reference = p1;
                            this.first = bl = true;
                        }

                        @Override
                        public void accept(ClassNode classNode, MethodNode targetMethod) {
                            boolean bl;
                            CallSite[] callSiteArray = 4.$getCallSiteArray();
                            if (!this.first) {
                                callSiteArray[0].call(this.thisVisitor.get(), callSiteArray[1].call(callSiteArray[2].call((Object)"Interface to adapt [", this.typeToImplement.get()), (Object)"] is not a SAM type. More than one abstract method declared."), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((MethodNode)this.method.get()), MethodNode.class));
                                return;
                            }
                            this.first = bl = false;
                            Parameter[] targetParameters = (Parameter[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].call((Object)targetMethod), Parameter[].class);
                            Parameter[] sourceParameters = (Parameter[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(this.method.get()), Parameter[].class);
                            Map boundTypes = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].call(AstGenericUtils.class, (Object)classNode), Map.class);
                            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].call((Object)targetParameters), (Object)callSiteArray[7].call((Object)sourceParameters))) {
                                int i = 0;
                                Map genericTypes = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].callConstructor(HashMap.class), Map.class);
                                Parameter targetElement = null;
                                Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[9].call((Object)targetParameters), Iterator.class);
                                while (iterator.hasNext()) {
                                    targetElement = (Parameter)ScriptBytecodeAdapter.castToType(iterator.next(), Parameter.class);
                                    Parameter sourceElement = (Parameter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].call((Object)sourceParameters, (Object)i), Parameter.class);
                                    ClassNode targetType = (ClassNode)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].call((Object)targetElement), ClassNode.class);
                                    ClassNode sourceType = (ClassNode)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].call((Object)sourceElement), ClassNode.class);
                                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].call((Object)targetType))) {
                                        GenericsType[] targetGenerics = (GenericsType[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].callGetProperty((Object)targetType), GenericsType[].class);
                                        if (DefaultTypeTransformation.booleanUnbox((Object)targetGenerics)) {
                                            String variableName = ShortTypeHandling.castToString((Object)callSiteArray[15].callGetProperty(callSiteArray[16].call((Object)targetGenerics, (Object)0)));
                                            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].call(this.typeVariables.get(), (Object)variableName))) {
                                                Object object = callSiteArray[18].call(this.typeVariables.get(), (Object)variableName);
                                                targetType = (ClassNode)ScriptBytecodeAdapter.castToType((Object)object, ClassNode.class);
                                                callSiteArray[19].call((Object)genericTypes, (Object)variableName, callSiteArray[20].call(AstGenericUtils.class, (Object)sourceType, (Object)boundTypes));
                                            }
                                        }
                                    }
                                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].call(AstClassUtils.class, (Object)sourceType, (Object)targetType))) {
                                        callSiteArray[22].call(this.thisVisitor.get(), callSiteArray[23].call(callSiteArray[24].call((Object)new GStringImpl(new Object[]{callSiteArray[25].callGetProperty(callSiteArray[26].callGetProperty(this.method.get())), callSiteArray[27].callGetProperty(this.method.get()), callSiteArray[28].callGetProperty(callSiteArray[29].callGetProperty((Object)targetMethod)), callSiteArray[30].callGetProperty((Object)targetMethod)}, new String[]{"Cannot adapt method [", ".", "(..)] to target method [", ".", "(..)]. Argument type ["}), callSiteArray[31].callGetProperty((Object)sourceType)), (Object)new GStringImpl(new Object[]{callSiteArray[32].callGetProperty((Object)targetType), i}, new String[]{"] is not a subtype of type [", "] at position ", "."})), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((MethodNode)this.method.get()), MethodNode.class));
                                        return;
                                    }
                                    int n = i;
                                    i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[33].call((Object)n));
                                }
                                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[34].call((Object)genericTypes))) {
                                    Map typeData = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].call(Collections.class, callSiteArray[36].callGetProperty(this.typeToImplement.get()), (Object)genericTypes), Map.class);
                                    callSiteArray[37].call(this.aopProxyWriter.get(), (Object)typeData);
                                }
                                Map targetMethodParamsToType = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                                Map targetMethodGenericParams = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                                Map targetAnnotationMetadata = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                                Map targetMethodGenericTypeMap = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[38].call((Object)classNode))) {
                                    callSiteArray[39].call(AstGenericUtils.class, (Object)targetMethod, (Object)boundTypes);
                                }
                                Object resolvedReturnType = callSiteArray[40].call(AstGenericUtils.class, callSiteArray[41].callGetProperty((Object)targetMethod), (Object)boundTypes);
                                Map resolvedGenericTypes = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].call(AstGenericUtils.class, callSiteArray[43].callGetProperty((Object)targetMethod), (Object)boundTypes), Map.class);
                                callSiteArray[44].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)targetMethod, (Object)targetMethodParamsToType, (Object)targetMethodGenericParams, (Object)targetAnnotationMetadata, (Object)targetMethodGenericTypeMap, (Object)boundTypes, (Object)false));
                                AnnotationClassValue[] adaptedArgumentTypes = new AnnotationClassValue[DefaultTypeTransformation.intUnbox((Object)callSiteArray[45].callGetProperty((Object)sourceParameters))];
                                int j = 0;
                                Parameter ve = null;
                                Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].call((Object)sourceParameters), Iterator.class);
                                while (iterator2.hasNext()) {
                                    ve = (Parameter)ScriptBytecodeAdapter.castToType(iterator2.next(), Parameter.class);
                                    Object r = callSiteArray[47].call(AstGenericUtils.class, callSiteArray[48].callGetProperty((Object)ve), (Object)boundTypes);
                                    if (r instanceof Class) {
                                        Object object = callSiteArray[49].callConstructor(AnnotationClassValue.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)ShortTypeHandling.castToClass((Object)r), Class.class));
                                        callSiteArray[50].call((Object)adaptedArgumentTypes, (Object)j, object);
                                    } else {
                                        Object object = callSiteArray[51].callConstructor(AnnotationClassValue.class, callSiteArray[52].call(r));
                                        callSiteArray[53].call((Object)adaptedArgumentTypes, (Object)j, object);
                                    }
                                    int n = j;
                                    j = DefaultTypeTransformation.intUnbox((Object)callSiteArray[54].call((Object)n));
                                }
                                Object values = callSiteArray[55].call(CollectionUtils.class, ArrayUtil.createArray((Object)callSiteArray[56].callGetProperty(Adapter.InternalAttributes.class), (Object)callSiteArray[57].callConstructor(AnnotationClassValue.class, callSiteArray[58].callGetProperty(callSiteArray[59].callGroovyObjectGetProperty((Object)this))), (Object)callSiteArray[60].callGetProperty(Adapter.InternalAttributes.class), (Object)callSiteArray[61].callGetProperty(this.method.get()), (Object)callSiteArray[62].callGetProperty(Adapter.InternalAttributes.class), (Object)adaptedArgumentTypes));
                                String qualifier = ShortTypeHandling.castToString((Object)callSiteArray[63].call(callSiteArray[64].call(callSiteArray[65].call(AstAnnotationUtils.class, this.source.get(), this.unit.get(), callSiteArray[66].callGroovyObjectGetProperty((Object)this)), Named.class, String.class), null));
                                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[67].call(StringUtils.class, (Object)qualifier))) {
                                    callSiteArray[68].call(values, callSiteArray[69].callGetProperty(Adapter.InternalAttributes.class), (Object)qualifier);
                                }
                                AnnotationMetadata annotationMetadata = (AnnotationMetadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].call(DefaultAnnotationMetadata.class, this.methodAnnotationMetadata.get(), callSiteArray[71].call(Adapter.class), values), AnnotationMetadata.class);
                                callSiteArray[72].call(this.aopProxyWriter.get(), ArrayUtil.createArray((Object)callSiteArray[73].call(AstGenericUtils.class, callSiteArray[74].callGetProperty((Object)targetMethod)), (Object)callSiteArray[75].callCurrent((GroovyObject)this, (Object)classNode, (Object)targetMethod, (Object)boundTypes), (Object)resolvedReturnType, (Object)resolvedGenericTypes, (Object)callSiteArray[76].callGetProperty((Object)targetMethod), (Object)targetMethodParamsToType, (Object)targetMethodGenericParams, (Object)targetAnnotationMetadata, (Object)targetMethodGenericTypeMap, (Object)annotationMetadata, (Object)callSiteArray[77].call(callSiteArray[78].callGetProperty((Object)targetMethod)), (Object)false));
                            } else {
                                callSiteArray[79].call(this.thisVisitor.get(), (Object)new GStringImpl(new Object[]{callSiteArray[80].callGetProperty(callSiteArray[81].callGetProperty(this.method.get())), callSiteArray[82].callGetProperty(this.method.get()), callSiteArray[83].callGetProperty(callSiteArray[84].callGetProperty((Object)targetMethod)), callSiteArray[85].callGetProperty((Object)targetMethod)}, new String[]{"Cannot adapt method [", ".", "(..)] to target method [", ".", "(..)]. Argument lengths don't match."}), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((MethodNode)this.method.get()), MethodNode.class));
                            }
                        }

                        public /* synthetic */ Object methodMissing(String name, Object args) {
                            CallSite[] callSiteArray = 4.$getCallSiteArray();
                            return this.this$0.this$dist$invoke$3(name, args);
                        }

                        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                            CallSite[] callSiteArray = 4.$getCallSiteArray();
                            return ScriptBytecodeAdapter.invokeMethodN(4.class, InjectVisitor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                        }

                        public /* synthetic */ void propertyMissing(String name, Object val) {
                            CallSite[] callSiteArray = 4.$getCallSiteArray();
                            this.this$0.this$dist$set$3(name, val);
                        }

                        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                            CallSite[] callSiteArray = 4.$getCallSiteArray();
                            Object object = val;
                            ScriptBytecodeAdapter.setProperty((Object)object, null, InjectVisitor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                        }

                        public /* synthetic */ Object propertyMissing(String name) {
                            CallSite[] callSiteArray = 4.$getCallSiteArray();
                            return this.this$0.this$dist$get$3(name);
                        }

                        public static /* synthetic */ Object $static_propertyMissing(String name) {
                            CallSite[] callSiteArray = 4.$getCallSiteArray();
                            return ScriptBytecodeAdapter.getProperty(4.class, InjectVisitor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                        }

                        @Override
                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != 4.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        @Generated
                        public boolean getFirst() {
                            return this.first;
                        }

                        @Generated
                        public boolean isFirst() {
                            return this.first;
                        }

                        @Generated
                        public void setFirst(boolean bl) {
                            this.first = bl;
                        }

                        public /* synthetic */ MetaClass super$5$$getStaticMetaClass() {
                            return super.$getStaticMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "addError";
                            stringArray[1] = "plus";
                            stringArray[2] = "plus";
                            stringArray[3] = "getParameters";
                            stringArray[4] = "getParameters";
                            stringArray[5] = "createGenericsSpec";
                            stringArray[6] = "size";
                            stringArray[7] = "size";
                            stringArray[8] = "<$constructor$>";
                            stringArray[9] = "iterator";
                            stringArray[10] = "getAt";
                            stringArray[11] = "getType";
                            stringArray[12] = "getType";
                            stringArray[13] = "isGenericsPlaceHolder";
                            stringArray[14] = "genericsTypes";
                            stringArray[15] = "name";
                            stringArray[16] = "getAt";
                            stringArray[17] = "containsKey";
                            stringArray[18] = "get";
                            stringArray[19] = "put";
                            stringArray[20] = "resolveTypeReference";
                            stringArray[21] = "isSubclassOfOrImplementsInterface";
                            stringArray[22] = "addError";
                            stringArray[23] = "plus";
                            stringArray[24] = "plus";
                            stringArray[25] = "name";
                            stringArray[26] = "declaringClass";
                            stringArray[27] = "name";
                            stringArray[28] = "name";
                            stringArray[29] = "declaringClass";
                            stringArray[30] = "name";
                            stringArray[31] = "name";
                            stringArray[32] = "name";
                            stringArray[33] = "next";
                            stringArray[34] = "isEmpty";
                            stringArray[35] = "singletonMap";
                            stringArray[36] = "name";
                            stringArray[37] = "visitTypeArguments";
                            stringArray[38] = "isPrimaryClassNode";
                            stringArray[39] = "createGenericsSpec";
                            stringArray[40] = "resolveTypeReference";
                            stringArray[41] = "returnType";
                            stringArray[42] = "buildGenericTypeInfo";
                            stringArray[43] = "returnType";
                            stringArray[44] = "populateParameterData";
                            stringArray[45] = "length";
                            stringArray[46] = "iterator";
                            stringArray[47] = "resolveTypeReference";
                            stringArray[48] = "type";
                            stringArray[49] = "<$constructor$>";
                            stringArray[50] = "putAt";
                            stringArray[51] = "<$constructor$>";
                            stringArray[52] = "toString";
                            stringArray[53] = "putAt";
                            stringArray[54] = "next";
                            stringArray[55] = "mapOf";
                            stringArray[56] = "ADAPTED_BEAN";
                            stringArray[57] = "<$constructor$>";
                            stringArray[58] = "name";
                            stringArray[59] = "concreteClass";
                            stringArray[60] = "ADAPTED_METHOD";
                            stringArray[61] = "name";
                            stringArray[62] = "ADAPTED_ARGUMENT_TYPES";
                            stringArray[63] = "orElse";
                            stringArray[64] = "getValue";
                            stringArray[65] = "getAnnotationMetadata";
                            stringArray[66] = "concreteClass";
                            stringArray[67] = "isNotEmpty";
                            stringArray[68] = "put";
                            stringArray[69] = "ADAPTED_QUALIFIER";
                            stringArray[70] = "mutateMember";
                            stringArray[71] = "getName";
                            stringArray[72] = "visitAroundMethod";
                            stringArray[73] = "resolveTypeReference";
                            stringArray[74] = "declaringClass";
                            stringArray[75] = "resolveReturnType";
                            stringArray[76] = "name";
                            stringArray[77] = "isInterface";
                            stringArray[78] = "declaringClass";
                            stringArray[79] = "addError";
                            stringArray[80] = "name";
                            stringArray[81] = "declaringClass";
                            stringArray[82] = "name";
                            stringArray[83] = "name";
                            stringArray[84] = "declaringClass";
                            stringArray[85] = "name";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[86];
                            4.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(4.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = 4.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    };
                    callSiteArray[28].call((Object)visitor, (Object)((ClassNode)typeToImplement.get()));
                }
            }
        }

        private String generateAdaptedMethodClassName(String declaringClassSimpleName, ClassNode typeToImplement, MethodNode method) {
            String rootName = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)declaringClassSimpleName, (CharSequence)"$"), (CharSequence)typeToImplement.getNameWithoutPackage()), (CharSequence)"$"), (CharSequence)method.getName());
            return StringGroovyMethods.plus((CharSequence)rootName, (Object)this.adaptedMethodIndex.incrementAndGet());
        }

        private void visitTypeArguments(ClassNode typeElement, BeanDefinitionWriter beanDefinitionWriter) {
            Map<String, Map<String, Object>> typeArguments = AstGenericUtils.buildAllGenericTypeInfo(typeElement);
            beanDefinitionWriter.visitTypeArguments(typeArguments);
        }

        private ConstructorNode findConcreteConstructor(List<ConstructorNode> constructors) {
            List<ConstructorNode> nonPrivateConstructors = this.findNonPrivateConstructors(constructors);
            ConstructorNode constructorNode = null;
            if (nonPrivateConstructors.size() == 1) {
                Object object = DefaultGroovyMethods.getAt(nonPrivateConstructors, (int)0);
                constructorNode = (ConstructorNode)ScriptBytecodeAdapter.castToType((Object)object, ConstructorNode.class);
            } else {
                public final class _findConcreteConstructor_closure7
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _findConcreteConstructor_closure7(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ((ConstructorNode)it).getAnnotations(ClassHelper.makeCached(Inject.class));
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _findConcreteConstructor_closure7.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                Object object = DefaultGroovyMethods.find(nonPrivateConstructors, (Closure)new _findConcreteConstructor_closure7((Object)this, (Object)this));
                constructorNode = (ConstructorNode)ScriptBytecodeAdapter.castToType((Object)object, ConstructorNode.class);
                if (!DefaultTypeTransformation.booleanUnbox((Object)constructorNode)) {
                    public final class _findConcreteConstructor_closure8
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _findConcreteConstructor_closure8(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return Modifier.isPublic(((ConstructorNode)it).getModifiers());
                        }

                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _findConcreteConstructor_closure8.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    Object object2 = DefaultGroovyMethods.find(nonPrivateConstructors, (Closure)new _findConcreteConstructor_closure8((Object)this, (Object)this));
                    constructorNode = (ConstructorNode)ScriptBytecodeAdapter.castToType((Object)object2, ConstructorNode.class);
                }
            }
            return constructorNode;
        }

        private void populateParameterData(MethodNode methodNode, Map<String, Object> paramsToType, Map<String, Object> genericParams, Map<String, AnnotationMetadata> anntationMetadata, Map<String, Map<String, Object>> genericTypeMap, Map<String, ClassNode> boundTypes, boolean isConstructBinding) {
            Parameter param = null;
            Parameter[] parameterArray = methodNode.getParameters();
            if (parameterArray != null) {
                int n = parameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    param = parameterArray[n2];
                    ++n2;
                    String parameterName = param.getName();
                    paramsToType.put(parameterName, this.resolveParameterType(param));
                    Object typeRef = AstGenericUtils.resolveTypeReference(param.getType(), boundTypes);
                    genericParams.put(parameterName, typeRef);
                    AnnotationMetadata annotationMetadata = AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, new ExtendedParameter(methodNode, param));
                    if (isConstructBinding && !annotationMetadata.hasStereotype(new Class[]{io.micronaut.context.annotation.Parameter.class, Property.class, Value.class}) && !AstAnnotationUtils.hasStereotype(this.sourceUnit, this.compilationUnit, (AnnotatedNode)param.getType(), Scope.class)) {
                        AnnotationMetadata annotationMetadata2;
                        PropertyMetadata propertyMetadata = this.configurationMetadataBuilder.visitProperty(typeRef instanceof Class ? ShortTypeHandling.castToClass((Object)typeRef).getName() : DefaultGroovyMethods.toString((Object)typeRef), parameterName, null, null);
                        annotationMetadata = annotationMetadata2 = this.addPropertyMetadata(annotationMetadata, propertyMetadata);
                    }
                    anntationMetadata.put(parameterName, annotationMetadata);
                    genericTypeMap.put(parameterName, this.resolveGenericTypes(param, boundTypes));
                }
            }
        }

        private List<ConstructorNode> findNonPrivateConstructors(List<ConstructorNode> constructorNodes) {
            List nonPrivateConstructors = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            ConstructorNode node2 = null;
            for (ConstructorNode node2 : constructorNodes) {
                if (!(!Modifier.isPrivate(node2.getModifiers()))) continue;
                nonPrivateConstructors.add(node2);
            }
            return nonPrivateConstructors;
        }

        private void visitConfigurationBuilder(ClassNode declaringClass, AnnotationMetadata annotationMetadata, ClassNode classNode, BeanDefinitionVisitor writer) {
            Reference declaringClass2 = new Reference((Object)declaringClass);
            Reference writer2 = new Reference((Object)writer);
            Reference allowZeroArgs = new Reference((Object)((Boolean)ScriptBytecodeAdapter.castToType((Object)annotationMetadata.getValue(ConfigurationBuilder.class, "allowZeroArgs", Boolean.class).orElse(false), Boolean.class)));
            Reference prefixes = new Reference(Arrays.asList((Object[])ScriptBytecodeAdapter.castToType((Object)annotationMetadata.getValue(ConfigurationBuilder.class, "prefixes", String[].class).orElse(new String[]{"set"}), Object[].class)));
            public final class _visitConfigurationBuilder_closure9
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _visitConfigurationBuilder_closure9(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object value) {
                    return StringGroovyMethods.plus((String)ShortTypeHandling.castToString((Object)value), (CharSequence)".");
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _visitConfigurationBuilder_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            Reference configurationPrefix = new Reference((Object)ShortTypeHandling.castToString((Object)annotationMetadata.getValue(ConfigurationBuilder.class, String.class).map((Function)ScriptBytecodeAdapter.castToType((Object)((Object)new _visitConfigurationBuilder_closure9((Object)this, (Object)this)), Function.class)).orElse("")));
            Reference includes = new Reference((Object)((Set)ScriptBytecodeAdapter.castToType(annotationMetadata.getValue(ConfigurationBuilder.class, "includes", Set.class).orElse(Collections.emptySet()), Set.class)));
            Reference excludes = new Reference((Object)((Set)ScriptBytecodeAdapter.castToType(annotationMetadata.getValue(ConfigurationBuilder.class, "excludes", Set.class).orElse(Collections.emptySet()), Set.class)));
            Reference source = new Reference((Object)this.sourceUnit);
            PublicMethodVisitor visitor = new PublicMethodVisitor(this, includes, excludes, declaringClass2, configurationPrefix, writer2, source, allowZeroArgs, prefixes, (SourceUnit)source.get()){
                public /* synthetic */ Reference prefixes;
                public /* synthetic */ Reference allowZeroArgs;
                public /* synthetic */ Reference source;
                public /* synthetic */ Reference writer;
                public /* synthetic */ Reference configurationPrefix;
                public /* synthetic */ Reference declaringClass;
                public /* synthetic */ Reference excludes;
                public /* synthetic */ Reference includes;
                public /* synthetic */ InjectVisitor this$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    Reference reference6;
                    Reference reference7;
                    Reference reference8;
                    InjectVisitor injectVisitor;
                    this.this$0 = injectVisitor = p0;
                    super((SourceUnit)ScriptBytecodeAdapter.castToType((Object)p10, SourceUnit.class));
                    this.prefixes = reference8 = p8;
                    this.allowZeroArgs = reference7 = p7;
                    this.source = reference6 = p6;
                    this.writer = reference5 = p5;
                    this.configurationPrefix = reference4 = p4;
                    this.declaringClass = reference3 = p3;
                    this.excludes = reference2 = p2;
                    this.includes = reference = p1;
                }

                @Override
                public void accept(ClassNode cn, MethodNode method) {
                    String name = method.getName();
                    ClassNode returnType = method.getReturnType();
                    Object[] params = method.getParameters();
                    String prefix = this.getMethodPrefix(name);
                    String propertyName = NameUtils.decapitalize((String)name.substring(prefix.length()));
                    if (this.this$0.shouldExclude((Set)ScriptBytecodeAdapter.castToType((Object)this.includes.get(), Set.class), (Set)ScriptBytecodeAdapter.castToType((Object)this.excludes.get(), Set.class), propertyName)) {
                        return;
                    }
                    int paramCount = DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)params, Object[].class)));
                    if (paramCount < 2) {
                        Parameter paramType = (Parameter)ScriptBytecodeAdapter.castToType((Object)(DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)params, Object[].class))) == 1 ? BytecodeInterface8.objectArrayGet((Object[])params, (int)0) : null), Parameter.class);
                        Object expectedType = paramType != null ? AstGenericUtils.resolveTypeReference(paramType.getType()) : null;
                        Object object = expectedType;
                        PropertyMetadata metadata = this.this$0.getConfigurationMetadataBuilder().visitProperty((Object)this.this$0.getConcreteClass(), this.declaringClass.get(), object != null ? DefaultGroovyMethods.toString((Object)object) : null, StringGroovyMethods.plus((String)ShortTypeHandling.castToString((Object)this.configurationPrefix.get()), (CharSequence)propertyName), null, null);
                        ((BeanDefinitionVisitor)this.writer.get()).visitConfigBuilderMethod(prefix, AstGenericUtils.resolveTypeReference(returnType), name, expectedType, (Map)ScriptBytecodeAdapter.castToType(paramType != null ? this.this$0.resolveGenericTypes(paramType) : null, Map.class), metadata.getPath());
                    } else if (paramCount == 2) {
                        Parameter first = (Parameter)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])params, (int)0), Parameter.class);
                        Parameter second = (Parameter)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])params, (int)1), Parameter.class);
                        PropertyMetadata metadata = this.this$0.getConfigurationMetadataBuilder().visitProperty((Object)this.this$0.getConcreteClass(), this.declaringClass.get(), Duration.class.getName(), StringGroovyMethods.plus((String)ShortTypeHandling.castToString((Object)this.configurationPrefix.get()), (CharSequence)propertyName), null, null);
                        if (ScriptBytecodeAdapter.compareEqual((Object)second.getType().getName(), (Object)TimeUnit.class.getName()) && ScriptBytecodeAdapter.compareEqual((Object)first.getType().getName(), (Object)"long")) {
                            ((BeanDefinitionVisitor)this.writer.get()).visitConfigBuilderDurationMethod(prefix, AstGenericUtils.resolveTypeReference(returnType), name, metadata.getPath());
                        }
                    }
                }

                @Override
                protected boolean isAcceptable(MethodNode node) {
                    if (AstAnnotationUtils.hasStereotype((SourceUnit)ScriptBytecodeAdapter.castToType((Object)this.source.get(), SourceUnit.class), this.this$0.compilationUnit, (AnnotatedNode)node, Deprecated.class)) {
                        return false;
                    }
                    int paramCount = DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)node.getParameters(), Object[].class)));
                    return (paramCount > 0 && paramCount < 3 || DefaultTypeTransformation.booleanUnbox((Object)this.allowZeroArgs.get()) && paramCount == 0) && super.isAcceptable(node) && this.isPrefixedWith(node.getName());
                }

                private boolean isPrefixedWith(String name) {
                    String prefix = null;
                    Iterator iterator = ((List)this.prefixes.get()).iterator();
                    while (iterator.hasNext()) {
                        prefix = ShortTypeHandling.castToString(iterator.next());
                        if (!name.startsWith(prefix)) continue;
                        return true;
                    }
                    return false;
                }

                private String getMethodPrefix(String methodName) {
                    String prefix = null;
                    Iterator iterator = ((List)this.prefixes.get()).iterator();
                    while (iterator.hasNext()) {
                        prefix = ShortTypeHandling.castToString(iterator.next());
                        if (!methodName.startsWith(prefix)) continue;
                        return prefix;
                    }
                    return methodName;
                }

                public /* synthetic */ Object methodMissing(String name, Object args) {
                    return this.this$0.this$dist$invoke$3(name, args);
                }

                public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                    return ScriptBytecodeAdapter.invokeMethodN(5.class, InjectVisitor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public /* synthetic */ void propertyMissing(String name, Object val) {
                    this.this$0.this$dist$set$3(name, val);
                }

                public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                    Object object = val;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, InjectVisitor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object propertyMissing(String name) {
                    return this.this$0.this$dist$get$3(name);
                }

                public static /* synthetic */ Object $static_propertyMissing(String name) {
                    return ScriptBytecodeAdapter.getProperty(5.class, InjectVisitor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                @Override
                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != 5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            };
            visitor.accept(classNode);
        }

        private boolean shouldExclude(Set<String> includes, Set<String> excludes, String propertyName) {
            if (!includes.isEmpty() && !includes.contains(propertyName)) {
                return true;
            }
            return !excludes.isEmpty() && excludes.contains(propertyName);
        }

        private boolean shouldExclude(ConfigurationMetadata configurationMetadata, String propertyName) {
            return this.shouldExclude(configurationMetadata.getIncludes(), configurationMetadata.getExcludes(), propertyName);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != InjectVisitor.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(InjectVisitor.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$3(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, InjectVisitor.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object this$dist$get$3(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectProperty(InjectVisitor.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(InjectVisitor.class, InjectTransform.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(InjectVisitor.class, InjectTransform.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, InjectTransform.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, InjectTransform.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(InjectVisitor.class, InjectTransform.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(InjectVisitor.class, InjectTransform.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ ClassNode pfaccess$0(InjectVisitor $that) {
            return $that.getConcreteClass();
        }

        public static /* synthetic */ boolean pfaccess$1(InjectVisitor $that) {
            return $that.getIsConfigurationProperties();
        }

        public static /* synthetic */ boolean pfaccess$2(InjectVisitor $that) {
            return $that.getIsDeclaredBean();
        }

        public static /* synthetic */ ConfigurationMetadataBuilder<ClassNode> pfaccess$3(InjectVisitor $that) {
            return $that.getConfigurationMetadataBuilder();
        }

        @Generated
        public Map<String, Object> resolveGenericTypes(Parameter parameter) {
            return this.resolveGenericTypes(parameter, Collections.emptyMap());
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public final ClassNode getConcreteClass() {
            return this.concreteClass;
        }

        @Generated
        public final AnnotationMetadata getAnnotationMetadata() {
            return this.annotationMetadata;
        }

        @Generated
        public final boolean getIsConfigurationProperties() {
            return this.isConfigurationProperties;
        }

        @Generated
        public final boolean isIsConfigurationProperties() {
            return this.isConfigurationProperties;
        }

        @Generated
        public final boolean getIsFactoryClass() {
            return this.isFactoryClass;
        }

        @Generated
        public final boolean isIsFactoryClass() {
            return this.isFactoryClass;
        }

        @Generated
        public final boolean getIsExecutableType() {
            return this.isExecutableType;
        }

        @Generated
        public final boolean isIsExecutableType() {
            return this.isExecutableType;
        }

        @Generated
        public final boolean getIsAopProxyType() {
            return this.isAopProxyType;
        }

        @Generated
        public final boolean isIsAopProxyType() {
            return this.isAopProxyType;
        }

        @Generated
        public final boolean getIsDeclaredBean() {
            return this.isDeclaredBean;
        }

        @Generated
        public final boolean isIsDeclaredBean() {
            return this.isDeclaredBean;
        }

        @Generated
        public final OptionalValues<Boolean> getAopSettings() {
            return this.aopSettings;
        }

        @Generated
        public final ConfigurationMetadataBuilder<ClassNode> getConfigurationMetadataBuilder() {
            return this.configurationMetadataBuilder;
        }

        @Generated
        public ConfigurationMetadata getConfigurationMetadata() {
            return this.configurationMetadata;
        }

        @Generated
        public void setConfigurationMetadata(ConfigurationMetadata configurationMetadata) {
            this.configurationMetadata = configurationMetadata;
        }

        @Generated
        public final Map<AnnotatedNode, BeanDefinitionVisitor> getBeanDefinitionWriters() {
            return this.beanDefinitionWriters;
        }

        @Generated
        public BeanDefinitionVisitor getAopProxyWriter() {
            return this.aopProxyWriter;
        }

        @Generated
        public void setAopProxyWriter(BeanDefinitionVisitor beanDefinitionVisitor) {
            this.aopProxyWriter = beanDefinitionVisitor;
        }

        @Generated
        public final AtomicInteger getAdaptedMethodIndex() {
            return this.adaptedMethodIndex;
        }

        @Generated
        public final AtomicInteger getFactoryMethodIndex() {
            return this.factoryMethodIndex;
        }

        public /* synthetic */ void super$3$addError(String string, ASTNode aSTNode) {
            super.addError(string, aSTNode);
        }

        public /* synthetic */ void super$3$visitConstructorOrMethod(MethodNode methodNode, boolean bl) {
            super.visitConstructorOrMethod(methodNode, bl);
        }

        public /* synthetic */ void super$3$visitProperty(PropertyNode propertyNode) {
            super.visitProperty(propertyNode);
        }

        public /* synthetic */ void super$3$visitClass(ClassNode classNode) {
            super.visitClass(classNode);
        }

        public /* synthetic */ void super$3$visitField(FieldNode fieldNode) {
            super.visitField(fieldNode);
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "addAnnotation";
            stringArray[1] = "annotate";
            stringArray[2] = "<$constructor$>";
            stringArray[3] = "build";
            stringArray[4] = "builder";
            stringArray[5] = "flatMap";
            stringArray[6] = "getValue";
            stringArray[7] = "isPresent";
            stringArray[8] = "get";
            stringArray[9] = "isInterface";
            stringArray[10] = "packageName";
            stringArray[11] = "nameWithoutPackage";
            stringArray[12] = "generateAdaptedMethodClassName";
            stringArray[13] = "<$constructor$>";
            stringArray[14] = "name";
            stringArray[15] = "EMPTY_OBJECT_ARRAY";
            stringArray[16] = "visitBeanDefinitionConstructor";
            stringArray[17] = "put";
            stringArray[18] = "make";
            stringArray[19] = "plus";
            stringArray[20] = "plus";
            stringArray[21] = "getGenericsTypes";
            stringArray[22] = "<$constructor$>";
            stringArray[23] = "size";
            stringArray[24] = "iterator";
            stringArray[25] = "put";
            stringArray[26] = "name";
            stringArray[27] = "type";
            stringArray[28] = "accept";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[29];
            InjectVisitor.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(InjectVisitor.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = InjectVisitor.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        public final class _closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference sourceUnit;
            private /* synthetic */ Reference compilationUnit;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _closure1(Object _outerInstance, Object _thisObject, Reference sourceUnit, Reference compilationUnit) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.sourceUnit = reference2 = sourceUnit;
                this.compilationUnit = reference = compilationUnit;
            }

            public Object doCall(Object it) {
                AnnotationMetadata constructorMetadata = AstAnnotationUtils.getAnnotationMetadata((SourceUnit)ScriptBytecodeAdapter.castToType((Object)this.sourceUnit.get(), SourceUnit.class), (CompilationUnit)ScriptBytecodeAdapter.castToType((Object)this.compilationUnit.get(), CompilationUnit.class), (AnnotatedNode)ScriptBytecodeAdapter.castToType((Object)it, AnnotatedNode.class));
                return constructorMetadata.hasStereotype(Inject.class);
            }

            public SourceUnit getSourceUnit() {
                return (SourceUnit)ScriptBytecodeAdapter.castToType((Object)this.sourceUnit.get(), SourceUnit.class);
            }

            public CompilationUnit getCompilationUnit() {
                return (CompilationUnit)ScriptBytecodeAdapter.castToType((Object)this.compilationUnit.get(), CompilationUnit.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
    }
}

