/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import groovy.lang.GroovyClassLoader;
import io.micronaut.ast.groovy.utils.AstAnnotationUtils;
import io.micronaut.ast.groovy.utils.InMemoryByteCodeGroovyClassLoader;
import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.io.scan.ClassPathAnnotationScanner;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.DirectoryClassWriterOutputVisitor;
import io.micronaut.inject.writer.GeneratedFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;

public class GroovyVisitorContext
implements VisitorContext {
    private static final MutableConvertibleValues<Object> VISITOR_ATTRIBUTES = new MutableConvertibleValuesMap();
    private final ErrorCollector errorCollector;
    private final CompilationUnit compilationUnit;
    private final SourceUnit sourceUnit;
    private final MutableConvertibleValues<Object> attributes;

    public GroovyVisitorContext(SourceUnit sourceUnit, @Nullable CompilationUnit compilationUnit) {
        this.sourceUnit = sourceUnit;
        this.errorCollector = sourceUnit.getErrorCollector();
        this.compilationUnit = compilationUnit;
        this.attributes = VISITOR_ATTRIBUTES;
    }

    @Nonnull
    public Iterable<URL> getClasspathResources(@Nonnull String path) {
        try {
            Enumeration resources = this.compilationUnit.getClassLoader().getResources(path);
            return CollectionUtils.enumerationToIterable((Enumeration)resources);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public Optional<ClassElement> getClassElement(String name) {
        if (name == null || this.compilationUnit == null) {
            return Optional.empty();
        }
        ClassNode classNode = Optional.ofNullable(this.compilationUnit.getClassNode(name)).orElseGet(() -> {
            GroovyClassLoader classLoader;
            if (this.sourceUnit != null && (classLoader = this.sourceUnit.getClassLoader()) != null) {
                return ClassUtils.forName((String)name, (ClassLoader)classLoader).map(ClassHelper::make).orElse(null);
            }
            return null;
        });
        return Optional.ofNullable(classNode).map(cn -> new GroovyClassElement(this.sourceUnit, this.compilationUnit, (ClassNode)cn, AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)cn)));
    }

    public Optional<ClassElement> getClassElement(Class<?> type) {
        ClassNode classNode = ClassHelper.makeCached(type);
        AnnotationMetadata annotationMetadata = AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)classNode);
        GroovyClassElement classElement = new GroovyClassElement(this.sourceUnit, this.compilationUnit, classNode, annotationMetadata);
        return Optional.of(classElement);
    }

    @Nonnull
    public ClassElement[] getClassElements(@Nonnull String aPackage, String ... stereotypes) {
        ArgumentUtils.requireNonNull((String)"aPackage", (Object)aPackage);
        ArgumentUtils.requireNonNull((String)"stereotypes", (Object)stereotypes);
        if (this.compilationUnit == null) {
            return new ClassElement[0];
        }
        ClassPathAnnotationScanner scanner = new ClassPathAnnotationScanner((ClassLoader)this.compilationUnit.getClassLoader());
        ArrayList classElements = new ArrayList();
        for (String s : stereotypes) {
            scanner.scan(s, aPackage).forEach(aClass -> {
                ClassNode classNode = ClassHelper.make((Class)aClass);
                classElements.add(new GroovyClassElement(this.sourceUnit, this.compilationUnit, classNode, AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)classNode)));
            });
        }
        return classElements.toArray(new ClassElement[0]);
    }

    public void info(String message, @Nullable Element element) {
        StringBuilder msg = new StringBuilder("Note: ").append(message);
        if (element != null) {
            ASTNode expr = (ASTNode)element.getNativeType();
            String sample = this.sourceUnit.getSample(expr.getLineNumber(), expr.getColumnNumber(), new Janitor());
            msg.append("\n\n").append(sample);
        }
        System.out.println(msg.toString());
    }

    public void info(String message) {
        System.out.println("Note: " + message);
    }

    public void fail(String message, @Nullable Element element) {
        Object msg = element != null ? this.buildErrorMessage(message, element) : new SimpleMessage(message, (ProcessingUnit)this.sourceUnit);
        this.errorCollector.addError((Message)msg);
    }

    public void warn(String message, @Nullable Element element) {
        StringBuilder msg = new StringBuilder("WARNING: ").append(message);
        if (element != null) {
            ASTNode expr = (ASTNode)element.getNativeType();
            String sample = this.sourceUnit.getSample(expr.getLineNumber(), expr.getColumnNumber(), new Janitor());
            msg.append("\n\n").append(sample);
        }
        System.out.println(msg.toString());
    }

    public OutputStream visitClass(final String classname) throws IOException {
        File classesDir = this.compilationUnit.getConfiguration().getTargetDirectory();
        if (classesDir != null) {
            DirectoryClassWriterOutputVisitor outputVisitor = new DirectoryClassWriterOutputVisitor(classesDir);
            return outputVisitor.visitClass(classname);
        }
        if (this.compilationUnit.getClassLoader() instanceof InMemoryByteCodeGroovyClassLoader) {
            return new OutputStream(){

                @Override
                public void write(int b) {
                }

                @Override
                public void write(byte[] b) {
                    ((InMemoryByteCodeGroovyClassLoader)GroovyVisitorContext.this.compilationUnit.getClassLoader()).addClass(classname, b);
                }
            };
        }
        return new ByteArrayOutputStream();
    }

    public void visitServiceDescriptor(String type, String classname) {
        File classesDir = this.compilationUnit.getConfiguration().getTargetDirectory();
        if (classesDir != null) {
            DirectoryClassWriterOutputVisitor outputVisitor = new DirectoryClassWriterOutputVisitor(classesDir);
            outputVisitor.visitServiceDescriptor(type, classname);
            outputVisitor.finish();
        }
    }

    public Optional<GeneratedFile> visitMetaInfFile(String path) {
        File classesDir = this.compilationUnit.getConfiguration().getTargetDirectory();
        if (classesDir != null) {
            DirectoryClassWriterOutputVisitor outputVisitor = new DirectoryClassWriterOutputVisitor(classesDir);
            return outputVisitor.visitMetaInfFile(path);
        }
        return Optional.empty();
    }

    public Optional<GeneratedFile> visitGeneratedFile(String path) {
        File classesDir = this.compilationUnit.getConfiguration().getTargetDirectory();
        if (classesDir != null) {
            DirectoryClassWriterOutputVisitor outputVisitor = new DirectoryClassWriterOutputVisitor(classesDir);
            return outputVisitor.visitGeneratedFile(path);
        }
        return Optional.empty();
    }

    public void finish() {
    }

    SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    private SyntaxErrorMessage buildErrorMessage(String message, Element element) {
        ASTNode expr = (ASTNode)element.getNativeType();
        return new SyntaxErrorMessage(new SyntaxException(message + '\n', expr.getLineNumber(), expr.getColumnNumber(), expr.getLastLineNumber(), expr.getLastColumnNumber()), this.sourceUnit);
    }

    public MutableConvertibleValues<Object> put(CharSequence key, @Nullable Object value) {
        return this.attributes.put(key, value);
    }

    public MutableConvertibleValues<Object> remove(CharSequence key) {
        return this.attributes.remove(key);
    }

    public MutableConvertibleValues<Object> clear() {
        return this.attributes.clear();
    }

    public Set<String> names() {
        return this.attributes.names();
    }

    public Collection<Object> values() {
        return this.attributes.values();
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        return this.attributes.get(name, conversionContext);
    }
}

