/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.ast.groovy.utils.AstAnnotationUtils;
import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.ast.groovy.visitor.GroovyEnumElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.PrimitiveElement;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

public abstract class AbstractGroovyElement
implements AnnotationMetadataDelegate,
Element {
    protected final SourceUnit sourceUnit;
    protected final CompilationUnit compilationUnit;
    private final AnnotatedNode annotatedNode;
    private AnnotationMetadata annotationMetadata;

    public AbstractGroovyElement(SourceUnit sourceUnit, CompilationUnit compilationUnit, AnnotatedNode annotatedNode, AnnotationMetadata annotationMetadata) {
        this.compilationUnit = compilationUnit;
        this.annotatedNode = annotatedNode;
        this.annotationMetadata = annotationMetadata;
        this.sourceUnit = sourceUnit;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    public <T extends Annotation> Element annotate(@NonNull String annotationType, @NonNull Consumer<AnnotationValueBuilder<T>> consumer) {
        ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
        AnnotationValueBuilder builder = AnnotationValue.builder((String)annotationType);
        if (consumer != null) {
            consumer.accept(builder);
            AnnotationValue av = builder.build();
            this.annotationMetadata = DefaultAnnotationMetadata.mutateMember((AnnotationMetadata)this.annotationMetadata, (String)av.getAnnotationName(), (Map)av.getValues());
            String declaringTypeName = this instanceof MemberElement ? ((MemberElement)this).getOwningType().getName() : this.getName();
            AbstractAnnotationMetadataBuilder.addMutatedMetadata((String)declaringTypeName, (Object)this.annotatedNode, (AnnotationMetadata)this.annotationMetadata);
            AstAnnotationUtils.invalidateCache(this.annotatedNode);
        }
        return this;
    }

    protected Map<String, ClassNode> alignNewGenericsInfo(@NonNull GenericsType[] genericsTypes, @NonNull GenericsType[] redirectTypes, @NonNull Map<String, ClassNode> genericsSpec) {
        if (redirectTypes.length != genericsTypes.length) {
            return Collections.emptyMap();
        }
        HashMap<String, ClassNode> newSpec = new HashMap<String, ClassNode>(genericsSpec.size());
        for (int i = 0; i < genericsTypes.length; ++i) {
            GenericsType genericsType = genericsTypes[i];
            GenericsType redirectType = redirectTypes[i];
            String name = genericsType.getName();
            if (genericsType.isWildcard()) {
                Object[] upperBounds = genericsType.getUpperBounds();
                if (ArrayUtils.isNotEmpty((Object[])upperBounds)) {
                    name = upperBounds[0].getUnresolvedName();
                } else {
                    ClassNode lowerBound = genericsType.getLowerBound();
                    if (lowerBound != null) {
                        name = lowerBound.getUnresolvedName();
                    }
                }
            }
            ClassNode cn = genericsSpec.get(name);
            this.toNewGenericSpec(genericsSpec, newSpec, redirectType.getName(), cn);
        }
        return newSpec;
    }

    private void toNewGenericSpec(Map<String, ClassNode> genericsSpec, Map<String, ClassNode> newSpec, String name, ClassNode cn) {
        if (cn != null) {
            if (cn.isGenericsPlaceHolder()) {
                String n = cn.getUnresolvedName();
                ClassNode resolved = genericsSpec.get(n);
                this.toNewGenericSpec(genericsSpec, newSpec, name, resolved);
            } else {
                newSpec.put(name, cn);
            }
        }
    }

    @NonNull
    protected ClassElement getGenericElement(@NonNull SourceUnit sourceUnit, @NonNull ClassNode type, @NonNull ClassElement rawElement, @NonNull Map<String, ClassNode> genericsSpec) {
        if (CollectionUtils.isNotEmpty(genericsSpec)) {
            ClassElement classNode = this.resolveGenericType(sourceUnit, genericsSpec, type);
            if (classNode != null) {
                return classNode;
            }
            GenericsType[] genericsTypes = type.getGenericsTypes();
            GenericsType[] redirectTypes = type.redirect().getGenericsTypes();
            if (genericsTypes != null && redirectTypes != null) {
                genericsSpec = this.alignNewGenericsInfo(genericsTypes, redirectTypes, genericsSpec);
                AnnotationMetadata annotationMetadata = AstAnnotationUtils.getAnnotationMetadata(sourceUnit, this.compilationUnit, (AnnotatedNode)type);
                return new GroovyClassElement(sourceUnit, this.compilationUnit, type, annotationMetadata, Collections.singletonMap(type.getName(), genericsSpec), 0);
            }
        }
        return rawElement;
    }

    public static ClassElement toClassElement(SourceUnit sourceUnit, CompilationUnit compilationUnit, ClassNode classNode, AnnotationMetadata annotationMetadata) {
        if (classNode.isArray()) {
            ClassNode componentType = classNode.getComponentType();
            ClassElement componentElement = AbstractGroovyElement.toClassElement(sourceUnit, compilationUnit, componentType, annotationMetadata);
            return componentElement.toArray();
        }
        if (ClassHelper.isPrimitiveType((ClassNode)classNode)) {
            return PrimitiveElement.valueOf((String)classNode.getName());
        }
        if (classNode.isEnum()) {
            return new GroovyEnumElement(sourceUnit, compilationUnit, classNode, AstAnnotationUtils.getAnnotationMetadata(sourceUnit, compilationUnit, (AnnotatedNode)classNode));
        }
        return new GroovyClassElement(sourceUnit, compilationUnit, classNode, annotationMetadata);
    }

    private ClassElement resolveGenericType(@NonNull SourceUnit sourceUnit, Map<String, ClassNode> typeGenericInfo, ClassNode returnType) {
        String unresolvedName;
        ClassNode classNode;
        if (returnType.isGenericsPlaceHolder() && (classNode = typeGenericInfo.get(unresolvedName = returnType.getUnresolvedName())) != null) {
            if (classNode.isGenericsPlaceHolder()) {
                return this.resolveGenericType(sourceUnit, typeGenericInfo, classNode);
            }
            return AbstractGroovyElement.toClassElement(sourceUnit, this.compilationUnit, classNode, AstAnnotationUtils.getAnnotationMetadata(sourceUnit, this.compilationUnit, (AnnotatedNode)classNode));
        }
        return null;
    }
}

