/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.ast.groovy.annotation.GroovyAnnotationMetadataBuilder;
import io.micronaut.ast.groovy.utils.AstAnnotationUtils;
import io.micronaut.ast.groovy.utils.AstClassUtils;
import io.micronaut.ast.groovy.utils.AstGenericUtils;
import io.micronaut.ast.groovy.utils.PublicMethodVisitor;
import io.micronaut.ast.groovy.visitor.AbstractGroovyElement;
import io.micronaut.ast.groovy.visitor.GroovyConstructorElement;
import io.micronaut.ast.groovy.visitor.GroovyMethodElement;
import io.micronaut.ast.groovy.visitor.GroovyPropertyElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ArrayableClassElement;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

@Internal
public class GroovyClassElement
extends AbstractGroovyElement
implements ArrayableClassElement {
    protected final ClassNode classNode;
    private final int arrayDimensions;
    private Map<String, Map<String, ClassNode>> genericInfo;

    GroovyClassElement(SourceUnit sourceUnit, CompilationUnit compilationUnit, ClassNode classNode, AnnotationMetadata annotationMetadata) {
        this(sourceUnit, compilationUnit, classNode, annotationMetadata, null, 0);
    }

    GroovyClassElement(SourceUnit sourceUnit, CompilationUnit compilationUnit, ClassNode classNode, AnnotationMetadata annotationMetadata, Map<String, Map<String, ClassNode>> genericInfo, int arrayDimensions) {
        super(sourceUnit, compilationUnit, (AnnotatedNode)classNode, annotationMetadata);
        this.classNode = classNode;
        this.genericInfo = genericInfo;
        this.arrayDimensions = arrayDimensions;
    }

    public boolean isInner() {
        return this.classNode instanceof InnerClassNode;
    }

    public boolean isInterface() {
        return this.classNode.isInterface();
    }

    public boolean isPrimitive() {
        return false;
    }

    public Optional<ClassElement> getSuperType() {
        ClassNode superClass = this.classNode.getSuperClass();
        if (superClass != null && !superClass.equals((Object)ClassHelper.OBJECT_TYPE)) {
            return Optional.of(GroovyClassElement.toClassElement(this.sourceUnit, this.compilationUnit, superClass, AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)superClass)));
        }
        return Optional.empty();
    }

    @NonNull
    public Optional<MethodElement> getPrimaryConstructor() {
        MethodNode method = this.findStaticCreator();
        if (method == null) {
            method = this.findConcreteConstructor();
        }
        return this.createMethodElement(method);
    }

    @NonNull
    public Optional<MethodElement> getDefaultConstructor() {
        MethodNode method = this.findDefaultStaticCreator();
        if (method == null) {
            method = this.findDefaultConstructor();
        }
        return this.createMethodElement(method);
    }

    private Optional<MethodElement> createMethodElement(MethodNode method) {
        return Optional.ofNullable(method).map(executableElement -> {
            AnnotationMetadata annotationMetadata = AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)executableElement);
            if (executableElement instanceof ConstructorNode) {
                return new GroovyConstructorElement(this, this.sourceUnit, this.compilationUnit, (ConstructorNode)executableElement, annotationMetadata);
            }
            return new GroovyMethodElement(this, this.sourceUnit, this.compilationUnit, (MethodNode)executableElement, annotationMetadata);
        });
    }

    public Map<String, Map<String, ClassNode>> getGenericTypeInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = AstGenericUtils.buildAllGenericElementInfo(this.classNode, new GroovyVisitorContext(this.sourceUnit, this.compilationUnit));
        }
        return this.genericInfo;
    }

    @NonNull
    public Map<String, ClassElement> getTypeArguments(@NonNull String type) {
        Map<String, Map<String, ClassNode>> allData = this.getGenericTypeInfo();
        Map<String, ClassNode> thisSpec = allData.get(this.getName());
        Map<String, ClassNode> forType = allData.get(type);
        if (forType != null) {
            LinkedHashMap<String, ClassElement> typeArgs = new LinkedHashMap<String, ClassElement>(forType.size());
            for (Map.Entry<String, ClassNode> entry : forType.entrySet()) {
                ClassNode classNode = entry.getValue();
                ClassElement rawElement = GroovyClassElement.toClassElement(this.sourceUnit, this.compilationUnit, classNode, AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)classNode));
                if (thisSpec != null) {
                    rawElement = this.getGenericElement(this.sourceUnit, classNode, rawElement, thisSpec);
                }
                typeArgs.put(entry.getKey(), rawElement);
            }
            return Collections.unmodifiableMap(typeArgs);
        }
        return Collections.emptyMap();
    }

    @NonNull
    public Map<String, ClassElement> getTypeArguments() {
        Map<String, ClassNode> spec;
        GenericsType[] genericsTypes;
        Map<String, Map<String, ClassNode>> genericInfo = this.getGenericTypeInfo();
        Map<String, ClassNode> info = genericInfo.get(this.classNode.getName());
        if (info != null && (genericsTypes = this.classNode.redirect().getGenericsTypes()) != null) {
            HashMap<String, ClassElement> typeArgumentMap = new HashMap<String, ClassElement>(genericsTypes.length);
            for (GenericsType gt : genericsTypes) {
                String name = gt.getName();
                ClassNode cn = info.get(name);
                while (cn != null && cn.isGenericsPlaceHolder()) {
                    name = cn.getUnresolvedName();
                    cn = info.get(name);
                }
                if (cn == null) continue;
                typeArgumentMap.put(name, GroovyClassElement.toClassElement(this.sourceUnit, this.compilationUnit, cn, AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)cn)));
            }
            if (CollectionUtils.isNotEmpty(typeArgumentMap)) {
                return typeArgumentMap;
            }
        }
        if (!(spec = AstGenericUtils.createGenericsSpec(this.classNode)).isEmpty()) {
            LinkedHashMap map = new LinkedHashMap(spec.size());
            for (Map.Entry entry : spec.entrySet()) {
                ClassNode cn = (ClassNode)entry.getValue();
                ClassElement classElement = GroovyClassElement.toClassElement(this.sourceUnit, this.compilationUnit, cn, AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)cn));
                map.put(entry.getKey(), classElement);
            }
            return Collections.unmodifiableMap(map);
        }
        return Collections.emptyMap();
    }

    public List<PropertyElement> getBeanProperties() {
        List propertyNodes = this.classNode.getProperties();
        ArrayList<GroovyPropertyElement> propertyElements = new ArrayList<GroovyPropertyElement>();
        final HashSet<String> groovyProps = new HashSet<String>();
        for (final PropertyNode propertyNode : propertyNodes) {
            if (!propertyNode.isPublic() || propertyNode.isStatic()) continue;
            groovyProps.add(propertyNode.getName());
            boolean readOnly = propertyNode.getField().isFinal();
            GroovyPropertyElement groovyPropertyElement = new GroovyPropertyElement(this.sourceUnit, this.compilationUnit, this, (AnnotatedNode)propertyNode.getField(), AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)propertyNode.getField()), propertyNode.getName(), readOnly, propertyNode){

                @NonNull
                public ClassElement getType() {
                    ClassNode type = propertyNode.getType();
                    return 1.toClassElement(this.sourceUnit, this.compilationUnit, type, AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)type));
                }
            };
            propertyElements.add(groovyPropertyElement);
        }
        final LinkedHashMap props = new LinkedHashMap();
        for (ClassNode classNode = this.classNode; classNode != null && !classNode.equals((Object)ClassHelper.OBJECT_TYPE) && !classNode.equals((Object)ClassHelper.Enum_Type); classNode = classNode.getSuperClass()) {
            classNode.visitContents((GroovyClassVisitor)new PublicMethodVisitor(null){

                @Override
                protected boolean isAcceptable(MethodNode node) {
                    boolean validModifiers;
                    boolean bl = validModifiers = node.isPublic() && !node.isStatic() && !node.isSynthetic() && !node.isAbstract();
                    if (validModifiers) {
                        String methodName = node.getName();
                        if (methodName.contains("$") || methodName.equals("getMetaClass")) {
                            return false;
                        }
                        if (NameUtils.isGetterName((String)methodName) && node.getParameters().length == 0) {
                            return true;
                        }
                        return NameUtils.isSetterName((String)methodName) && node.getParameters().length == 1;
                    }
                    return validModifiers;
                }

                @Override
                public void accept(ClassNode classNode, MethodNode node) {
                    String methodName = node.getName();
                    ClassNode declaringTypeElement = node.getDeclaringClass();
                    if (NameUtils.isGetterName((String)methodName) && node.getParameters().length == 0) {
                        ClassNode typeMirror;
                        ClassElement setterParameterType;
                        String propertyName = NameUtils.getPropertyNameForGetter((String)methodName);
                        if (groovyProps.contains(propertyName)) {
                            return;
                        }
                        ClassNode returnTypeNode = node.getReturnType();
                        ClassElement getterReturnType = null;
                        if (returnTypeNode.isGenericsPlaceHolder()) {
                            String placeHolderName = returnTypeNode.getUnresolvedName();
                            ClassElement classElement = GroovyClassElement.this.getTypeArguments().get(placeHolderName);
                            if (classElement != null) {
                                getterReturnType = classElement;
                            }
                        }
                        if (getterReturnType == null) {
                            getterReturnType = AbstractGroovyElement.toClassElement(GroovyClassElement.this.sourceUnit, GroovyClassElement.this.compilationUnit, returnTypeNode, AnnotationMetadata.EMPTY_METADATA);
                        }
                        GetterAndSetter getterAndSetter = props.computeIfAbsent(propertyName, x$0 -> new GetterAndSetter((String)x$0));
                        this.configureDeclaringType(declaringTypeElement, getterAndSetter);
                        getterAndSetter.type = getterReturnType;
                        getterAndSetter.getter = node;
                        if (getterAndSetter.setter != null && !(setterParameterType = AbstractGroovyElement.toClassElement(GroovyClassElement.this.sourceUnit, GroovyClassElement.this.compilationUnit, typeMirror = getterAndSetter.setter.getParameters()[0].getType(), AnnotationMetadata.EMPTY_METADATA)).getName().equals(getterReturnType.getName())) {
                            getterAndSetter.setter = null;
                        }
                    } else if (NameUtils.isSetterName((String)methodName) && node.getParameters().length == 1) {
                        String propertyName = NameUtils.getPropertyNameForSetter((String)methodName);
                        if (groovyProps.contains(propertyName)) {
                            return;
                        }
                        ClassNode typeMirror = node.getParameters()[0].getType();
                        ClassElement setterParameterType = AbstractGroovyElement.toClassElement(GroovyClassElement.this.sourceUnit, GroovyClassElement.this.compilationUnit, typeMirror, AnnotationMetadata.EMPTY_METADATA);
                        GetterAndSetter getterAndSetter = props.computeIfAbsent(propertyName, x$0 -> new GetterAndSetter((String)x$0));
                        this.configureDeclaringType(declaringTypeElement, getterAndSetter);
                        ClassElement propertyType = getterAndSetter.type;
                        if (propertyType != null) {
                            if (propertyType.getName().equals(setterParameterType.getName())) {
                                getterAndSetter.setter = node;
                            }
                        } else {
                            getterAndSetter.setter = node;
                        }
                    }
                }

                private void configureDeclaringType(ClassNode declaringTypeElement, GetterAndSetter beanPropertyData) {
                    if (beanPropertyData.declaringType == null && !GroovyClassElement.this.classNode.equals((Object)declaringTypeElement)) {
                        beanPropertyData.declaringType = new GroovyClassElement(GroovyClassElement.this.sourceUnit, GroovyClassElement.this.compilationUnit, declaringTypeElement, AstAnnotationUtils.getAnnotationMetadata(GroovyClassElement.this.sourceUnit, GroovyClassElement.this.compilationUnit, (AnnotatedNode)declaringTypeElement));
                    }
                }
            });
        }
        if (!props.isEmpty()) {
            final GroovyClassElement thisElement = this;
            for (Map.Entry entry : props.entrySet()) {
                String propertyName = (String)entry.getKey();
                final GetterAndSetter value = (GetterAndSetter)entry.getValue();
                if (value.getter == null) continue;
                final GroovyAnnotationMetadataBuilder groovyAnnotationMetadataBuilder = new GroovyAnnotationMetadataBuilder(this.sourceUnit, this.compilationUnit);
                FieldNode field = this.classNode.getField(propertyName);
                final AnnotationMetadata annotationMetadata = field != null ? AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)field, (AnnotatedNode)value.getter) : groovyAnnotationMetadataBuilder.buildForMethod(value.getter);
                GroovyPropertyElement propertyElement = new GroovyPropertyElement(this.sourceUnit, this.compilationUnit, value.declaringType == null ? this : value.declaringType, (AnnotatedNode)value.getter, annotationMetadata, propertyName, value.setter == null, value.getter){

                    public Optional<MethodElement> getWriteMethod() {
                        if (value.setter != null) {
                            return Optional.of(new GroovyMethodElement(thisElement, this.sourceUnit, this.compilationUnit, value.setter, groovyAnnotationMetadataBuilder.buildForMethod(value.setter)));
                        }
                        return Optional.empty();
                    }

                    @NonNull
                    public ClassElement getType() {
                        return value.type;
                    }

                    public Optional<MethodElement> getReadMethod() {
                        return Optional.of(new GroovyMethodElement(thisElement, this.sourceUnit, this.compilationUnit, value.getter, annotationMetadata));
                    }
                };
                propertyElements.add(propertyElement);
            }
        }
        return Collections.unmodifiableList(propertyElements);
    }

    public boolean isArray() {
        return this.arrayDimensions > 0;
    }

    public ClassElement withArrayDimensions(int arrayDimensions) {
        return new GroovyClassElement(this.sourceUnit, this.compilationUnit, this.classNode, this.getAnnotationMetadata(), this.getGenericTypeInfo(), arrayDimensions);
    }

    public int getArrayDimensions() {
        return this.arrayDimensions;
    }

    public String toString() {
        return this.classNode.getName();
    }

    public String getName() {
        return this.classNode.getName();
    }

    public boolean isAbstract() {
        return this.classNode.isAbstract();
    }

    public boolean isStatic() {
        return this.classNode.isStaticClass();
    }

    public boolean isPublic() {
        return this.classNode.isSyntheticPublic() || Modifier.isPublic(this.classNode.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.classNode.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.classNode.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.classNode.getModifiers());
    }

    public Object getNativeType() {
        return this.classNode;
    }

    public boolean isAssignable(String type) {
        return AstClassUtils.isSubclassOfOrImplementsInterface(this.classNode, type);
    }

    private MethodNode findConcreteConstructor() {
        MethodNode methodNode;
        List constructors = this.classNode.getDeclaredConstructors();
        if (CollectionUtils.isEmpty((Collection)constructors) && !this.classNode.isAbstract() && !this.classNode.isEnum()) {
            return new ConstructorNode(1, (Statement)new BlockStatement());
        }
        List nonPrivateConstructors = this.findNonPrivateMethods(constructors);
        if (nonPrivateConstructors.size() == 1) {
            methodNode = (MethodNode)nonPrivateConstructors.get(0);
        } else {
            methodNode = nonPrivateConstructors.stream().filter(cn -> !cn.getAnnotations(ClassHelper.makeCached(Inject.class)).isEmpty() || !cn.getAnnotations(ClassHelper.makeCached(Creator.class)).isEmpty()).findFirst().orElse(null);
            if (methodNode == null) {
                methodNode = nonPrivateConstructors.stream().filter(cn -> Modifier.isPublic(cn.getModifiers())).findFirst().orElse(null);
            }
        }
        return methodNode;
    }

    private MethodNode findDefaultConstructor() {
        List constructors = this.classNode.getDeclaredConstructors();
        if (CollectionUtils.isEmpty((Collection)constructors) && !this.classNode.isEnum()) {
            return new ConstructorNode(1, (Statement)new BlockStatement());
        }
        if ((constructors = this.findNonPrivateMethods(constructors).stream().filter(ctor -> ctor.getParameters().length == 0).collect(Collectors.toList())).isEmpty()) {
            return null;
        }
        if (constructors.size() == 1) {
            return (MethodNode)constructors.get(0);
        }
        return constructors.stream().filter(method -> Modifier.isPublic(method.getModifiers())).findFirst().orElse(null);
    }

    private MethodNode findStaticCreator() {
        List<Object> creators = this.findNonPrivateStaticCreators();
        if (creators.isEmpty()) {
            return null;
        }
        if (creators.size() == 1) {
            return creators.get(0);
        }
        List withArgs = creators.stream().filter(method -> method.getParameters().length > 0).collect(Collectors.toList());
        if (withArgs.size() == 1) {
            return (MethodNode)withArgs.get(0);
        }
        creators = withArgs;
        return creators.stream().filter(method -> Modifier.isPublic(method.getModifiers())).findFirst().orElse(null);
    }

    private MethodNode findDefaultStaticCreator() {
        List creators = this.findNonPrivateStaticCreators().stream().filter(ctor -> ctor.getParameters().length == 0).collect(Collectors.toList());
        if (creators.isEmpty()) {
            return null;
        }
        if (creators.size() == 1) {
            return (MethodNode)creators.get(0);
        }
        return creators.stream().filter(method -> Modifier.isPublic(method.getModifiers())).findFirst().orElse(null);
    }

    private <T extends MethodNode> List<T> findNonPrivateMethods(List<T> methodNodes) {
        ArrayList<MethodNode> nonPrivateMethods = new ArrayList<MethodNode>(2);
        for (MethodNode node : methodNodes) {
            if (Modifier.isPrivate(node.getModifiers())) continue;
            nonPrivateMethods.add(node);
        }
        return nonPrivateMethods;
    }

    private List<MethodNode> findNonPrivateStaticCreators() {
        List<Object> creators = this.classNode.getAllDeclaredMethods().stream().filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> !Modifier.isPrivate(method.getModifiers())).filter(method -> method.getReturnType().equals((Object)this.classNode)).filter(method -> method.getAnnotations(ClassHelper.makeCached(Creator.class)).size() > 0).collect(Collectors.toList());
        if (creators.isEmpty() && this.classNode.isEnum()) {
            creators = this.classNode.getAllDeclaredMethods().stream().filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> !Modifier.isPrivate(method.getModifiers())).filter(method -> method.getReturnType().equals((Object)this.classNode)).filter(method -> method.getName().equals("valueOf")).collect(Collectors.toList());
        }
        return creators;
    }

    private class GetterAndSetter {
        ClassElement type;
        GroovyClassElement declaringType;
        MethodNode getter;
        MethodNode setter;
        final String propertyName;

        GetterAndSetter(String propertyName) {
            this.propertyName = propertyName;
        }
    }
}

