/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.utils;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import io.micronaut.ast.groovy.utils.AstAnnotationUtils;
import io.micronaut.core.annotation.Internal;
import java.beans.Transient;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;

public class AstUtils
implements GroovyObject {
    public static final Parameter[] ZERO_PARAMETERS;
    public static final ClassNode[] EMPTY_CLASS_ARRAY;
    public static final ClassNode INTERNAL_ANNOTATION;
    public static final ClassNode INJECT_ANNOTATION;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public AstUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static Parameter[] copyParameters(Parameter ... parameterTypes) {
        return AstUtils.copyParameters(parameterTypes, null);
    }

    public static Parameter[] copyParameters(Parameter[] parameterTypes, Map<String, ClassNode> genericsPlaceholders) {
        Object[] newParameterTypes = new Parameter[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            Parameter parameterType = (Parameter)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])parameterTypes, (int)i), Parameter.class);
            Parameter newParameter = new Parameter(AstUtils.replaceGenericsPlaceholders(parameterType.getType(), genericsPlaceholders), parameterType.getName(), parameterType.getInitialExpression());
            AstAnnotationUtils.copyAnnotations((AnnotatedNode)parameterType, (AnnotatedNode)newParameter);
            Parameter parameter = newParameter;
            BytecodeInterface8.objectArraySet((Object[])newParameterTypes, (int)i, (Object)parameter);
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return newParameterTypes;
    }

    public static Parameter[] copyParameters(Map<String, ClassNode> genericsSpec, Parameter[] parameterTypes, List<String> currentMethodGenPlaceholders) {
        Object[] newParameterTypes = new Parameter[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            Parameter parameterType = (Parameter)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])parameterTypes, (int)i), Parameter.class);
            ClassNode newParamType = GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, (ClassNode)parameterType.getType(), currentMethodGenPlaceholders);
            Parameter newParameter = new Parameter(newParamType, parameterType.getName(), parameterType.getInitialExpression());
            newParameter.addAnnotations(parameterType.getAnnotations());
            Parameter parameter = newParameter;
            BytecodeInterface8.objectArraySet((Object[])newParameterTypes, (int)i, (Object)parameter);
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return newParameterTypes;
    }

    public static ClassNode replaceGenericsPlaceholders(ClassNode type, Map<String, ClassNode> genericsPlaceholders) {
        return AstUtils.replaceGenericsPlaceholders(type, genericsPlaceholders, null);
    }

    public static ClassNode replaceGenericsPlaceholders(ClassNode type, Map<String, ClassNode> genericsPlaceholders, ClassNode defaultPlaceholder) {
        if (type.isArray()) {
            return AstUtils.replaceGenericsPlaceholders(type.getComponentType(), genericsPlaceholders).makeArray();
        }
        if (!type.isUsingGenerics() && !type.isRedirectNode()) {
            return type.getPlainNodeReference();
        }
        if (type.isGenericsPlaceHolder() && genericsPlaceholders != null) {
            ClassNode placeHolderType = null;
            if (genericsPlaceholders.containsKey(type.getUnresolvedName())) {
                ClassNode classNode = genericsPlaceholders.get(type.getUnresolvedName());
                placeHolderType = (ClassNode)ScriptBytecodeAdapter.castToType((Object)classNode, ClassNode.class);
            } else {
                ClassNode classNode;
                placeHolderType = classNode = defaultPlaceholder;
            }
            if (placeHolderType != null) {
                return placeHolderType.getPlainNodeReference();
            }
            return ClassHelper.make(Object.class).getPlainNodeReference();
        }
        ClassNode nonGen = type.getPlainNodeReference();
        if ("java.lang.Object".equals(type.getName())) {
            nonGen.setGenericsPlaceHolder(false);
            nonGen.setGenericsTypes(null);
            nonGen.setUsingGenerics(false);
        } else if (type.isUsingGenerics()) {
            Object[] parameterized = type.getGenericsTypes();
            if (parameterized != null && parameterized.length > 0) {
                Object[] copiedGenericsTypes = new GenericsType[parameterized.length];
                int i = 0;
                while (i < parameterized.length) {
                    GenericsType parameterizedType = (GenericsType)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])parameterized, (int)i), GenericsType.class);
                    GenericsType copiedGenericsType = null;
                    if (parameterizedType.isPlaceholder() && genericsPlaceholders != null) {
                        GenericsType genericsType;
                        GenericsType genericsType2;
                        ClassNode placeHolderType = (ClassNode)ScriptBytecodeAdapter.castToType((Object)genericsPlaceholders.get(parameterizedType.getName()), ClassNode.class);
                        copiedGenericsType = placeHolderType != null ? (genericsType2 = new GenericsType(placeHolderType.getPlainNodeReference())) : (genericsType = new GenericsType(ClassHelper.make(Object.class).getPlainNodeReference()));
                    } else {
                        GenericsType genericsType;
                        copiedGenericsType = genericsType = new GenericsType(AstUtils.replaceGenericsPlaceholders(parameterizedType.getType(), genericsPlaceholders));
                    }
                    GenericsType genericsType = copiedGenericsType;
                    BytecodeInterface8.objectArraySet((Object[])copiedGenericsTypes, (int)i, (Object)genericsType);
                    int n = i;
                    int cfr_ignored_0 = n + 1;
                }
                nonGen.setGenericsTypes((GenericsType[])copiedGenericsTypes);
            }
        }
        return nonGen;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AstUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @groovy.transform.Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @groovy.transform.Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        ClassNode classNode;
        ClassNode classNode2;
        Parameter[] parameterArray = new Parameter[]{};
        ZERO_PARAMETERS = parameterArray;
        ClassNode[] classNodeArray = new ClassNode[]{};
        EMPTY_CLASS_ARRAY = classNodeArray;
        INTERNAL_ANNOTATION = classNode2 = ClassHelper.make(Internal.class);
        INJECT_ANNOTATION = classNode = ClassHelper.make(Inject.class);
    }
}

