/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import groovy.transform.PackageScope;
import io.micronaut.ast.groovy.annotation.GroovyAnnotationMetadataBuilder;
import io.micronaut.ast.groovy.utils.AstAnnotationUtils;
import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.ast.groovy.visitor.GroovyEnumElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.PrimitiveElement;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

public abstract class AbstractGroovyElement
implements AnnotationMetadataDelegate,
Element {
    protected final SourceUnit sourceUnit;
    protected final CompilationUnit compilationUnit;
    protected final GroovyVisitorContext visitorContext;
    private final AnnotatedNode annotatedNode;
    private AnnotationMetadata annotationMetadata;

    public AbstractGroovyElement(GroovyVisitorContext visitorContext, AnnotatedNode annotatedNode, AnnotationMetadata annotationMetadata) {
        this.visitorContext = visitorContext;
        this.compilationUnit = visitorContext.getCompilationUnit();
        this.annotatedNode = annotatedNode;
        this.annotationMetadata = annotationMetadata;
        this.sourceUnit = visitorContext.getSourceUnit();
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    public boolean isPackagePrivate() {
        return this.hasDeclaredAnnotation(PackageScope.class);
    }

    public <T extends Annotation> Element annotate(@NonNull String annotationType, @NonNull Consumer<AnnotationValueBuilder<T>> consumer) {
        ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
        AnnotationValueBuilder builder = AnnotationValue.builder((String)annotationType);
        if (consumer != null) {
            consumer.accept(builder);
            AnnotationValue av = builder.build();
            this.annotationMetadata = new GroovyAnnotationMetadataBuilder(this.sourceUnit, this.compilationUnit).annotate(this.annotationMetadata, av);
            String declaringTypeName = this instanceof MemberElement ? ((MemberElement)this).getOwningType().getName() : this.getName();
            AbstractAnnotationMetadataBuilder.addMutatedMetadata((String)declaringTypeName, (Object)this.annotatedNode, (AnnotationMetadata)this.annotationMetadata);
            AstAnnotationUtils.invalidateCache(this.annotatedNode);
        }
        return this;
    }

    protected Map<String, ClassNode> alignNewGenericsInfo(@NonNull GenericsType[] genericsTypes, @NonNull GenericsType[] redirectTypes, @NonNull Map<String, ClassNode> genericsSpec) {
        if (redirectTypes == null || redirectTypes.length != genericsTypes.length) {
            return Collections.emptyMap();
        }
        HashMap<String, ClassNode> newSpec = new HashMap<String, ClassNode>(genericsSpec.size());
        for (int i = 0; i < genericsTypes.length; ++i) {
            GenericsType genericsType = genericsTypes[i];
            GenericsType redirectType = redirectTypes[i];
            String name = genericsType.getName();
            if (genericsType.isWildcard()) {
                Object[] upperBounds = genericsType.getUpperBounds();
                if (ArrayUtils.isNotEmpty((Object[])upperBounds)) {
                    name = upperBounds[0].getUnresolvedName();
                } else {
                    ClassNode lowerBound = genericsType.getLowerBound();
                    if (lowerBound != null) {
                        name = lowerBound.getUnresolvedName();
                    }
                }
                ClassNode cn = this.resolveGenericPlaceholder(genericsSpec, name);
                this.toNewGenericSpec(genericsSpec, newSpec, redirectType.getName(), cn);
                continue;
            }
            ClassNode classNode = genericsType.getType();
            Object[] typeParameters = classNode.getGenericsTypes();
            if (ArrayUtils.isNotEmpty((Object[])typeParameters)) {
                GenericsType[] redirectParameters = classNode.redirect().getGenericsTypes();
                if (redirectParameters != null && typeParameters.length == redirectParameters.length) {
                    ArrayList<ClassNode> resolvedTypes = new ArrayList<ClassNode>(typeParameters.length);
                    for (int j = 0; j < redirectParameters.length; ++j) {
                        ClassNode type = typeParameters[j].getType();
                        if (type.isGenericsPlaceHolder()) {
                            String unresolvedName = type.getUnresolvedName();
                            ClassNode resolvedType = this.resolveGenericPlaceholder(genericsSpec, unresolvedName);
                            if (resolvedType != null) {
                                resolvedTypes.add(resolvedType);
                                continue;
                            }
                            resolvedTypes.add(type);
                            continue;
                        }
                        resolvedTypes.add(type);
                    }
                    ClassNode plainNodeReference = classNode.getPlainNodeReference();
                    plainNodeReference.setUsingGenerics(true);
                    plainNodeReference.setGenericsTypes((GenericsType[])resolvedTypes.stream().map(GenericsType::new).toArray(GenericsType[]::new));
                    newSpec.put(redirectType.getName(), plainNodeReference);
                    continue;
                }
                ClassNode cn = this.resolveGenericPlaceholder(genericsSpec, name);
                if (cn != null) {
                    newSpec.put(redirectType.getName(), cn);
                    continue;
                }
                newSpec.put(redirectType.getName(), classNode);
                continue;
            }
            ClassNode cn = this.resolveGenericPlaceholder(genericsSpec, name);
            this.toNewGenericSpec(genericsSpec, newSpec, redirectType.getName(), cn);
        }
        return newSpec;
    }

    @Nullable
    private ClassNode resolveGenericPlaceholder(@NonNull Map<String, ClassNode> genericsSpec, String name) {
        ClassNode cn;
        ClassNode classNode = genericsSpec.get(name);
        while (classNode != null && classNode.isGenericsPlaceHolder() && (cn = genericsSpec.get(classNode.getUnresolvedName())) != classNode && cn != null) {
            classNode = cn;
        }
        return classNode;
    }

    private void toNewGenericSpec(Map<String, ClassNode> genericsSpec, Map<String, ClassNode> newSpec, String name, ClassNode cn) {
        if (cn != null) {
            if (cn.isGenericsPlaceHolder()) {
                String n = cn.getUnresolvedName();
                ClassNode resolved = this.resolveGenericPlaceholder(genericsSpec, n);
                if (resolved == cn) {
                    newSpec.put(name, cn);
                } else {
                    this.toNewGenericSpec(genericsSpec, newSpec, name, resolved);
                }
            } else {
                newSpec.put(name, cn);
            }
        }
    }

    @NonNull
    protected ClassElement getGenericElement(@NonNull SourceUnit sourceUnit, @NonNull ClassNode type, @NonNull ClassElement rawElement, @NonNull Map<String, ClassNode> genericsSpec) {
        if (CollectionUtils.isNotEmpty(genericsSpec)) {
            ClassElement classNode = this.resolveGenericType(genericsSpec, type);
            if (classNode != null) {
                return classNode;
            }
            GenericsType[] genericsTypes = type.getGenericsTypes();
            GenericsType[] redirectTypes = type.redirect().getGenericsTypes();
            if (genericsTypes != null && redirectTypes != null) {
                genericsSpec = this.alignNewGenericsInfo(genericsTypes, redirectTypes, genericsSpec);
                return new GroovyClassElement(this.visitorContext, type, this.annotationMetadata, Collections.singletonMap(type.getName(), genericsSpec), 0);
            }
        }
        return rawElement;
    }

    @Deprecated
    public static ClassElement toClassElement(SourceUnit sourceUnit, CompilationUnit compilationUnit, ClassNode classNode, AnnotationMetadata annotationMetadata) {
        if (classNode.isArray()) {
            ClassNode componentType = classNode.getComponentType();
            ClassElement componentElement = AbstractGroovyElement.toClassElement(sourceUnit, compilationUnit, componentType, annotationMetadata);
            return componentElement.toArray();
        }
        if (ClassHelper.isPrimitiveType((ClassNode)classNode)) {
            return PrimitiveElement.valueOf((String)classNode.getName());
        }
        if (classNode.isEnum()) {
            return new GroovyEnumElement(new GroovyVisitorContext(sourceUnit, compilationUnit), classNode, annotationMetadata);
        }
        return new GroovyClassElement(new GroovyVisitorContext(sourceUnit, compilationUnit), classNode, annotationMetadata);
    }

    private ClassElement resolveGenericType(Map<String, ClassNode> typeGenericInfo, ClassNode returnType) {
        String unresolvedName;
        ClassNode classNode;
        ClassNode componentType;
        if (returnType.isGenericsPlaceHolder()) {
            String unresolvedName2 = returnType.getUnresolvedName();
            ClassNode classNode2 = this.resolveGenericPlaceholder(typeGenericInfo, unresolvedName2);
            if (classNode2 != null) {
                if (classNode2.isGenericsPlaceHolder() && classNode2 != returnType) {
                    return this.resolveGenericType(typeGenericInfo, classNode2);
                }
                AnnotationMetadata annotationMetadata = this.resolveAnnotationMetadata(classNode2);
                return this.visitorContext.getElementFactory().newClassElement(classNode2, annotationMetadata);
            }
        } else if (returnType.isArray() && (componentType = returnType.getComponentType()).isGenericsPlaceHolder() && (classNode = this.resolveGenericPlaceholder(typeGenericInfo, unresolvedName = componentType.getUnresolvedName())) != null) {
            if (classNode.isGenericsPlaceHolder() && classNode != returnType) {
                return this.resolveGenericType(typeGenericInfo, classNode);
            }
            ClassNode cn = classNode.makeArray();
            AnnotationMetadata annotationMetadata = this.resolveAnnotationMetadata(cn);
            return this.visitorContext.getElementFactory().newClassElement(cn, annotationMetadata);
        }
        return null;
    }

    @NonNull
    protected AnnotationMetadata resolveAnnotationMetadata(@NonNull ClassNode type) {
        AnnotationMetadata annotationMetadata = this.visitorContext.getConfiguration().includeTypeLevelAnnotationsInGenericArguments() ? AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)type) : AnnotationMetadata.EMPTY_METADATA;
        return annotationMetadata;
    }
}

