/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.utils.AstAnnotationUtils;
import io.micronaut.ast.groovy.visitor.AbstractGroovyElement;
import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.FieldElement;
import java.lang.reflect.Modifier;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.control.SourceUnit;

public class GroovyFieldElement
extends AbstractGroovyElement
implements FieldElement {
    private final Variable variable;
    private final SourceUnit sourceUnit;

    GroovyFieldElement(GroovyVisitorContext visitorContext, Variable variable, AnnotatedNode annotatedNode, AnnotationMetadata annotationMetadata) {
        super(visitorContext, annotatedNode, annotationMetadata);
        this.variable = variable;
        this.sourceUnit = visitorContext.getSourceUnit();
    }

    public String toString() {
        return this.variable.getName();
    }

    public ClassElement getGenericField() {
        if (this.isPrimitive()) {
            ClassNode cn = ClassHelper.make((Class)ClassUtils.getPrimitiveType((String)this.getType().getName()).orElse(null));
            if (cn != null) {
                return new GroovyClassElement(this.visitorContext, cn, this.getAnnotationMetadata()){

                    @Override
                    public boolean isPrimitive() {
                        return true;
                    }
                };
            }
            return this.getGenericType();
        }
        return new GroovyClassElement(this.visitorContext, (ClassNode)this.getGenericType().getNativeType(), this.getAnnotationMetadata());
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public int getArrayDimensions() {
        return this.getType().getArrayDimensions();
    }

    public String getName() {
        return this.variable.getName();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.variable.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.variable.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.variable.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.variable.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.variable.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.variable.getModifiers());
    }

    public Object getNativeType() {
        return this.variable;
    }

    @NonNull
    public ClassElement getType() {
        return this.visitorContext.getElementFactory().newClassElement(this.variable.getType(), AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)this.variable.getType()));
    }

    public ClassElement getDeclaringType() {
        ClassNode declaringClass = null;
        if (this.variable instanceof FieldNode) {
            FieldNode fn = (FieldNode)this.variable;
            declaringClass = fn.getDeclaringClass();
        } else if (this.variable instanceof PropertyNode) {
            PropertyNode pn = (PropertyNode)this.variable;
            declaringClass = pn.getDeclaringClass();
        }
        if (declaringClass == null) {
            throw new IllegalStateException("Declaring class could not be established");
        }
        return this.visitorContext.getElementFactory().newClassElement(declaringClass, AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)declaringClass));
    }
}

