/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.annotation.GroovyAnnotationMetadataBuilder;
import io.micronaut.ast.groovy.utils.AstAnnotationUtils;
import io.micronaut.ast.groovy.utils.AstClassUtils;
import io.micronaut.ast.groovy.utils.AstGenericUtils;
import io.micronaut.ast.groovy.utils.PublicMethodVisitor;
import io.micronaut.ast.groovy.visitor.AbstractGroovyElement;
import io.micronaut.ast.groovy.visitor.GroovyConstructorElement;
import io.micronaut.ast.groovy.visitor.GroovyFieldElement;
import io.micronaut.ast.groovy.visitor.GroovyMethodElement;
import io.micronaut.ast.groovy.visitor.GroovyPropertyElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ArrayableClassElement;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PrimitiveElement;
import io.micronaut.inject.ast.PropertyElement;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;

@Internal
public class GroovyClassElement
extends AbstractGroovyElement
implements ArrayableClassElement {
    private static final Predicate<MethodNode> JUNK_METHOD_FILTER = m -> {
        String methodName = m.getName();
        return !m.isStaticConstructor() && !methodName.startsWith("$") && !methodName.contains("trait$") && !methodName.startsWith("super$") && !methodName.equals("setMetaClass") && !m.getReturnType().getNameWithoutPackage().equals("MetaClass") && !m.getDeclaringClass().equals((Object)ClassHelper.GROOVY_OBJECT_TYPE) && !m.getDeclaringClass().equals((Object)ClassHelper.OBJECT_TYPE);
    };
    private static final Predicate<FieldNode> JUNK_FIELD_FILTER = m -> {
        String fieldName = m.getName();
        return !fieldName.startsWith("$") && !fieldName.startsWith("__$") && !fieldName.contains("trait$") && !fieldName.equals("metaClass") && !m.getDeclaringClass().equals((Object)ClassHelper.GROOVY_OBJECT_TYPE) && !m.getDeclaringClass().equals((Object)ClassHelper.OBJECT_TYPE);
    };
    protected final ClassNode classNode;
    private final int arrayDimensions;
    private Map<String, Map<String, ClassNode>> genericInfo;

    public GroovyClassElement(GroovyVisitorContext visitorContext, ClassNode classNode, AnnotationMetadata annotationMetadata) {
        this(visitorContext, classNode, annotationMetadata, null, 0);
    }

    GroovyClassElement(GroovyVisitorContext visitorContext, ClassNode classNode, AnnotationMetadata annotationMetadata, Map<String, Map<String, ClassNode>> genericInfo, int arrayDimensions) {
        super(visitorContext, (AnnotatedNode)classNode, annotationMetadata);
        this.classNode = classNode;
        this.genericInfo = genericInfo;
        this.arrayDimensions = arrayDimensions;
        if (classNode.isArray()) {
            classNode.setName(classNode.getComponentType().getName());
        }
    }

    public <T extends Element> List<T> getEnclosedElements(@NonNull ElementQuery<T> query) {
        List elements;
        Objects.requireNonNull(query, "Query cannot be null");
        ElementQuery.Result result = query.result();
        boolean onlyDeclared = result.isOnlyDeclared();
        boolean onlyAccessible = result.isOnlyAccessible();
        boolean onlyAbstract = result.isOnlyAbstract();
        boolean onlyConcrete = result.isOnlyConcrete();
        List namePredicates = result.getNamePredicates();
        List annotationPredicates = result.getAnnotationPredicates();
        List elementPredicates = result.getElementPredicates();
        List modifierPredicates = result.getModifierPredicates();
        Class elementType = result.getElementType();
        if (elementType == MethodElement.class) {
            Map declaredMethodsMap = this.classNode.getDeclaredMethodsMap();
            ClassNodeUtils.addDeclaredMethodsFromInterfaces((ClassNode)this.classNode, (Map)declaredMethodsMap);
            List methods = onlyDeclared ? this.classNode.getMethods().stream().filter(JUNK_METHOD_FILTER).collect(Collectors.toList()) : this.classNode.getAllDeclaredMethods().stream().filter(JUNK_METHOD_FILTER).collect(Collectors.toList());
            Iterator i = methods.iterator();
            while (i.hasNext()) {
                MethodNode methodNode2 = (MethodNode)i.next();
                if (onlyAbstract && !methodNode2.isAbstract()) {
                    i.remove();
                    continue;
                }
                if (onlyConcrete && methodNode2.isAbstract()) {
                    i.remove();
                    continue;
                }
                if (onlyAccessible) {
                    if (methodNode2.isPrivate()) {
                        i.remove();
                        continue;
                    }
                    if (!methodNode2.getDeclaringClass().equals((Object)this.classNode) && methodNode2.isPackageScope() && !methodNode2.getDeclaringClass().getPackageName().equals(this.getPackageName())) {
                        i.remove();
                        continue;
                    }
                }
                if (!modifierPredicates.isEmpty()) {
                    Set<ElementModifier> elementModifiers = this.resolveModifiers(methodNode2);
                    if (!modifierPredicates.stream().allMatch(p -> p.test(elementModifiers))) {
                        i.remove();
                        continue;
                    }
                }
                if (namePredicates.isEmpty() || namePredicates.stream().allMatch(p -> p.test(methodNode2.getName()))) continue;
                i.remove();
            }
            elements = methods.stream().map(methodNode -> new GroovyMethodElement(this, this.visitorContext, (MethodNode)methodNode, AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)methodNode))).collect(Collectors.toList());
        } else if (elementType == FieldElement.class) {
            List<Object> fields;
            if (onlyDeclared) {
                List initialFields = this.classNode.getFields();
                fields = this.findRelevantFields(onlyAccessible, initialFields, namePredicates, modifierPredicates);
            } else {
                fields = new ArrayList(this.classNode.getFields());
                for (ClassNode superClass = this.classNode.getSuperClass(); superClass != null && !superClass.equals((Object)ClassHelper.OBJECT_TYPE); superClass = superClass.getSuperClass()) {
                    fields.addAll(superClass.getFields());
                }
                fields = this.findRelevantFields(onlyAccessible, fields, namePredicates, modifierPredicates);
            }
            elements = fields.stream().map(fieldNode -> new GroovyFieldElement(this.visitorContext, (Variable)fieldNode, (AnnotatedNode)fieldNode, AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)fieldNode))).collect(Collectors.toList());
        } else {
            elements = Collections.emptyList();
        }
        if (!elements.isEmpty()) {
            if (!annotationPredicates.isEmpty()) {
                elements.removeIf(e -> !annotationPredicates.stream().allMatch(p -> p.test(e.getAnnotationMetadata())));
            }
            if (!elements.isEmpty() && !elementPredicates.isEmpty()) {
                elements.removeIf(e -> !elementPredicates.stream().allMatch(p -> p.test(e)));
            }
        }
        return elements;
    }

    private List<FieldNode> findRelevantFields(boolean onlyAccessible, List<FieldNode> initialFields, List<Predicate<String>> namePredicates, List<Predicate<Set<ElementModifier>>> modifierPredicates) {
        Stream<FieldNode> fieldStream = initialFields.stream().filter(JUNK_FIELD_FILTER);
        if (onlyAccessible) {
            fieldStream = fieldStream.filter(fn -> !fn.isPrivate());
        }
        if (!namePredicates.isEmpty()) {
            fieldStream = fieldStream.filter(fn -> !namePredicates.stream().allMatch(p -> p.test(fn.getName())));
        }
        if (!modifierPredicates.isEmpty()) {
            fieldStream = fieldStream.filter(fn -> !modifierPredicates.stream().allMatch(p -> p.test(this.resolveModifiers((FieldNode)fn))));
        }
        return fieldStream.collect(Collectors.toList());
    }

    private Set<ElementModifier> resolveModifiers(MethodNode methodNode) {
        HashSet<ElementModifier> modifiers = new HashSet<ElementModifier>(5);
        if (methodNode.isPrivate()) {
            modifiers.add(ElementModifier.PRIVATE);
        } else if (methodNode.isProtected()) {
            modifiers.add(ElementModifier.PROTECTED);
        } else if (methodNode.isPublic()) {
            modifiers.add(ElementModifier.PUBLIC);
        }
        if (methodNode.isAbstract()) {
            modifiers.add(ElementModifier.ABSTRACT);
        } else if (methodNode.isStatic()) {
            modifiers.add(ElementModifier.STATIC);
        }
        if (methodNode.isFinal()) {
            modifiers.add(ElementModifier.FINAL);
        }
        return modifiers;
    }

    private Set<ElementModifier> resolveModifiers(FieldNode fieldNode) {
        HashSet<ElementModifier> modifiers = new HashSet<ElementModifier>(5);
        if (fieldNode.isPrivate()) {
            modifiers.add(ElementModifier.PRIVATE);
        } else if (fieldNode.isProtected()) {
            modifiers.add(ElementModifier.PROTECTED);
        } else if (fieldNode.isPublic()) {
            modifiers.add(ElementModifier.PUBLIC);
        }
        if (fieldNode.isStatic()) {
            modifiers.add(ElementModifier.STATIC);
        }
        if (fieldNode.isFinal()) {
            modifiers.add(ElementModifier.FINAL);
        }
        return modifiers;
    }

    public boolean isInner() {
        return this.classNode instanceof InnerClassNode;
    }

    public boolean isInterface() {
        return this.classNode.isInterface();
    }

    public boolean isPrimitive() {
        return this.classNode.isArray() && ClassUtils.getPrimitiveType((String)this.classNode.getComponentType().getName()).isPresent();
    }

    public Optional<ClassElement> getSuperType() {
        ClassNode superClass = this.classNode.getSuperClass();
        if (superClass != null && !superClass.equals((Object)ClassHelper.OBJECT_TYPE)) {
            return Optional.of(this.visitorContext.getElementFactory().newClassElement(superClass, AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)superClass)));
        }
        return Optional.empty();
    }

    @NonNull
    public Optional<MethodElement> getPrimaryConstructor() {
        MethodNode method = this.findStaticCreator();
        if (method == null) {
            method = this.findConcreteConstructor();
        }
        return this.createMethodElement(method);
    }

    @NonNull
    public Optional<MethodElement> getDefaultConstructor() {
        MethodNode method = this.findDefaultStaticCreator();
        if (method == null) {
            method = this.findDefaultConstructor();
        }
        return this.createMethodElement(method);
    }

    private Optional<MethodElement> createMethodElement(MethodNode method) {
        return Optional.ofNullable(method).map(executableElement -> {
            AnnotationMetadata annotationMetadata = AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)executableElement);
            if (executableElement instanceof ConstructorNode) {
                return new GroovyConstructorElement(this, this.visitorContext, (ConstructorNode)executableElement, annotationMetadata);
            }
            return new GroovyMethodElement(this, this.visitorContext, (MethodNode)executableElement, annotationMetadata);
        });
    }

    public Map<String, Map<String, ClassNode>> getGenericTypeInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = AstGenericUtils.buildAllGenericElementInfo(this.classNode, new GroovyVisitorContext(this.sourceUnit, this.compilationUnit));
        }
        return this.genericInfo;
    }

    @NonNull
    public Map<String, ClassElement> getTypeArguments(@NonNull String type) {
        Map<String, Map<String, ClassNode>> allData = this.getGenericTypeInfo();
        Map<String, ClassNode> thisSpec = allData.get(this.getName());
        Map<String, ClassNode> forType = allData.get(type);
        if (forType != null) {
            LinkedHashMap<String, ClassElement> typeArgs = new LinkedHashMap<String, ClassElement>(forType.size());
            for (Map.Entry<String, ClassNode> entry : forType.entrySet()) {
                ClassNode classNode = entry.getValue();
                AnnotationMetadata annotationMetadata = this.resolveAnnotationMetadata(classNode);
                ClassElement rawElement = this.visitorContext.getElementFactory().newClassElement(classNode, annotationMetadata);
                if (thisSpec != null) {
                    rawElement = this.getGenericElement(this.sourceUnit, classNode, rawElement, thisSpec);
                }
                typeArgs.put(entry.getKey(), rawElement);
            }
            return Collections.unmodifiableMap(typeArgs);
        }
        return Collections.emptyMap();
    }

    @NonNull
    public Map<String, Map<String, ClassElement>> getAllTypeArguments() {
        Map<String, Map<String, ClassNode>> genericInfo = AstGenericUtils.buildAllGenericElementInfo(this.classNode, new GroovyVisitorContext(this.sourceUnit, this.compilationUnit));
        LinkedHashMap<String, Map<String, ClassElement>> results = new LinkedHashMap<String, Map<String, ClassElement>>(genericInfo.size());
        genericInfo.forEach((name, generics) -> {
            LinkedHashMap resolved = new LinkedHashMap(generics.size());
            generics.forEach((variable, type) -> {
                AnnotationMetadata annotationMetadata = this.resolveAnnotationMetadata((ClassNode)type);
                resolved.put(variable, new GroovyClassElement(this.visitorContext, (ClassNode)type, annotationMetadata));
            });
            results.put((String)name, resolved);
        });
        results.put(this.getName(), this.getTypeArguments());
        return results;
    }

    @NonNull
    public Map<String, ClassElement> getTypeArguments() {
        Map<String, Map<String, ClassNode>> genericInfo = this.getGenericTypeInfo();
        Map<String, ClassNode> info = genericInfo.get(this.classNode.getName());
        return this.resolveGenericMap(info);
    }

    @NonNull
    private Map<String, ClassElement> resolveGenericMap(Map<String, ClassNode> info) {
        Map<String, ClassNode> spec;
        if (info != null) {
            ClassNode cn;
            LinkedHashMap<String, ClassElement> typeArgumentMap = new LinkedHashMap<String, ClassElement>(info.size());
            GenericsType[] genericsTypes = this.classNode.getGenericsTypes();
            GenericsType[] redirectTypes = this.classNode.redirect().getGenericsTypes();
            if (genericsTypes != null && redirectTypes != null && genericsTypes.length == redirectTypes.length) {
                for (int i = 0; i < genericsTypes.length; ++i) {
                    GenericsType gt = genericsTypes[i];
                    GenericsType redirectType = redirectTypes[i];
                    if (gt.isPlaceholder()) {
                        ClassNode cn2 = this.resolveTypeArgument(info, redirectType.getName());
                        if (cn2 == null) continue;
                        Map<String, ClassNode> newInfo = this.alignNewGenericsInfo(genericsTypes, redirectTypes, info);
                        AnnotationMetadata annotationMetadata = this.resolveAnnotationMetadata(cn2);
                        typeArgumentMap.put(redirectType.getName(), (ClassElement)new GroovyClassElement(this.visitorContext, cn2, annotationMetadata, Collections.singletonMap(cn2.getName(), newInfo), cn2.isArray() ? this.computeDimensions(cn2) : 0));
                        continue;
                    }
                    String unresolvedName = redirectType.getType().getUnresolvedName();
                    cn = info.get(unresolvedName);
                    ClassNode type = cn != null ? cn : gt.getType();
                    AnnotationMetadata annotationMetadata = this.resolveAnnotationMetadata(type);
                    typeArgumentMap.put(redirectType.getName(), (ClassElement)new GroovyClassElement(this.visitorContext, type, annotationMetadata, Collections.emptyMap(), type.isArray() ? this.computeDimensions(type) : 0));
                }
            } else if (redirectTypes != null) {
                for (GenericsType gt : redirectTypes) {
                    String name = gt.getName();
                    cn = this.resolveTypeArgument(info, name);
                    if (cn == null) continue;
                    Map<Object, Object> newInfo = Collections.emptyMap();
                    if (genericsTypes != null) {
                        newInfo = this.alignNewGenericsInfo(genericsTypes, redirectTypes, info);
                    }
                    AnnotationMetadata annotationMetadata = this.resolveAnnotationMetadata(cn);
                    typeArgumentMap.put(gt.getName(), (ClassElement)new GroovyClassElement(this.visitorContext, cn, annotationMetadata, Collections.singletonMap(cn.getName(), newInfo), cn.isArray() ? this.computeDimensions(cn) : 0));
                }
            }
            if (CollectionUtils.isNotEmpty(typeArgumentMap)) {
                return typeArgumentMap;
            }
        }
        if (!(spec = AstGenericUtils.createGenericsSpec(this.classNode)).isEmpty()) {
            LinkedHashMap<String, ClassElement> map = new LinkedHashMap<String, ClassElement>(spec.size());
            for (Map.Entry<String, ClassNode> entry : spec.entrySet()) {
                ClassNode cn = entry.getValue();
                AnnotationMetadata annotationMetadata = this.resolveAnnotationMetadata(cn);
                ClassElement classElement = this.visitorContext.getElementFactory().newClassElement(cn, annotationMetadata);
                map.put(entry.getKey(), classElement);
            }
            return Collections.unmodifiableMap(map);
        }
        return Collections.emptyMap();
    }

    @Nullable
    private ClassNode resolveTypeArgument(Map<String, ClassNode> info, String name) {
        ClassNode next;
        ClassNode cn = info.get(name);
        while (cn != null && cn.isGenericsPlaceHolder() && (next = info.get(name = cn.getUnresolvedName())) != cn) {
            cn = next;
        }
        return cn;
    }

    private int computeDimensions(ClassNode cn) {
        int i = 1;
        for (ClassNode componentType = cn.getComponentType(); componentType != null && componentType.isArray(); componentType = componentType.getComponentType()) {
            ++i;
        }
        return i;
    }

    public List<PropertyElement> getBeanProperties() {
        List propertyNodes = this.classNode.getProperties();
        ArrayList<GroovyPropertyElement> propertyElements = new ArrayList<GroovyPropertyElement>();
        final HashSet<String> groovyProps = new HashSet<String>();
        for (final PropertyNode propertyNode : propertyNodes) {
            if (!propertyNode.isPublic() || propertyNode.isStatic()) continue;
            final String propertyName = propertyNode.getName();
            groovyProps.add(propertyName);
            final boolean readOnly = propertyNode.getField().isFinal();
            final AnnotationMetadata annotationMetadata = AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)propertyNode.getField());
            GroovyPropertyElement groovyPropertyElement = new GroovyPropertyElement(this.visitorContext, this, (AnnotatedNode)propertyNode.getField(), annotationMetadata, propertyName, readOnly, propertyNode){

                @NonNull
                public ClassElement getType() {
                    ClassNode type = propertyNode.getType();
                    return this.visitorContext.getElementFactory().newClassElement(type, AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)type));
                }

                public Optional<MethodElement> getWriteMethod() {
                    if (!readOnly) {
                        return Optional.of(MethodElement.of((ClassElement)GroovyClassElement.this, (AnnotationMetadata)annotationMetadata, (ClassElement)PrimitiveElement.VOID, (ClassElement)PrimitiveElement.VOID, (String)NameUtils.setterNameFor((String)propertyName), (ParameterElement[])new ParameterElement[]{ParameterElement.of((ClassElement)this.getType(), (String)propertyName)}));
                    }
                    return Optional.empty();
                }

                public Optional<MethodElement> getReadMethod() {
                    return Optional.of(MethodElement.of((ClassElement)GroovyClassElement.this, (AnnotationMetadata)annotationMetadata, (ClassElement)this.getType(), (ClassElement)this.getGenericType(), (String)this.getGetterName(propertyName, this.getType()), (ParameterElement[])new ParameterElement[0]));
                }

                private String getGetterName(String propertyName2, ClassElement type) {
                    return NameUtils.getterNameFor((String)propertyName2, (type.equals(PrimitiveElement.BOOLEAN) || type.getName().equals(Boolean.class.getName()) ? 1 : 0) != 0);
                }
            };
            propertyElements.add(groovyPropertyElement);
        }
        final LinkedHashMap props = new LinkedHashMap();
        for (ClassNode classNode = this.classNode; classNode != null && !classNode.equals((Object)ClassHelper.OBJECT_TYPE) && !classNode.equals((Object)ClassHelper.Enum_Type); classNode = classNode.getSuperClass()) {
            classNode.visitContents((GroovyClassVisitor)new PublicMethodVisitor(null){

                @Override
                protected boolean isAcceptable(MethodNode node) {
                    boolean validModifiers;
                    boolean bl = validModifiers = node.isPublic() && !node.isStatic() && !node.isSynthetic() && !node.isAbstract();
                    if (validModifiers) {
                        String methodName = node.getName();
                        if (methodName.contains("$") || methodName.equals("getMetaClass")) {
                            return false;
                        }
                        if (NameUtils.isGetterName((String)methodName) && node.getParameters().length == 0) {
                            return true;
                        }
                        return NameUtils.isSetterName((String)methodName) && node.getParameters().length == 1;
                    }
                    return validModifiers;
                }

                @Override
                public void accept(ClassNode classNode, MethodNode node) {
                    String methodName = node.getName();
                    ClassNode declaringTypeElement = node.getDeclaringClass();
                    if (NameUtils.isGetterName((String)methodName) && node.getParameters().length == 0) {
                        String propertyName = NameUtils.getPropertyNameForGetter((String)methodName);
                        if (groovyProps.contains(propertyName)) {
                            return;
                        }
                        ClassNode returnTypeNode = node.getReturnType();
                        ClassElement getterReturnType = null;
                        if (returnTypeNode.isGenericsPlaceHolder()) {
                            String placeHolderName = returnTypeNode.getUnresolvedName();
                            ClassElement classElement = GroovyClassElement.this.getTypeArguments().get(placeHolderName);
                            if (classElement != null) {
                                getterReturnType = classElement;
                            }
                        }
                        if (getterReturnType == null) {
                            getterReturnType = GroovyClassElement.this.visitorContext.getElementFactory().newClassElement(returnTypeNode, AnnotationMetadata.EMPTY_METADATA);
                        }
                        GetterAndSetter getterAndSetter = props.computeIfAbsent(propertyName, x$0 -> new GetterAndSetter((String)x$0));
                        this.configureDeclaringType(declaringTypeElement, getterAndSetter);
                        getterAndSetter.type = getterReturnType;
                        getterAndSetter.getter = node;
                        if (getterAndSetter.setter != null) {
                            ClassNode typeMirror = getterAndSetter.setter.getParameters()[0].getType();
                            ClassElement setterParameterType = GroovyClassElement.this.visitorContext.getElementFactory().newClassElement(typeMirror, AnnotationMetadata.EMPTY_METADATA);
                            if (!setterParameterType.getName().equals(getterReturnType.getName())) {
                                getterAndSetter.setter = null;
                            }
                        }
                    } else if (NameUtils.isSetterName((String)methodName) && node.getParameters().length == 1) {
                        String propertyName = NameUtils.getPropertyNameForSetter((String)methodName);
                        if (groovyProps.contains(propertyName)) {
                            return;
                        }
                        ClassNode typeMirror = node.getParameters()[0].getType();
                        ClassElement setterParameterType = GroovyClassElement.this.visitorContext.getElementFactory().newClassElement(typeMirror, AnnotationMetadata.EMPTY_METADATA);
                        GetterAndSetter getterAndSetter = props.computeIfAbsent(propertyName, x$0 -> new GetterAndSetter((String)x$0));
                        this.configureDeclaringType(declaringTypeElement, getterAndSetter);
                        ClassElement propertyType = getterAndSetter.type;
                        if (propertyType != null) {
                            if (propertyType.getName().equals(setterParameterType.getName())) {
                                getterAndSetter.setter = node;
                            }
                        } else {
                            getterAndSetter.setter = node;
                        }
                    }
                }

                private void configureDeclaringType(ClassNode declaringTypeElement, GetterAndSetter beanPropertyData) {
                    if (beanPropertyData.declaringType == null && !GroovyClassElement.this.classNode.equals((Object)declaringTypeElement)) {
                        beanPropertyData.declaringType = new GroovyClassElement(GroovyClassElement.this.visitorContext, declaringTypeElement, AstAnnotationUtils.getAnnotationMetadata(GroovyClassElement.this.sourceUnit, GroovyClassElement.this.compilationUnit, (AnnotatedNode)declaringTypeElement));
                    }
                }
            });
        }
        if (!props.isEmpty()) {
            final GroovyClassElement thisElement = this;
            for (Map.Entry entry : props.entrySet()) {
                String propertyName = (String)entry.getKey();
                final GetterAndSetter value = (GetterAndSetter)entry.getValue();
                if (value.getter == null) continue;
                final GroovyAnnotationMetadataBuilder groovyAnnotationMetadataBuilder = new GroovyAnnotationMetadataBuilder(this.sourceUnit, this.compilationUnit);
                FieldNode field = this.classNode.getField(propertyName);
                final AnnotationMetadata annotationMetadata = field != null ? AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)field, (AnnotatedNode)value.getter) : groovyAnnotationMetadataBuilder.buildForMethod(value.getter);
                GroovyPropertyElement propertyElement = new GroovyPropertyElement(this.visitorContext, value.declaringType == null ? this : value.declaringType, (AnnotatedNode)value.getter, annotationMetadata, propertyName, value.setter == null, value.getter){

                    public Optional<MethodElement> getWriteMethod() {
                        if (value.setter != null) {
                            return Optional.of(new GroovyMethodElement(thisElement, this.visitorContext, value.setter, groovyAnnotationMetadataBuilder.buildForMethod(value.setter)));
                        }
                        return Optional.empty();
                    }

                    @NonNull
                    public ClassElement getType() {
                        return value.type;
                    }

                    public Optional<MethodElement> getReadMethod() {
                        return Optional.of(new GroovyMethodElement(thisElement, this.visitorContext, value.getter, annotationMetadata));
                    }
                };
                propertyElements.add(propertyElement);
            }
        }
        return Collections.unmodifiableList(propertyElements);
    }

    public boolean isArray() {
        return this.arrayDimensions > 0;
    }

    public ClassElement withArrayDimensions(int arrayDimensions) {
        return new GroovyClassElement(this.visitorContext, this.classNode, this.getAnnotationMetadata(), this.getGenericTypeInfo(), arrayDimensions);
    }

    public int getArrayDimensions() {
        return this.arrayDimensions;
    }

    public String toString() {
        return this.classNode.getName();
    }

    public String getName() {
        return this.classNode.getName();
    }

    public String getSimpleName() {
        return this.classNode.getNameWithoutPackage();
    }

    public String getPackageName() {
        return this.classNode.getPackageName();
    }

    public boolean isAbstract() {
        return this.classNode.isAbstract();
    }

    public boolean isStatic() {
        return this.classNode.isStaticClass();
    }

    public boolean isPublic() {
        return (this.classNode.isSyntheticPublic() || Modifier.isPublic(this.classNode.getModifiers())) && !this.isPackagePrivate();
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.classNode.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.classNode.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.classNode.getModifiers());
    }

    public Object getNativeType() {
        return this.classNode;
    }

    public boolean isAssignable(String type) {
        return AstClassUtils.isSubclassOfOrImplementsInterface(this.classNode, type);
    }

    public boolean isAssignable(ClassElement type) {
        return AstClassUtils.isSubclassOfOrImplementsInterface(this.classNode, type.getName());
    }

    private MethodNode findConcreteConstructor() {
        MethodNode methodNode;
        List constructors = this.classNode.getDeclaredConstructors();
        if (CollectionUtils.isEmpty((Collection)constructors) && !this.classNode.isAbstract() && !this.classNode.isEnum()) {
            return new ConstructorNode(1, (Statement)new BlockStatement());
        }
        List nonPrivateConstructors = this.findNonPrivateMethods(constructors);
        if (nonPrivateConstructors.size() == 1) {
            methodNode = (MethodNode)nonPrivateConstructors.get(0);
        } else {
            methodNode = nonPrivateConstructors.stream().filter(cn -> !cn.getAnnotations(ClassHelper.makeCached(Inject.class)).isEmpty() || !cn.getAnnotations(ClassHelper.makeCached(Creator.class)).isEmpty()).findFirst().orElse(null);
            if (methodNode == null) {
                methodNode = nonPrivateConstructors.stream().filter(cn -> Modifier.isPublic(cn.getModifiers())).findFirst().orElse(null);
            }
        }
        return methodNode;
    }

    private MethodNode findDefaultConstructor() {
        List constructors = this.classNode.getDeclaredConstructors();
        if (CollectionUtils.isEmpty((Collection)constructors) && !this.classNode.isEnum()) {
            return new ConstructorNode(1, (Statement)new BlockStatement());
        }
        if ((constructors = this.findNonPrivateMethods(constructors).stream().filter(ctor -> ctor.getParameters().length == 0).collect(Collectors.toList())).isEmpty()) {
            return null;
        }
        if (constructors.size() == 1) {
            return (MethodNode)constructors.get(0);
        }
        return constructors.stream().filter(method -> Modifier.isPublic(method.getModifiers())).findFirst().orElse(null);
    }

    private MethodNode findStaticCreator() {
        List<Object> creators = this.findNonPrivateStaticCreators();
        if (creators.isEmpty()) {
            return null;
        }
        if (creators.size() == 1) {
            return creators.get(0);
        }
        List withArgs = creators.stream().filter(method -> method.getParameters().length > 0).collect(Collectors.toList());
        if (withArgs.size() == 1) {
            return (MethodNode)withArgs.get(0);
        }
        creators = withArgs;
        return creators.stream().filter(method -> Modifier.isPublic(method.getModifiers())).findFirst().orElse(null);
    }

    private MethodNode findDefaultStaticCreator() {
        List creators = this.findNonPrivateStaticCreators().stream().filter(ctor -> ctor.getParameters().length == 0).collect(Collectors.toList());
        if (creators.isEmpty()) {
            return null;
        }
        if (creators.size() == 1) {
            return (MethodNode)creators.get(0);
        }
        return creators.stream().filter(method -> Modifier.isPublic(method.getModifiers())).findFirst().orElse(null);
    }

    private <T extends MethodNode> List<T> findNonPrivateMethods(List<T> methodNodes) {
        ArrayList<MethodNode> nonPrivateMethods = new ArrayList<MethodNode>(2);
        for (MethodNode node : methodNodes) {
            if (Modifier.isPrivate(node.getModifiers())) continue;
            nonPrivateMethods.add(node);
        }
        return nonPrivateMethods;
    }

    private List<MethodNode> findNonPrivateStaticCreators() {
        List<Object> creators = this.classNode.getAllDeclaredMethods().stream().filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> !Modifier.isPrivate(method.getModifiers())).filter(method -> method.getReturnType().equals((Object)this.classNode)).filter(method -> method.getAnnotations(ClassHelper.makeCached(Creator.class)).size() > 0).collect(Collectors.toList());
        if (creators.isEmpty() && this.classNode.isEnum()) {
            creators = this.classNode.getAllDeclaredMethods().stream().filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> !Modifier.isPrivate(method.getModifiers())).filter(method -> method.getReturnType().equals((Object)this.classNode)).filter(method -> method.getName().equals("valueOf")).collect(Collectors.toList());
        }
        return creators;
    }

    private class GetterAndSetter {
        ClassElement type;
        GroovyClassElement declaringType;
        MethodNode getter;
        MethodNode setter;
        final String propertyName;

        GetterAndSetter(String propertyName) {
            this.propertyName = propertyName;
        }
    }
}

